package gov.va.med.cds.filter;

import java.util.Calendar;
import java.util.List;

public interface EntryFilterInterface {

	/**
	 * Gets the value of the domainEntryPoint property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	String getDomainEntryPoint();

	/**
	 * Gets the request identifier for the filter request.
	 * 
	 * @return The request identifier.
	 */
	String getRequestId();

	/**
	 * Gets the template identifier for the filter request.
	 * 
	 * @return The template identifier.
	 */
	String getTemplateId();

	/**
	 * Gets the value of the startDate property.
	 * 
	 * @return possible object is {@link Calendar }
	 * 
	 */
	Calendar getStartDate();

	/**
	 * Gets the value of the endDate property.
	 * 
	 * @return possible object is {@link Calendar }
	 * 
	 */
	Calendar getEndDate();

	/**
	 * Gets the value of the record property.
	 * 
	 * <p>
	 * This accessor method returns a reference to the live list, not a
	 * snapshot. Therefore any modification you make to the returned list will
	 * be present inside the JAXB object. This is why there is not a
	 * <CODE>set</CODE> method for the record property.
	 * 
	 * <p>
	 * For example, to add a new item, do as follows:
	 * 
	 * <pre>
	 * getRecord().add(newItem);
	 * </pre>
	 * 
	 * 
	 * <p>
	 * Objects of the following type(s) are allowed in the list {@link String }
	 * 
	 * 
	 */
	List<String> getRecordIdentifiers();

	/**
	 * Gets the value of the xpathQuery property.
	 * 
	 * @return possible object is {@link XpathQuery }
	 * 
	 */
	String getXpathQuery();

	/**
	 * Gets the value of the queryName property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	String getQueryName();

	/**
	 * Gets the value of the AdditionalParametersMap property
	 */
	ParameterMapInterface getAdditionalParametersMap();

	/**
	 * Return an indicator to determine whether to use dates in the query
	 * 
	 * @return
	 */
	boolean useDates();

	/**
	 * Return the time out for the filter in seconds
	 * 
	 * @return
	 */
	Long getTimeout();

	/**
	 * Check if it is a patient centric query.
	 */
	boolean isPatientCentricFilter();
	
    String getXpathFilterExpression( );

    String getXpathExtractExpression( );
    
    /**
     * @return True if entry filter is to return the count of records only; otherwise false.
     */
    boolean isCountOnly();

    /**
     * Gets the number of the page specified by the client, if a paging filter has been specified by the client.
     * @return The page number from the filter.
     */
    int getPageNumber();
    
    /**
     * Gets the page size (records per page) specified by the client, if a paging filter has been specified by the client.
     * @return The number of records per page.
     */
    int getPageSize();

    /**
     * @return Returns true if this filter is a paging query; otherwise returns false.
     */
    boolean isPagingFilter( );
    
    /**
     * @returns True if the filter contains record identifiers to query by; otherwise false.
     */
    boolean hasRecordIdentifiers();
    
    /**
     * @return True if the filter contains an XPath filter expression; otherwise false.
     */
    boolean containsXpathFilterExpression();
    
    /**
     * @return Gets name space of the extract expression if one was provided in the filter.
     */
    String getXpathExtractExpressionNamespace( );
    
    /**
     * @return Gets name space of the filter expression if one was provided in the filter.
     */
    String getXpathFilterExpressionNamespace( );
}
