

package gov.va.med.cds;


import gov.va.med.cds.client.ClinicalDataServiceInterface;
import gov.va.med.cds.request.RequestProcessorInterface;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**delegatingRequestProcessor
 * 
 * Handles the sync/async CRUAD calls forwarded from gov.va.med.cds.client.ClinicalDataServiceDelegate.
 * 
 */
public class DefaultClinicalDatasServiceSynchronous
implements
ClinicalDataServiceInterface
{
	private Log logger = LogFactory.getLog( DefaultClinicalDatasServiceSynchronous.class );
	private RequestProcessorInterface requestProcessor = null;

	
	/**
	 * 
	 * @see gov.va.med.cds.client.ClinicalDataServiceInterface#isAlive()
	 */
	public boolean isAlive( )
	{
		return true;
	}


	/**
	 * 
	 * @see gov.va.med.cds.client.ClinicalDataServiceInterface#deleteClinicalData(java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	public String deleteClinicalData( String request, String templateId, String requestId )
	{
		return requestProcessor.deleteClinicalData( request, templateId, requestId ).asXML();
	}


	/**
	 * 
	 * @see gov.va.med.cds.client.ClinicalDataServiceInterface#readClinicalData(java.lang.String,
	 *      java.lang.String, java.lang.String, java.lang.String)
	 */
	public String readClinicalData( String templateId, String filterXmlRequest, String filterId, String requestId )
	{
	    return requestProcessor.readClinicalData( templateId, filterXmlRequest, filterId, requestId ).asXML();
	}


	/**
	 * 
	 * @see gov.va.med.cds.client.ClinicalDataServiceInterface#readClinicalData(java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	public String readClinicalData( String templateId, String filterXmlRequest, String requestId )
	{
	    return requestProcessor.readClinicalData( templateId, filterXmlRequest, null, requestId ).asXML();
	}


	/**
	 * 
	 * @see gov.va.med.cds.client.ClinicalDataServiceInterface#updateClinicalData(java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	public String updateClinicalData( String request, String templateId, String requestId )
	{
		return requestProcessor.updateClinicalData( request, templateId, requestId ).asXML();
	}


	/**
	 * 
	 * @see gov.va.med.cds.client.ClinicalDataServiceInterface#appendClinicalData(java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	public String appendClinicalData( String request, String templateId, String requestId )
	{
		return requestProcessor.appendClinicalData( request, templateId, requestId ).asXML();
	}


	/**
	 * 
	 * @see gov.va.med.cds.client.ClinicalDataServiceInterface#createClinicalData(java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	public String createClinicalData( String request, String templateId, String requestId )
	{
		return requestProcessor.createClinicalData( request, templateId, requestId ).asXML();
	}


	public void setRequestProcessor( RequestProcessorInterface requestProcessor )
	{
		this.requestProcessor = requestProcessor;
	}

}
