package gov.va.med.cds.client;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import gov.va.med.cds.client.webservice.ClinicalDataServiceSynchronousInterfaceLocator;
import gov.va.med.cds.junit.runners.Suite;
import gov.va.med.cds.junit.runners.SuiteAwareRunner;

import javax.xml.rpc.ServiceException;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith( SuiteAwareRunner.class )
public class ClinicalDataServiceProxyTest {

	ClinicalDataServiceSynchronousInterfaceLocator cdsServiceLocator = null;
	gov.va.med.cds.client.webservice.ClinicalDataServiceInterface port = null;
	ClinicalDataServiceProxy serviceDelegate = null;
	    
	@Test
    @Suite( groups = { "checkintest" } )
	public void testProxy() 
	{

    	cdsServiceLocator = new ClinicalDataServiceSynchronousInterfaceLocator();
		
		try
		{
			cdsServiceLocator.setEndpointAddress(new javax.xml.namespace.QName(	"http://client.cds.domain.ext", "ClinicalDataServiceSynchronousInterfaceHttpPort"), "http://IP__ADDRESS:PORT/cds-wsclient/cds-service?wsdl" );
			port = cdsServiceLocator.getClinicalDataServiceSynchronousInterfaceHttpPort();
		} 
		catch (ServiceException e) 
		{
			e.printStackTrace();
		}
		
		assertNotNull(port);
		serviceDelegate = new ClinicalDataServiceProxy();
		serviceDelegate.setProxy(port);
		assertNotNull(serviceDelegate);
	}

}
