

package gov.va.med.cds.client;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

@WebService(name = "ClinicalDataServiceSynchronousInterface" , targetNamespace = "http://client.cds.domain.ext")
@SOAPBinding(style = SOAPBinding.Style.RPC)
public interface ClinicalDataServiceInterface
{
/**
 * Check to see if system is running
 *
 * @return true if the system is running.
 */
@WebMethod(operationName="isAlive")
@RequestWrapper(className="java.lang.String")
@ResponseWrapper(className="java.lang.Boolean")
@WebResult(name="out")boolean isAlive( );


/**
 * Synchronous version of a clinical data read
 *
 * @param templateId ID of the template for which the filter request applies
 * @param filterRequest Filter request specified in xml format according to the CDS filter schema
 * @param filterId ID of the named (canned) filter. The filterId may be null if no canned filter is referenced
 * @param requestId Client specified unique request Id
 * @return Results of the read returned in XML according to the CDS read results schema
 */
@WebMethod(operationName="readClinicalData1")
@RequestWrapper(className="java.lang.String")
@ResponseWrapper(className="java.lang.String")
public @WebResult(name="out")String readClinicalData( @WebParam(name="in0")String templateId, @WebParam(name="in1")String filterRequest, @WebParam(name="in2")String filterId, @WebParam(name="in3")String requestId );


/**
 * Synchronous version of a clinical data read
 *
 * @param templateId ID of the template for which the filter request applies
 * @param filterId ID of the named (canned) filter
 * @param requestId Client specified unique request Id
 * @return Results of the read returned in XML according to the CDS read results schema
 */
@WebMethod(operationName="readClinicalData")
@RequestWrapper(className="java.lang.String")
@ResponseWrapper(className="java.lang.String")
@WebResult(name="out")String readClinicalData( @WebParam(name="in0")String templateId, @WebParam(name="in1")String filterId, @WebParam(name="in2")String requestId );


/**
 * Synchronous version of a clinical data create
 *
 * @param createRequest Write request specified in XML according to the CDS create request schema
 * @param templateId ID of the template for which the create request applies
 * @param requestId Client specified unique request Id
 * @return Results of the create returned in XML according the CDS create results schema
 */
@WebMethod(operationName="createClinicalData")
@RequestWrapper(className="java.lang.String")
@ResponseWrapper(className="java.lang.String")
@WebResult(name="out")String createClinicalData( @WebParam(name="in0")String createRequest, @WebParam(name="in1")String templateId, @WebParam(name="in2")String requestId );


/**
 * Synchronous version of a clinical data update
 *
 * @param updateRequest Update request specified in XML according to the CDS update request schema
 * @param templateId ID of the template for which the update request applies
 * @param requestId Client specified unique request Id
 * @return Results of the update returned in XML according the CDS update results schema
 */
@WebMethod(operationName="updateClinicalData")
@RequestWrapper(className="java.lang.String")
@ResponseWrapper(className="java.lang.String")
@WebResult(name="out")String updateClinicalData( @WebParam(name="in0")String updateRequest, @WebParam(name="in1")String templateId, @WebParam(name="in2")String requestId );


/**
 * Synchronous version of a clinical data delete
 *
 * @param deleteRequest Delete request specified in XML according to the CDS delete request schema
 * @param templateId ID of the template for which the delete request applies
 * @param requestId Client specified unique request Id
 * @return Results of the delete returned in XML according the CDS delete results schema
 */
@WebMethod(operationName="deleteClinicalData")
@RequestWrapper(className="java.lang.String")
@ResponseWrapper(className="java.lang.String")
public @WebResult(name="out")String deleteClinicalData( @WebParam(name="in0")String deleteRequest, @WebParam(name="in1")String templateId, @WebParam(name="in2")String requestId );


/**
 * Synchronous version of a clinical data append
 *
 * @param appendRequest Append request specified in XML according to the CDS append request schema
 * @param templateId ID of the template for which the append request applies
 * @param requestId Client specified unique request Id
 * @return Results of the append returned in XML according the CDS append results schema
 */
@WebMethod(operationName="appendClinicalData")
@RequestWrapper(className="java.lang.String")
@ResponseWrapper(className="java.lang.String")
public @WebResult(name="out")String appendClinicalData( @WebParam(name="in0")String appendRequest, @WebParam(name="in1")String templateId, @WebParam(name="in2")String requestId );
}
