

package gov.va.med.cds.ars.persistence;


import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.VR12LocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.VR12ReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.VR12ReportFilterType;

import java.sql.Date;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;


public class VR12ReportsPersistenceManager
    extends
        AbstractReadableReportsPersistenceManager
    implements
        ReadableReportsPersistenceManagerInterface
{
    protected String vr12DataQuery = "SurveyReports.vr12.data";
    
    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
    {
    	VR12ReportFilterType filter = aReportFilter.getVR12ReportFilter();
        VR12ReportDataType data = new VR12ReportDataType();
        Session session = this.sessionFactory.getCurrentSession();
                
        try
        {
            List<VR12LocationReportDataType> results = null;
            Integer surveyCount = null;
            
            results = vr12ReadReportAggregate( session, filter );
            surveyCount = getSurveyCount( results );
            
            data.getReportData().addAll( results );
            data.setNumberOfRecordsConsidered( surveyCount );
            data.setReportID( filter.getReportID() );
        }
        finally
        {
            session.close();
        }
        
        responseType.setVR12ReportData( data );
        
        return responseType;
    }    


    @SuppressWarnings( "unchecked" )
    private List<VR12LocationReportDataType> vr12ReadReportAggregate( Session aSession, VR12ReportFilterType aVR12ReportFilter )
        throws PersistenceException
    {
        String location = aVR12ReportFilter.getGeographicalArea().getLocation();
        Date startDate = formatDate( aVR12ReportFilter.getStartDate() );
        Date endDate = formatDate( aVR12ReportFilter.getEndDate() );
        
        Query query = aSession.getNamedQuery( vr12DataQuery );
        query.setString( "location", location );
        query.setDate( "startDate", startDate );
        query.setDate( "endDate", endDate );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "+++++ Calling VR12 stored proc: *****(  " + vr12DataQuery + "  )*****" );
            LOGGER.debug( " location: " + location );
            LOGGER.debug( " startDate: " + startDate );
            LOGGER.debug( " endDate: " + endDate );
        }

        List<VR12LocationReportDataType> results = ( List<VR12LocationReportDataType> )queryForReportData( query );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "----- Done with VR12 stored proc" );
        }

        return results;
    }


    public void setVr12DataQuery( String aVr12DataQuery )
    {
        this.vr12DataQuery = aVr12DataQuery;
    }

}

