

package gov.va.med.cds.ars.persistence;


import gov.va.med.cds.ars.requestresponse.generated.HTReportFilterType;
import gov.va.med.cds.ars.requestresponse.generated.HTResponseType;
import gov.va.med.cds.ars.requestresponse.generated.LocationReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.TrendReportDataType;
import gov.va.med.cds.ars.requestresponse.generated.TrendReportFilterType;

import java.sql.Date;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.Session;


public class TrendsReportsPersistenceManager
    extends
        AbstractReadableReportsPersistenceManager
    implements
        ReadableReportsPersistenceManagerInterface
{
    protected String trendsQuery = "SurveyReports.trends";

    
    @Override
    public HTResponseType performReadReportAggregate( HTReportFilterType aReportFilter )
        throws PersistenceException
    {
    	TrendReportFilterType filter = aReportFilter.getSurveyTrendReportFilter();
        TrendReportDataType data = new TrendReportDataType();
        Session session = this.sessionFactory.getCurrentSession();
                
        try
        {
            List<LocationReportDataType> results = null;
            Integer surveyCount = null;
            
            results = trendsReport( session, filter );
            surveyCount = getSurveyCount( results );

            data.getReportData().addAll( results );
            data.setNumberOfRecordsConsidered( surveyCount );
            data.setReportID( filter.getReportID() );
        }
        finally
        {
            session.close();
        }
        
        responseType.setSurveyTrendReportData( data );
        
        return responseType;
    }
    
    
    @SuppressWarnings( "unchecked" )
    private List<LocationReportDataType> trendsReport( Session aSession, TrendReportFilterType aTrendReportFilter )
        throws PersistenceException
    {
        String surveyVersion = aTrendReportFilter.getSurveyVersion();
        String surveyType = aTrendReportFilter.getSurveyType() == null ? null : aTrendReportFilter.getSurveyType().value();
        String location = aTrendReportFilter.getGeographicalArea().getLocation();
        Date startDate = formatDate( aTrendReportFilter.getStartDate() );
        Date endDate = formatDate( aTrendReportFilter.getEndDate() );
        
        Query query = aSession.getNamedQuery( trendsQuery );
        query.setString( "surveyVersion", surveyVersion );
        query.setString( "surveyType", surveyType );
        query.setString( "location", location );
        query.setDate( "startDate", startDate );
        query.setDate( "endDate", endDate );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "+++++ Calling Trends stored proc: *****(  " + trendsQuery + "  )*****" );
            LOGGER.debug( " surveyVersion: " + surveyVersion );
            LOGGER.debug( " surveyType: " + surveyType );
            LOGGER.debug( " location: " + location );
            LOGGER.debug( " startDate: " + startDate );
            LOGGER.debug( " endDate: " + endDate );
        }
        
        List<LocationReportDataType> results = ( List<LocationReportDataType> )queryForReportData( query );
        
        if ( LOGGER.isDebugEnabled() )
        {
            LOGGER.debug( "----- Done with Trends stored proc" );
        }

        return results;
    }


    public void setTrendsQuery( String aTrendsQuery )
    {
        this.trendsQuery = aTrendsQuery;
    }

}

