package gov.va.med.cds.ars.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder = {"month", "year", "questionNumber", "questionSum", "score"})
public class SurveySatisfactionAggregateDAO 
	extends SurveyAggregateDAO
{
    protected String key;  // for hibernate
    private String month;
    private String year;
    private Integer questionNumber;
    private Integer questionSum;
    private Double score;


    @XmlElement
    public String getMonth( )
    {
        return month;
    }


    public void setMonth( String month )
    {
        this.month = month;
    }


    @XmlElement
    public String getYear( )
    {
        return year;
    }


    public void setYear( String year )
    {
        this.year = year;
    }


    @XmlElement
    public Integer getQuestionNumber( )
    {
        return questionNumber;
    }


    public void setQuestionNumber( Integer questionNumber )
    {
        this.questionNumber = questionNumber;
    }


    @XmlElement
    public Integer getQuestionSum( )
    {
        return questionSum;
    }


    public void setQuestionSum( Integer questionSum )
    {
        this.questionSum = questionSum;
    }


    @XmlElement
    public Double getScore( )
    {
        // the sum / count to get the average
        // avg / 5 * 100
        
        if ( score == null ) 
        {
            try
            {
                score = ( ( questionSum / (float)getRecordCount() ) / 5.0 ) * 100;
            }
            catch ( Exception e )
            {
                // in case of a divide by zero or something
                score = 0.0;
            }
        }
        return score;
    }


    public void setScore( Double score )
    {
        this.score = score;
    }



    public String toString()
    {
        return "Location: " + getLocation() + ",  Record Count: " + getRecordCount() + ",  YYYYMM: " + year + month + ", question#: " + questionNumber + ", sum: " + questionSum + ", score: " + score;
    }
}

