

package gov.va.med.cds.ars.model;


import gov.va.med.cds.ars.requestresponse.generated.LocationReportDataType;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder = {"numberOfRecordsConsidered", "reportData", "locationReportData"})
public class AggregateDAO
{

    private Integer numberOfRecordsConsidered;
    private List<? extends SurveyAggregateDAO> reportData;
    private List<? extends LocationReportDataType> locationReportData;

    
    @XmlElement(name = "reportData")
    public List<? extends LocationReportDataType> getLocationReportData( )
    {
        return locationReportData;
    }


    public void setLocationReportData( List<? extends LocationReportDataType> locationReportData )
    {
        this.locationReportData = locationReportData;
    }


    @XmlElement(name = "reportData")
    public List<? extends SurveyAggregateDAO> getReportData( )
    {
        return reportData;
    }


    public void setReportData( List<? extends SurveyAggregateDAO> reportData )
    {
        this.reportData = reportData;
    }


    @XmlElement
    public Integer getNumberOfRecordsConsidered( )
    {
        return numberOfRecordsConsidered;
    }


    public void setNumberOfRecordsConsidered( Integer recordCount )
    {
        this.numberOfRecordsConsidered = recordCount;
    }

    
    public String toString( )
    {
        StringBuilder value = new StringBuilder();
        value.append( "Number of records used for calculations: ").append( getNumberOfRecordsConsidered() );
        value.append( "\n" );
        
        if ( reportData != null )
        {
            for ( SurveyAggregateDAO dao : reportData )
            {
                value.append( dao.toString() ).append( "\n" );
            }
        }
        
        return value.toString();
    }

}
