

package gov.va.med.cds.ars;


import java.util.Date;

import gov.va.med.cds.ars.ejb.config.ServiceConstantsInterface;
import gov.va.med.cds.ars.request.ReportRequestProcessor;
import gov.va.med.cds.ars.request.RequestProcessorInterface;
import gov.va.med.cds.ars.audit.ReadAuditLogger;

import javax.ejb.CreateException;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.jws.WebService;
import javax.xml.ws.BindingType;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.ejb.support.AbstractStatelessSessionBean;

/**
 * ARS Service Implementation Bean (SIB)
 * 
 */

@Stateless( mappedName="ARService" )
@WebService( portName = "AggregateReportingServicePort", serviceName = "ARService", targetNamespace = "http://cds.domain.ext/", wsdlLocation = "wsdls/ARService.wsdl", endpointInterface = "gov.va.med.cds.ars.AggregateReportingServiceInterface" )
@BindingType( "http://schemas.xmlsoap.org/wsdl/soap/http" )
public class AggregateReportingService
    extends
        AbstractStatelessSessionBean
    implements
    	AggregateReportingServiceInterface

{
	private static final long serialVersionUID = 908841796692366638L;
    private Log logger = LogFactory.getLog( AggregateReportingService.class );
    private ReadAuditLogger auditLogger;
    private RequestProcessorInterface reportProcessor = null;


    public AggregateReportingService( )
    {
        super();
    }


    public void init( )
    {
        logger.debug( "initializing the Patient Messaging Service." );
    }


    public boolean isAlive( )
    {
    	return true;
    }

    
	@Override
	public String readAggregateData(String reportRequest, String reportId, String clientId, String requestId) 
	{
	    if ( logger.isDebugEnabled() )
	    {
	        logger.debug( "++++++++++ Entered readAggregateData with reportRequest " + reportRequest );
	        logger.debug( "++++++++++ Entered readAggregateData with reportRequest: " + reportRequest );
	        logger.debug( "++++++++++ Entered readAggregateData with reportId: " + reportId );
	        logger.debug( "++++++++++ Entered readAggregateData with clientId: " + clientId );
	        logger.debug( "++++++++++ Entered readAggregateData with requestId: " + requestId );
	    }
		
		// Start time logging
        Long startTime = new Date().getTime();
        String readResult = reportProcessor.readAggregateData( reportRequest, reportId, clientId, requestId );
        auditLogger.recordAuditLog( startTime, readResult, reportRequest, reportId, clientId, requestId );
        
        return readResult;
	}


	@Override
    public void setSessionContext( SessionContext sessionContext )
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered setSessionContext" );
        }

        super.setSessionContext( sessionContext );
        setBeanFactoryLocator( ContextSingletonBeanFactoryLocator.getInstance( "arsBeanRefContext.xml" ) );
        setBeanFactoryLocatorKey( ServiceConstantsInterface.PRIMARY_CONTEXT_ID );
    }
	
	
    @Override
    protected void onEjbCreate( )
        throws CreateException
    {
        if ( logger.isDebugEnabled() )
        {
            logger.debug( "++++++++++ Entered onEjbCreate" );
        }

        reportProcessor = ( ReportRequestProcessor )getBeanFactory().getBean( "requestProcessor" );
        auditLogger = ( ReadAuditLogger )getBeanFactory().getBean( "auditLogger" );
    }

}
