/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.transaction;

import gov.va.med.cds.cdm.allergies.IntoleranceCondition;
import gov.va.med.cds.cdm.clinicaldata.ClinicalData;
import gov.va.med.cds.cdm.vitals.VitalSignObservationEvent;
import gov.va.med.cds.filter.CdsPersistenceFilterInterface;
import gov.va.med.cds.persistence.PersistenceException;
import gov.va.med.cds.persistence.PersistenceLocatorInterface;
import gov.va.med.cds.persistence.PersistenceManagerInterface;
import gov.va.med.cds.request.ReadResponseInterface;
import gov.va.med.cds.request.WriteResponseInterface;
import gov.va.med.cds.transaction.TransactionManagerInterface;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTransactionManager
implements TransactionManagerInterface {
    private PersistenceLocatorInterface persistenceLocator = null;

    public List<Serializable> readData(CdsPersistenceFilterInterface aCdsPersistenceFilter, ReadResponseInterface aResult) throws PersistenceException {
        LinkedList<Serializable> results = new LinkedList<Serializable>();
        Collection persistenceManagers = this.persistenceLocator.getPersistenceManagers(aCdsPersistenceFilter);
        for (PersistenceManagerInterface persistenceManager : persistenceManagers) {
            persistenceManager.startTransaction();
            List dataSourceResult = persistenceManager.readData(aCdsPersistenceFilter);
            if (dataSourceResult != null) {
                results.addAll(dataSourceResult);
            }
            persistenceManager.commitTransaction();
        }
        return results;
    }

    public void performCRUADOnClinicalData(ClinicalData aClinicalData, WriteResponseInterface aResult) throws PersistenceException {
        PersistenceManagerInterface persistenceManger = this.persistenceLocator.getPersistenceManager(aClinicalData);
        List intoleranceConditions = aClinicalData.getIntoleranceCondition();
        try {
            List vitalSignObservationEvents;
            persistenceManger.startTransaction();
            if (intoleranceConditions.size() > 0) {
                for (IntoleranceCondition intoleranceCondition : intoleranceConditions) {
                    persistenceManger.performCRUADOnClinicalData(aClinicalData.getRequestType(), (Object)intoleranceCondition);
                }
            }
            if ((vitalSignObservationEvents = aClinicalData.getVitalSignObservationEvent()).size() > 0) {
                for (VitalSignObservationEvent vitalSignObservationEvent : vitalSignObservationEvents) {
                    persistenceManger.performCRUADOnClinicalData(aClinicalData.getRequestType(), (Object)vitalSignObservationEvent);
                }
            }
            persistenceManger.commitTransaction();
        }
        catch (RuntimeException e) {
            persistenceManger.rollbackTransaction();
            throw e;
        }
    }

    public void setPersistenceLocator(PersistenceLocatorInterface persistenceLocator) {
        this.persistenceLocator = persistenceLocator;
    }
}

