/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.mapping;

import gov.va.med.cds.cdm.clinicaldata.ClinicalData;
import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.mapping.DozerMapperFactory;
import gov.va.med.cds.mapping.MapperInterface;
import gov.va.med.cds.mapping.MappingException;
import gov.va.med.cds.vdm.VhimVersion;
import java.io.IOException;
import net.sf.dozer.util.mapping.MapperIF;

public class CdmVdmDozerMapper
implements MapperInterface {
    private MapperIF dozerMapper;
    private Class vdmRootClass;
    private Class cdmRootClass;
    private VhimVersion vhimVersion;
    private boolean initialized = false;

    public CdmVdmDozerMapper() {
    }

    public CdmVdmDozerMapper(VhimVersion vhimVersion, Class cdmRootClass, Class vdmRootClass) throws IOException {
        this.setVdmRootClass(vdmRootClass);
        this.setCdmRootClass(cdmRootClass);
        this.setVhimVersion(vhimVersion);
        this.init();
    }

    private void init() throws IOException {
        if (!this.initialized) {
            this.dozerMapper = DozerMapperFactory.create((VhimVersion)this.vhimVersion);
            this.initialized = true;
        }
    }

    public Object mapCdmToVdm(ClinicalData cdmTemplate) {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new MappingException(ErrorCodeEnum.CANNOT_INITIALIZE_DOZER_MAPPER, (Throwable)e);
        }
        return this.dozerMapper.map((Object)cdmTemplate, this.vdmRootClass);
    }

    public ClinicalData mapVdmToCdm(Object vdmTemplate) {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new MappingException(ErrorCodeEnum.CANNOT_INITIALIZE_DOZER_MAPPER, (Throwable)e);
        }
        return (ClinicalData)this.dozerMapper.map(vdmTemplate, this.cdmRootClass);
    }

    public void setCdmRootClass(Class cdmRootClass) {
        this.cdmRootClass = cdmRootClass;
    }

    public void setVdmRootClass(Class vdmRootClass) {
        this.vdmRootClass = vdmRootClass;
    }

    public void setVhimVersion(VhimVersion vhimVersion) {
        this.vhimVersion = vhimVersion;
    }
}

