/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.xml;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exception.InitializationException;
import gov.va.med.cds.xml.EntityResolver;
import gov.va.med.cds.xml.PathReplacementEntityResolver;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PathReplacementEntityResolver
implements EntityResolver {
    private static Log logger = LogFactory.getLog(PathReplacementEntityResolver.class);
    private String toReplace = null;
    private String replacement = null;
    private ResourceLoader loader = new DefaultResourceLoader();

    public PathReplacementEntityResolver() {
    }

    public PathReplacementEntityResolver(String toReplace, String replacement) {
        this.setToReplace(toReplace);
        this.setReplacement(replacement);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        Resource resource = this.findResource(systemId);
        return new InputSource(resource.getInputStream());
    }

    private Resource findResource(String systemId) {
        int indx = systemId.indexOf(this.toReplace);
        if (indx == -1) {
            throw new InitializationException(ErrorCodeEnum.CANNOT_REPLACE_ENTITY_SYSTEM_ID, new String[]{this.toReplace, systemId});
        }
        String suffix = systemId.substring(indx += this.toReplace.length(), systemId.length());
        String path = "classpath:" + this.replacement + suffix;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("replacing entity systemId " + systemId + " with " + path));
        }
        Resource resource = this.loader.getResource(path);
        return resource;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        Resource resource = this.findResource(systemId);
        return new DefaultLSInput(this, resource, publicId, systemId);
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getToReplace() {
        return this.toReplace;
    }

    public void setToReplace(String toReplace) {
        this.toReplace = toReplace;
    }
}

