/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.vdm;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.template.TemplateMetaDataInterface;
import gov.va.med.cds.vdm.MarshallingConstants;
import gov.va.med.cds.vdm.VdmException;
import gov.va.med.cds.vdm.VdmFactoryInterface;
import gov.va.med.cds.xml.schema.DocumentRootFactoryInterface;
import gov.va.med.cds.xml.schema.SchemaSymbolMapProviderInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public class EmfVdmFactory
implements VdmFactoryInterface {
    private Object resourceFactory = null;
    private String nameSpaceURI = null;
    private Object packageInstance = null;
    private boolean initialized = false;
    private ResourceSet resourceSet = null;
    private Log logger = LogFactory.getLog(EmfVdmFactory.class);
    private SchemaSymbolMapProviderInterface schemaSymbolMapProvider = null;
    private DocumentRootFactoryInterface documentRootFactory = null;

    public EmfVdmFactory() {
    }

    public EmfVdmFactory(Object resourceFactory, String nameSpaceURI, Object packageInstance) {
        this.resourceFactory = resourceFactory;
        this.nameSpaceURI = nameSpaceURI;
        this.packageInstance = packageInstance;
    }

    public Object create(String templateXml) {
        if (!this.initialized) {
            this.init();
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(templateXml.getBytes());
        XMLResourceImpl input = new XMLResourceImpl();
        try {
            input.load((InputStream)inputStream, this.getDefaultXmlWriteOptions(input));
        }
        catch (IOException e) {
            throw new VdmException(ErrorCodeEnum.LOADING_OF_RESOURCE_FAILED, (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("after loading,  resource is " + input));
            this.logger.debug((Object)("after loading,  input.getContents() is " + input.getContents()));
        }
        if (input.getContents() == null || input.getContents().size() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No VDM object tree was created from marshalling the contents " + templateXml));
            }
            throw new VdmException(ErrorCodeEnum.MARSHALLING_FAILED, new String[]{templateXml});
        }
        Object documentRoot = input.getContents().get(0);
        try {
            Method getTemplateMethod = documentRoot.getClass().getMethod("getClinicalData", null);
            return getTemplateMethod.invoke(documentRoot, (Object[])null);
        }
        catch (SecurityException e) {
            throw new VdmException(ErrorCodeEnum.CANNOT_FIND_CLINICAL_DATA_ROOT_IN_DOCUMENT_ROOT, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new VdmException(ErrorCodeEnum.CANNOT_FIND_CLINICAL_DATA_ROOT_IN_DOCUMENT_ROOT, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new VdmException(ErrorCodeEnum.CANNOT_FIND_CLINICAL_DATA_ROOT_IN_DOCUMENT_ROOT, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new VdmException(ErrorCodeEnum.CANNOT_FIND_CLINICAL_DATA_ROOT_IN_DOCUMENT_ROOT, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new VdmException(ErrorCodeEnum.CANNOT_FIND_CLINICAL_DATA_ROOT_IN_DOCUMENT_ROOT, (Throwable)e);
        }
    }

    private Map getDefaultXmlWriteOptions(XMLResourceImpl input) {
        Map options = input.getDefaultLoadOptions();
        options.put("EXTENDED_META_DATA", true);
        options.put("USE_ENCODED_ATTRIBUTE_STYLE", true);
        options.put("USE_LEXICAL_HANDLER", true);
        return options;
    }

    private void init() {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", this.resourceFactory);
        this.resourceSet.getPackageRegistry().put((Object)this.nameSpaceURI, this.packageInstance);
        this.initialized = true;
    }

    public String createXml(Object dataRoot, TemplateMetaDataInterface metaData) {
        String dataKey = metaData.getTemplateId();
        if (!this.initialized) {
            this.init();
        }
        try {
            Resource efmResource = this.resourceSet.createResource(URI.createURI((String)"http:///dont.care"));
            Object docRoot = this.documentRootFactory.create(dataRoot);
            efmResource.getContents().add(docRoot);
            HashMap<Object, Object> hm = new HashMap<Object, Object>();
            hm.put("ENCODING", "UTF-8");
            hm.put("FORMATTED", false);
            hm.put("SCHEMA_MAP", this.schemaSymbolMapProvider.getSymbolMap(dataKey));
            hm.put(MarshallingConstants.OPTION_TEMPLATE_NS, metaData.getTargetNamespace());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            efmResource.save((OutputStream)out, hm);
            out.flush();
            String result = out.toString();
            out.close();
            return result;
        }
        catch (IOException e) {
            throw new VdmException(ErrorCodeEnum.PROBLEM_GETTING_SYMBOL_MAP, (Throwable)e);
        }
        catch (ValidationException e) {
            throw new VdmException(ErrorCodeEnum.PROBLEM_GETTING_SYMBOL_MAP, (Throwable)e);
        }
    }

    public void setNameSpaceURI(String nameSpaceURI) {
        this.nameSpaceURI = nameSpaceURI;
    }

    public void setPackageInstance(Object packageInstance) {
        this.packageInstance = packageInstance;
    }

    public void setResourceFactory(Object resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    public void setSchemaSymbolMapProvider(SchemaSymbolMapProviderInterface schemaSymbolMapProvider) {
        this.schemaSymbolMapProvider = schemaSymbolMapProvider;
    }

    public void setDocumentRootFactory(DocumentRootFactoryInterface documentRootFactory) {
        this.documentRootFactory = documentRootFactory;
    }
}

