/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.persistence.hibernate;

import gov.va.med.cds.cdm.allergies.IntoleranceCondition;
import gov.va.med.cds.cdm.allergies.ReactionObservationEvent;
import gov.va.med.cds.cdm.allergies.SeverityObservationEvent;
import gov.va.med.cds.cdm.vitals.VitalSignObservationEvent;
import gov.va.med.cds.persistence.hibernate.IntoleranceConditionUpdater;
import gov.va.med.cds.persistence.hibernate.ReactionObservationEventUpdater;
import gov.va.med.cds.persistence.hibernate.SeverityObservationEventUpdater;
import gov.va.med.cds.persistence.hibernate.UpdaterInterface;
import gov.va.med.cds.persistence.hibernate.VitalSignObservationEventUpdater;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdaterFactory {
    private static final Log logger = LogFactory.getLog(UpdaterFactory.class);
    private Map<Class, Class> updaters = null;
    private static UpdaterFactory instance = new UpdaterFactory();

    private UpdaterFactory() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing Updaters");
        }
        this.updaters = new HashMap();
        this.updaters.put(IntoleranceCondition.class, IntoleranceConditionUpdater.class);
        this.updaters.put(ReactionObservationEvent.class, ReactionObservationEventUpdater.class);
        this.updaters.put(SeverityObservationEvent.class, SeverityObservationEventUpdater.class);
        this.updaters.put(VitalSignObservationEvent.class, VitalSignObservationEventUpdater.class);
    }

    public static UpdaterFactory getInstance() {
        if (instance == null) {
            instance = new UpdaterFactory();
        }
        return instance;
    }

    public UpdaterInterface createUpdater(Class aClass) throws InstantiationException, IllegalAccessException {
        return (UpdaterInterface)((Class)this.updaters.get(aClass)).newInstance();
    }

    public void setAppenders(Map<Class, Class> appenders) {
        this.updaters = appenders;
    }
}

