/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.mapping;

import gov.va.med.cds.mapping.DozerBeanMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.dozer.util.mapping.MapperIF;
import net.sf.dozer.util.mapping.MappingException;
import org.springframework.core.io.Resource;

public class DozerBeanMapperForResources
implements MapperIF {
    private DozerBeanMapper dozerBeanMapper = null;
    private Resource[] mappingResources = null;
    private boolean initialized = false;

    public DozerBeanMapperForResources() {
    }

    public DozerBeanMapperForResources(Resource[] aResources) throws IOException {
        this.mappingResources = aResources;
        this.init();
    }

    private void init() throws IOException {
        if (!this.initialized) {
            ArrayList<String> mappingFiles = new ArrayList<String>();
            for (Resource resource : this.mappingResources) {
                int index = resource.getFile().getAbsolutePath().indexOf("gov" + File.separator);
                String workingString = resource.getFile().getAbsolutePath().substring(index).replace(File.separator, "/");
                mappingFiles.add(workingString);
            }
            this.dozerBeanMapper = new DozerBeanMapper(mappingFiles);
            this.initialized = true;
        }
    }

    public Object map(Object sourceObj, Class destClass) throws MappingException {
        return this.dozerBeanMapper.map(sourceObj, destClass);
    }

    public void map(Object sourceObj, Object destObj) throws MappingException {
        this.dozerBeanMapper.map(sourceObj, destObj);
    }

    public Object map(Object sourceObj, Class destClass, String mapId) throws MappingException {
        return this.dozerBeanMapper.map(sourceObj, destClass, mapId);
    }

    public void map(Object sourceObj, Object destObj, String mapId) throws MappingException {
        this.dozerBeanMapper.map(sourceObj, destObj, mapId);
    }

    public void setMappingResources(Resource[] mappingResources) throws IOException {
        this.mappingResources = mappingResources;
        this.init();
    }
}

