/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.filter;

import gov.va.med.cds.filter.XpathFilterRegistry;
import gov.va.med.cds.filter.XpathFilterRegistryInterface;
import gov.va.med.cds.filter.schema.generated.XpathType;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpathFilterRegistry
implements XpathFilterRegistryInterface {
    private static final Log logger = LogFactory.getLog(XpathFilterRegistry.class);
    private final String VDM_XPATH_RESOURCE_FILE = "classpath:gov/va/med/cds/filter/Xpath/vdmXpathfilterRepository.properties";
    private final String CDM_XPATH_RESOURCE_FILE = "classpath:gov/va/med/cds/filter/Xpath/cdmXpathfilterRepository.properties";
    private Properties vdmXpathFilterProperties = new Properties();
    private Properties cdmXpathFilterProperties = new Properties();
    private static XpathFilterRegistryInterface instance = new XpathFilterRegistry();

    private XpathFilterRegistry() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Initializing Filters");
        }
        this.init();
    }

    public static XpathFilterRegistryInterface getInstance() {
        if (instance == null) {
            instance = new XpathFilterRegistry();
        }
        return instance;
    }

    private void init() {
        Resource resource = null;
        try {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            resource = resourceLoader.getResource("classpath:gov/va/med/cds/filter/Xpath/vdmXpathfilterRepository.properties");
            this.vdmXpathFilterProperties.load(resource.getInputStream());
            resource = resourceLoader.getResource("classpath:gov/va/med/cds/filter/Xpath/cdmXpathfilterRepository.properties");
            this.cdmXpathFilterProperties.load(resource.getInputStream());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load filters.", (Throwable)e);
        }
    }

    public Collection<Object> getXpathFilterIds(XpathType aXpathType) {
        switch (1.$SwitchMap$gov$va$med$cds$filter$schema$generated$XpathType[aXpathType.ordinal()]) {
            case 1: {
                return this.cdmXpathFilterProperties.keySet();
            }
        }
        return this.vdmXpathFilterProperties.keySet();
    }

    public String getXpathFilter(XpathType aDomain, String filterId) {
        switch (1.$SwitchMap$gov$va$med$cds$filter$schema$generated$XpathType[aDomain.ordinal()]) {
            case 1: {
                return this.cdmXpathFilterProperties.getProperty(filterId);
            }
        }
        return this.vdmXpathFilterProperties.getProperty(filterId);
    }
}

