/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.exceptionframework;

import gov.va.med.cds.exception.ErrorCodeEnum;
import gov.va.med.cds.exceptionframework.BaseExceptionHandler;
import gov.va.med.cds.exceptionframework.ExceptionDescriptorInterface;
import gov.va.med.cds.exceptionframework.ExceptionHandlerInterface;
import gov.va.med.cds.exceptionframework.ExceptionLoggerInterface;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerFactory {
    private static volatile ExceptionHandlerFactory exceptionHandlerFactory = null;
    private static ExceptionHandlerInterface exceptionHandler = null;
    private static Map<ErrorCodeEnum, ExceptionDescriptorInterface> exceptionDescriptorMap = null;
    private static ExceptionLoggerInterface guaranteedLogger = null;

    private ExceptionHandlerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExceptionHandlerFactory getInstance() {
        if (exceptionHandlerFactory != null) return exceptionHandlerFactory;
        Class<ExceptionHandlerFactory> clazz = ExceptionHandlerFactory.class;
        synchronized (ExceptionHandlerFactory.class) {
            if (exceptionHandlerFactory != null) return exceptionHandlerFactory;
            exceptionHandlerFactory = new ExceptionHandlerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return exceptionHandlerFactory;
        }
    }

    public ExceptionHandlerInterface create(Class loggingContext) {
        if (exceptionHandler == null) {
            BaseExceptionHandler workingExceptionHandler = new BaseExceptionHandler();
            workingExceptionHandler.setExceptionDescriptorMap(exceptionDescriptorMap);
            workingExceptionHandler.setGuaranteedLogger(guaranteedLogger);
            exceptionHandler = workingExceptionHandler;
        }
        return exceptionHandler;
    }

    public void setExceptionDescriptorMap(Map<ErrorCodeEnum, ExceptionDescriptorInterface> logDescriptorMap) {
        exceptionDescriptorMap = logDescriptorMap;
    }

    public void setGuaranteedLogger(ExceptionLoggerInterface logger) {
        guaranteedLogger = logger;
    }
}

