/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.cdm.clinicaldata;

import gov.va.med.cds.cdm.allergies.IntoleranceCondition;
import gov.va.med.cds.cdm.clinicaldata.ErrorSection;
import gov.va.med.cds.cdm.clinicaldata.RequestType;
import gov.va.med.cds.cdm.vitals.VitalSignObservationEvent;
import gov.va.med.cds.template.TemplateMetaDataInterface;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClinicalData
implements Serializable {
    private static final long serialVersionUID = -2832696271885316959L;
    private List<IntoleranceCondition> intoleranceCondition = new LinkedList();
    private List<VitalSignObservationEvent> vitalSignObservationEvent = new LinkedList();
    private String templateId;
    private String vhimVersion;
    private String templateName;
    private String templateDescription;
    private RequestType requestType;
    private ErrorSection errors;
    private String entryPoint;

    public ClinicalData() {
    }

    public ClinicalData(TemplateMetaDataInterface metaData, List<Serializable> resultData) {
        this.setTemplateId(metaData.getTemplateId());
        this.setVhimVersion(metaData.getVhimVersion().toString());
        for (Serializable item : resultData) {
            this.addItem(item);
        }
    }

    private void addItem(Serializable item) {
        if (item instanceof IntoleranceCondition) {
            this.getIntoleranceCondition().add((IntoleranceCondition)item);
        }
        if (item instanceof VitalSignObservationEvent) {
            this.getVitalSignObservationEvent().add((VitalSignObservationEvent)item);
        }
    }

    public void addIntoleranceCondition(IntoleranceCondition aIntoleranceCondition) {
        this.getIntoleranceCondition().add(aIntoleranceCondition);
    }

    public void addVitalSignObservationEvent(VitalSignObservationEvent aVitalSignObservationEvent) {
        this.getVitalSignObservationEvent().add(aVitalSignObservationEvent);
    }

    public List<IntoleranceCondition> getIntoleranceCondition() {
        return this.intoleranceCondition;
    }

    public void setIntoleranceCondition(List<IntoleranceCondition> intoleranceCondition) {
        this.intoleranceCondition = intoleranceCondition;
    }

    public List<VitalSignObservationEvent> getVitalSignObservationEvent() {
        return this.vitalSignObservationEvent;
    }

    public void setVitalSignObservationEvent(List<VitalSignObservationEvent> vitalSignObservationEvent) {
        this.vitalSignObservationEvent = vitalSignObservationEvent;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getVhimVersion() {
        return this.vhimVersion;
    }

    public void setVhimVersion(String vhimVersion) {
        this.vhimVersion = vhimVersion;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestType requestType) {
        this.requestType = requestType;
    }

    public ErrorSection getErrors() {
        return this.errors;
    }

    public void setErrors(ErrorSection errors) {
        this.errors = errors;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }
}

