/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.cds.cdm;

import gov.va.med.cds.cdm.CdmManagerInterface;
import gov.va.med.cds.cdm.clinicaldata.ClinicalData;
import gov.va.med.cds.filter.CdsFilterInterface;
import gov.va.med.cds.filter.CdsPersistenceFilterInterface;
import gov.va.med.cds.filter.FilterProcessorInterface;
import gov.va.med.cds.filter.schema.generated.XpathType;
import gov.va.med.cds.persistence.ReadException;
import gov.va.med.cds.request.ReadResponseInterface;
import gov.va.med.cds.request.ValidationException;
import gov.va.med.cds.request.WriteResponseInterface;
import gov.va.med.cds.rules.DataRulesProcessorInterface;
import gov.va.med.cds.template.TemplateMetaDataInterface;
import gov.va.med.cds.transaction.TransactionManagerInterface;
import java.util.List;

public class DefaultCdmManager
implements CdmManagerInterface {
    private DataRulesProcessorInterface rulesProcessor = null;
    private TransactionManagerInterface transactionManager = null;
    private FilterProcessorInterface filterProcessor;

    public void setRulesProcessor(DataRulesProcessorInterface rulesProcessor) {
        this.rulesProcessor = rulesProcessor;
    }

    public void setTransactionManager(TransactionManagerInterface transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setFilterProcessor(FilterProcessorInterface filterProcessor) {
        this.filterProcessor = filterProcessor;
    }

    public ClinicalData read(CdsFilterInterface aFilter, TemplateMetaDataInterface metaData, ReadResponseInterface aReadResponse) {
        List results = this.transactionManager.readData((CdsPersistenceFilterInterface)aFilter, aReadResponse);
        List processedResults = this.rulesProcessor.applyOutgoingProcessingRules(results);
        ClinicalData cdmTemplate = new ClinicalData(metaData, processedResults);
        if (aFilter.getXpathType() == XpathType.CDM) {
            try {
                cdmTemplate = (ClinicalData)this.filterProcessor.filterObject(aFilter, (Object)cdmTemplate);
            }
            catch (ValidationException e) {
                throw new ReadException("There was a problem executing the CDM filter ", (Throwable)e);
            }
        }
        return cdmTemplate;
    }

    public WriteResponseInterface performCRUADOnClinicalData(ClinicalData aClinicalData, WriteResponseInterface aWriteResponseInterface) {
        this.rulesProcessor.applyProcessingRules(aClinicalData, aWriteResponseInterface);
        this.transactionManager.performCRUADOnClinicalData(aClinicalData, aWriteResponseInterface);
        return aWriteResponseInterface;
    }
}

