unit fProbLex;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Vcl.Controls,
  Forms, Dialogs, ORFn, uProbs, StdCtrls, Buttons, ExtCtrls, ORctrls, uConst,
  fAutoSz, uInit, fBase508Form, VA508AccessibilityManager, Grids, fProbFreetext,
  ComCtrls, Windows, rPCE, mColumnTree;

type
  TfrmPLLex = class(TfrmBase508Form)
    {Label1: TLabel;}
    bbCan: TBitBtn;
    bbOK: TBitBtn;
    pnlStatus: TPanel;
    lblStatus: TVA508StaticText;
    ebLex: TCaptionEdit;
    bbSearch: TBitBtn;
    bbExtendedSearch: TBitBtn;
    pnlDialog: TPanel;
    pnlSearch: TPanel;
    pnlButtons: TPanel;
    pnlList: TPanel;
    lblSelect: TLabel;
    lblSearch: Tlabel;
    bbFreetext: TBitBtn;
    ctfLex: TColumnTreeFrame;
    procedure EnableExtend;
    procedure DisableExtend;
    procedure EnableFreeText;
    procedure DisableFreeText;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bbOKClick(Sender: TObject);
    procedure bbCanClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ebLexKeyPress(Sender: TObject; var Key: Char);
    procedure bbSearchClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure bbExtendedSearchClick(Sender: TObject);
    procedure ebLexChange(Sender: TObject);
    procedure setClientWidth(ctf: TColumnTreeFrame);
    procedure CenterForm(ctf: TColumnTreeFrame; w: Integer);
    procedure lvLexClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure lvLexCustomDrawItem(Sender: TCustomListView; Item: TListItem;
      State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure lvLexInfoTip(Sender: TObject; Item: TListItem;
      var InfoTip: string);
    procedure ApplicationShowHint(var HintStr: String; var CanShow: Boolean;
      var HintInfo: Vcl.Controls.THintInfo);
    procedure bbFreetextClick(Sender: TObject);
    procedure ctfLextvTreeChange(Sender: TObject; Node: TTreeNode);
    procedure ctfLextvTreeEnter(Sender: TObject);
    procedure ctfLextvTreeExit(Sender: TObject);
    procedure ctfLextvTreeDblClick(Sender: TObject);
  private
    FExtendOffered: Boolean;
    FSuppressCodes: Boolean;
    FICDLookup: Boolean;
    FBuildingList: Boolean;
    FCenteringForm: Boolean;
    FICDVersion: String;
    FProblemNOS: String;
    FContinueNOS: String;
    FI10Active: Boolean;
    procedure SetICDVersion(ADate: TFMDateTime = 0);
    function ctfLexGridWidth(ctf: TColumnTreeFrame): Integer;
    procedure updateStatus(status: String);
    procedure processSearch(Extend: Boolean);
    procedure SetColumnTreeModel(ResultSet: TStrings);
    function SaveFreetext: Boolean;
    { Private declarations }
  public
    { Public declarations }
    procedure SetSearchString(sstring: String);
    function SetFreetextProblem: String;
  end;

  // subclass THintWindow to override font size
  TListViewHintWindowClass = class(THintWindow)
  public
    constructor Create(AOwner: TComponent); override;
    procedure SetFontSize(fontsize: Integer);
    function GetFontSize: Integer;
  end;

implementation

uses
 fProbs, rProbs, fProbEdt, uCore, rCore;

{$R *.DFM}

var
 ProblemNOSs: TStringList;
 TriedExtend: Boolean = false;
 PLShowHint: TShowHintEvent;
 LVHintWindowClass: TListViewHintWindowClass;

const
  TX799 = '799.9';
  TX_CONTINUE_799 = 'The term you selected is not yet mapped to an ICD-9-CM code. ' +
                    'If you select this term, an ICD-9-CM code of 799.9 will be entered into ' +
                    'the system and your selected term will be sent for review to be mapped ' +
                    'to an ICD-9-CM code. Until that process is completed, you will not be able ' +
                    'to choose your selected term from the Encounter Form pick list.' + CRLF + CRLF +
                    'Use ';
  TXR69 = 'R69.';
  TX_CONTINUE_R69 = 'The term you selected is not yet mapped to an ICD-10-CM code. ' +
                    'If you select this term, an ICD-10-CM code of R69. will be entered into ' +
                    'the system and your selected term will be sent for review to be mapped ' +
                    'to an ICD-10-CM code. Until that process is completed, you will not be able ' +
                    'to choose your selected term from the Encounter Form pick list.' + CRLF + CRLF +
                    'Use ';
  TX_FREETEXT_799  = 'A suitable term was not found based on user input and current defaults. ' +
                     'If you proceed with this nonspecific term, an ICD code of "799.9 - OTHER ' +
                     'UNKNOWN AND UNSPECIFIED CAUSE OF MORBIDITY OR MORTALITY" will ' +
                     'be filed.' + CRLF + CRLF + 'Use ';
  TX_EXTEND_SEARCH = 'A suitable term was not found in the Problem List subset of SNOMED CT. ' +
                     'If you''d like to extend your search to include the entire Clinical ' +
                     'Findings Hierarchy of SNOMED CT, click the Extend Search button. ';
  TX_CHOOSE        = 'You must select a valid term to identify your patient''s problem. Either click ' +
                     'on a term from the list, or click on the Extend Search button, to extend your ' +
                     'search to include the entire Clinical Findings Hierarchy of SNOMED CT.';
  SUPPRESS_CODES = False;

constructor TListViewHintWindowClass.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  // use CPRS font size for hint window
  SetFontSize(Application.MainForm.Font.Size);
  LVHintWindowClass := Self;
end;

function TListViewHintWindowClass.GetFontSize: Integer;
begin
  Result := Canvas.Font.Size;
end;

procedure TListViewHintWindowClass.SetFontSize(fontsize: Integer);
begin
  Canvas.Font.Size := fontsize;
end;

procedure TfrmPLLex.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  ProblemNOSs.Free;
  Application.OnShowHint := PLShowHint;
  Release;
end;

procedure TfrmPLLex.bbExtendedSearchClick(Sender: TObject);
begin
  TriedExtend := true;
  processSearch(true);
  DisableExtend;
  if (ebLex.Text <> '') and (lblstatus.Caption <> 'Code search failed by Extended Search.') then
    EnableFreeText;
end;

procedure TfrmPLLex.bbFreetextClick(Sender: TObject);
begin
  inherited;
  if not SaveFreetext then
    Exit;

  //save freetext problem
  PLProblem := SetFreetextProblem;
  {prevents GPF if system close box is clicked while frmDlgProbs is visible}
  if (not Application.Terminated) and (not uInit.TimedOut) then
    if Assigned(frmProblems) then PostMessage(frmProblems.Handle, UM_PLLex, 0, 0);
  Close;
end;

procedure TfrmPLLex.updateStatus(status: String);
begin
  lblStatus.caption := status;
  lblStatus.Invalidate;
  lblStatus.Update;
end;

procedure TfrmPLLex.SetICDVersion(ADate: TFMDateTime = 0);
begin
  FICDVersion := Encounter.GetICDVersion;
  ctfLex.hdrColumns.Sections[2].Text := Piece(FICDVersion, '^', 2);
  if Piece(FICDVersion, '^', 1) = 'ICD' then
  begin
    FProblemNOS := TX799;
    FContinueNOS := TX_CONTINUE_799;
    FI10Active := False;
  end
  else
  begin
    FProblemNOS := TXR69;
    FContinueNOS := TX_CONTINUE_R69;
    FI10Active := True;
  end;
end;

procedure TfrmPLLex.bbOKClick(Sender: TObject);

function setProblem: String;
var
  x, y: String;
  i: integer;
begin
  x := String(ctfLex.SelectedNode.Data);
  y := Piece(x, U, 2);
  i := Pos(' *', y);
  if i > 0 then y := Copy(y, 1, i - 1);
  SetPiece(x, U, 2, y);
  // e.g., Result = 7030665^Atrial arrhythmia^427.9^2566^SNOMED CT^17366009^29361012^ICD-9-CM|arrhyth
  Result := x + '|' + ebLex.Text;
end;

begin
  {nothing entered, nothing selected - bail out}
  if (ebLex.Text = '') and (ctfLex.SelectedNode = nil) and (ctfLex.tvTree.Items.Count = 0) then
    Exit
  {nothing selected, or search returned void - suggest extended search}
  else if ((ctfLex.SelectedNode = nil) or (ctfLex.tvTree.Items.Count = 0)) then
  begin
    if TriedExtend then
    begin
      if not SaveFreetext then
        Exit;

      //save freetext problem
      PLProblem := SetFreetextProblem;
      Exit;
    end
    else
    begin
      if not FExtendOffered then
      begin
        if (ctfLex.tvTree.Items.Count = 0) then
          InfoBox(TX_EXTEND_SEARCH, 'Term not found', MB_OK or MB_ICONINFORMATION)
        else
          InfoBox(TX_CHOOSE, 'Term not selected', MB_OK or MB_ICONINFORMATION);
      end
      else
      begin
        if not SaveFreetext then
          Exit;
        PLProblem := SetFreetextProblem;
        if (not Application.Terminated) and (not uInit.TimedOut) then
          if Assigned(frmProblems) then PostMessage(frmProblems.Handle, UM_PLLex, 0, 0);
        Close;
      end;
      EnableExtend;
      FExtendOffered := true;
    end;
    Exit;
  end
  else if TriedExtend and ((ctfLex.SelectedNode.Columns[2] = '')
       or  ((ctfLex.SelectedNode.Columns[2] = FProblemNOS)
       and (ProblemNOSs.IndexOf(ctfLex.SelectedNode.Code) < 0))) then
  begin
    if (not FI10Active) and (InfoBox(FContinueNOS + UpperCase(ctfLex.SelectedNode.Text) + '?', 'Unmapped Problem Selected',
      MB_YESNO or MB_DEFBUTTON2 or MB_ICONQUESTION) <> IDYES) then Exit;
    PLProblem := setProblem;
  end
  else
    PLProblem := setProblem;

  {prevents GPF if system close box is clicked while frmDlgProbs is visible}
  if (not Application.Terminated) and (not uInit.TimedOut) then
     if Assigned(frmProblems) then PostMessage(frmProblems.Handle, UM_PLLex, 0, 0);
  Close;
end;

// override ApplicationShowHint to assign TListViewWindowClass for lvLex
procedure TfrmPLLex.ApplicationShowHint(var HintStr: String;
  var CanShow: Boolean; var HintInfo: Vcl.Controls.THintInfo);
begin
  if HintInfo.HintControl = ctfLex then
  begin
    HintInfo.HintWindowClass := TListViewHintWindowClass;
    if LVHintWindowClass <> nil then
      if LVHintWindowClass.GetFontSize <> Application.MainForm.Font.Size then
        LVHintWindowClass.SetFontSize(Application.MainForm.Font.Size);
  end;
end;

procedure TfrmPLLex.bbCanClick(Sender: TObject);
begin
 PLProblem:='';
 close;
end;

procedure TfrmPLLex.FormCreate(Sender: TObject);
var
  ADate: TFMDateTime;
begin
  ADate := 0;
  FExtendOffered := False;
  FBuildingList := False;
  FCenteringForm := False;
  FICDLookup := False;
  FSuppressCodes := PLUser.usSuppressCodes;
  PLProblem := '';
  ProblemNOSs := TStringList.Create;
  ResizeAnchoredFormToFont(self);
  PLShowHint := Application.OnShowHint;
  Application.OnShowHint := ApplicationShowHint;
  if not ((Encounter.VisitCategory = 'E') or (Encounter.VisitCategory = 'H')
    or (Encounter.VisitCategory = 'D')) then
      ADate := Encounter.DateTime;
  SetICDVersion(ADate);
end;

procedure TfrmPLLex.FormResize(Sender: TObject);
var
  cw, gap, newtl: Integer;
function MaxTextWidth(tv: TTreeView): Integer;
  var
    i, tl, maxtl: Integer;
begin
  maxtl := 0;
  for i := 0 to tv.Items.Count - 1 do
  begin
    tl := TextWidthByFont(Font.Handle, tv.Items[i].Text);
    if (tl > maxtl) then
      maxtl := tl;
  end;
  Result := maxtl;
end;
begin
  inherited;
  if not FCenteringForm then
  begin
    Constraints.MaxWidth := 0;
    cw := ctfLex.hdrColumns.Sections[1].Width + ctfLex.hdrColumns.Sections[2].Width;
    gap := (ctfLex.ClientWidth - (ctfLex.hdrColumns.Sections[0].Width + cw));
    if (gap <> 0) then
    begin
      newtl := ctfLex.hdrColumns.Sections[0].Width + gap;
      if newtl < 500 then
        ctfLex.hdrColumns.Sections[0].Width := newtl
      else
      begin
        ctfLex.hdrColumns.Sections[0].Width := 500;
        Constraints.MaxWidth := 500 + cw + (ctfLex.Width - ctfLex.ClientWidth) + (pnlList.Padding.Left + pnlList.Padding.Right);
      end;
    end
    else if (ctfLex.tvTree.Items.Count > 0) then
    begin
      newtl := MaxTextWidth(ctfLex.tvTree) + 10;
      if newtl < 500 then
        ctfLex.hdrColumns.Sections[0].Width := newtl
      else
      begin
        ctfLex.hdrColumns.Sections[0].Width := 500;
        Constraints.MaxWidth := 500 + cw + (ctfLex.Width - ctfLex.ClientWidth) + (pnlList.Padding.Left + pnlList.Padding.Right);
      end;
    end;
  end;
end;

procedure TfrmPLLex.ebLexKeyPress(Sender: TObject; var Key: Char);
begin
  if key=#13 then
  begin
    bbSearchClick(Sender);
    Key:=#0;
  end
  else
  begin
    lblStatus.caption:='';
    ctfLex.tvTree.Items.Clear;
  end;
end;

procedure TfrmPLLex.ebLexChange(Sender: TObject);
begin
  inherited;
  bbSearch.Default := True;
  bbOK.Default := False;
  DisableExtend;
  DisableFreeText;
  if (ctfLex.tvTree.Items.Count > 0) then
  begin
    ctfLex.tvTree.Items.Clear;
    updateStatus('');
    CenterForm(ctfLex, Constraints.MinWidth);
  end;
end;

procedure TfrmPLLex.setClientWidth(ctf: TColumnTreeFrame);
var
  i, maxw, tl, maxtl, cl, maxcl, il, maxil: integer;
  ctn: TColumnTreeNode;
begin
  maxtl := 0;
  maxcl := 0;
  maxil := 0;
  for i := 0 to pred(ctf.tvTree.Items.Count) do
  begin
    ctn := ctf.tvTree.Items[i] as TColumnTreeNode;
    tl := TextWidthByFont(Font.Handle, ctn.Text);
    if (tl > maxtl) then
      maxtl := tl;
    cl := TextWidthByFont(Font.Handle, ctn.Code);
    if (cl > maxcl) then
      maxcl := cl;
    il := TextWidthByFont(Font.Handle , ctn.Columns[2]);
    if (il > maxil) then
      maxil := il;
  end;

  il := TextWidthByFont(Font.Handle, Piece(FICDVersion, '^', 2));
  if (il > maxil) then
    maxil := il;

  //max text width = 500
  if maxtl > 490 then
    maxtl := 490;
  //set lv column widths
  ctf.hdrColumns.Sections[0].Width := maxtl + 10;
  if FSuppressCodes or FICDLookup then
  begin
    maxw := maxtl + 10;
  end
  else
  begin
    ctf.hdrColumns.Sections[1].Width := maxcl + 15;
    ctf.hdrColumns.Sections[1].MinWidth := ctf.hdrColumns.Sections[1].Width;
    if Piece(FICDVersion, U, 1) = 'ICD' then
    begin
      ctf.hdrColumns.Sections[2].Width := maxil + 15;
      ctf.hdrColumns.Sections[2].MinWidth := ctf.hdrColumns.Sections[2].Width;
    end
    else
    begin
      ctf.hdrColumns.Sections[2].Width := 0;
      ctf.hdrColumns.Sections[2].MinWidth := 0;
    end;
    maxw := maxtl + maxcl + maxil + 40;
  end;

  //resize lv to maximum pixel width of its elements
  if (maxw > 0) and (self.ClientWidth <> maxw) then
  begin
    CenterForm(ctf, maxw);
  end;
end;

procedure TfrmPLLex.SetSearchString(sstring: String);
begin
  ebLex.Text := sstring;
  Invalidate;
end;

procedure TfrmPLLex.CenterForm(ctf: TColumnTreeFrame; w: Integer);
var
  wdiff, mainw, gw: Integer;
begin
  FCenteringForm := True;
  mainw := Application.MainForm.Width;
//  self.Constraints.MaxWidth := 0;
  if w > mainw then
  begin
    w := mainw;
  end;

  self.ClientWidth := w + (ctf.Width - ctf.ClientWidth) + (pnlList.Padding.Left + pnlList.Padding.Right);
  gw := ctfLexGridWidth(ctfLex);
  if (ctf.ClientWidth > gw) then
    ctf.hdrColumns.Sections[0].Width := ctf.hdrColumns.Sections[0].Width + (ctf.ClientWidth - gw);

  if ctf.hdrColumns.Sections[0].Width = 500 then
    self.Constraints.MaxWidth := self.Width;

  wdiff := ((mainw - self.Width) div 2);
  self.Left := Application.MainForm.Left + wdiff;
//  self.Constraints.MaxWidth := self.Width;
  invalidate;
  FCenteringForm := False;
end;

procedure TfrmPLLex.ctfLextvTreeChange(Sender: TObject; Node: TTreeNode);
begin
  inherited;
  ctfLex.tvTreeChange(Sender, Node);
  if (ctfLex.SelectedNode = nil) then
  begin
    bbOK.Enabled := false;
    bbOK.Default := false;
  end
  else
  begin
    bbOK.Enabled := true;
    bbOK.Default := true;
    bbSearch.Default := false;
  end;
end;

procedure TfrmPLLex.ctfLextvTreeDblClick(Sender: TObject);
begin
  inherited;
  bbOK.Enabled := true;
  bbOKClick(sender);
end;

procedure TfrmPLLex.ctfLextvTreeEnter(Sender: TObject);
begin
  inherited;
  if (ctfLex.SelectedNode = nil) then
    bbOK.Enabled := false
  else
    bbOK.Enabled := true;
end;

procedure TfrmPLLex.ctfLextvTreeExit(Sender: TObject);
begin
  inherited;
  if (ctfLex.SelectedNode = nil) then
    bbOK.Enabled := false
  else
    bbOK.Enabled := true;
end;

procedure TfrmPLLex.bbSearchClick(Sender: TObject);
begin
  TriedExtend := false;
  ProblemNOSs.Clear;
  DisableFreeText;
  processSearch(false);
end;

procedure TfrmPLLex.SetColumnTreeModel(ResultSet: TStrings);
var
  i: Integer;
  Node: TColumnTreeNode;
  RecStr: String;
begin
  //  1     2        3      4       5       6         7          8     9
  //VUID^SCT TEXT^ICDCODE^ICDIEN^CODE SYS^CONCEPT^DESIGNATION^ICDVER^PARENT
  ctfLex.tvTree.Items.Clear;
  ctfLex.tvTree.Refresh;

  for i := 0 to ResultSet.Count - 1 do
  begin
    RecStr := ResultSet[i];
    if Piece(RecStr, '^', 9) = '' then
      Node := (ctfLex.tvTree.Items.Add(nil, Piece(RecStr, '^', 2))) as TColumnTreeNode
    else
      Node := (ctfLex.tvTree.Items.AddChild(ctfLex.tvTree.Items[(StrToInt(Piece(RecStr, '^', 9))-1)], Piece(RecStr, '^', 2))) as TColumnTreeNode;

    with Node do
    begin
      VUID := Piece(RecStr, '^', 1);
      Text := Piece(RecStr, '^', 2);
      CodeIEN := Piece(RecStr, '^', 4);
      CodeSys := Piece(RecStr, '^', 5);
      Code := Piece(RecStr, '^', 6);
      if Piece(RecStr, '^', 9) <> '' then
        ParentIndex := IntToStr(StrToInt(Piece(RecStr, '^', 9)) - 1);

      Columns := TStringList.Create;
      //Columns[0] = Text
      Columns.Add(Text);
      //Columns[1] = Code
      Columns.Add(Code);
      //Columns[2] = Mapped ICD target(s)
      Columns.Add(Piece(RecStr, '^', 3));

      //Data = pointer to RecStr
      Data := Pointer(RecStr);
    end;
    if Piece(RecStr, '^', 1) = 'icd' then
    begin
      ebLex.SelectAll;
      ebLex.SetFocus;
      ctfLex.tvTree.Enabled := false;
      ctfLex.hdrColumns.Sections[1].Width := 0;
      ctfLex.hdrColumns.Sections[1].MaxWidth := 0;
      ctfLex.hdrColumns.Sections[2].Width := 0;
      ctfLex.hdrColumns.Sections[2].MaxWidth := 0;
      FICDLookup := True;
    end
    else
    begin
      ctfLex.tvTree.Enabled := True;
      ctfLex.tvTree.SetFocus;
    end;
  end;
  //sort treenodes
  ctfLex.tvTree.AlphaSort(True);
end;

procedure TfrmPLLex.processSearch(Extend: Boolean);
var
  ProblemList: TStringList;
  v, Max, subset: string;
  Match: TColumnTreeNode;
  SvcCat: Char;
  DateOfInterest: TFMDateTime;
begin  {processSearch body}

  FICDLookup := False;

  if ebLex.text = '' then
  begin
   InfoBox('Enter a term to search for, then click "SEARCH"', 'Information', MB_OK or MB_ICONINFORMATION);
   exit; {don't bother to drop if no text entered}
  end;

  if Extend then
    subset := ' by Extended Search'
  else
    subset := '';

  FBuildingList := True;

  ProblemList := TStringList.Create;
  try
    Screen.Cursor := crHourglass;
    updateStatus('Searching ' + subset + '...');

    v := uppercase(ebLex.text);

    SvcCat := Encounter.VisitCategory;
    if (SvcCat = 'E') or (SvcCat = 'H') then
      DateOfInterest := FMNow
    else
      DateOfInterest := Encounter.DateTime;

    if (v <> '') then
    begin
      if Extend then
        ProblemList.Assign(ProblemLexiconSearch(v, DateOfInterest, True))
      else
        ProblemList.Assign(ProblemLexiconSearch(v, DateOfInterest));
    end;
    if ProblemList.count > 0 then
    begin
      Max := ProblemList[pred(ProblemList.count)]; {get max number found}
      ProblemList.delete(pred(ProblemList.count)); {shed max# found}
      SetColumnTreeModel(ProblemList);
      SetClientWidth(ctfLex);
      UpdateStatus(Max + subset + '.');

      EnableExtend;
      ActiveControl := bbCan;

      if Max = 'Code search failed' then
      begin
       bbOk.Enabled := False;
       Exit;
      end;
      Match := ctfLex.FindNode(v);

      if Match <> nil then
      begin
        bbOk.Enabled := True;
      end
      else
      begin
        ctfLex.tvTree.Items[0].MakeVisible;
        ctfLex.tvTree.Items[0].Selected := True;
      end;
      if Piece(ProblemList.Strings[0],U,1) = 'icd' then
        begin
          bbOK.Enabled := False;
          bbExtendedSearch.Enabled := False;
        end
      else ActiveControl := ctfLex.tvTree;
    end
    else {search results are empty}
    begin
      updateStatus('No Entries Found ' + subset + ' for "' + ebLex.text + '"');
      if TriedExtend then
      begin
        if not SaveFreetext then
          Exit;
        PLProblem := SetFreetextProblem;
        if (not Application.Terminated) and (not uInit.TimedOut) then
          if Assigned(frmProblems) then PostMessage(frmProblems.Handle, UM_PLLex, 0, 0);
        Close;
      end
      else
      begin
        EnableExtend;
        FExtendOffered := true;
      end;
    end;
  finally
    ProblemList.free;
    FBuildingList := False;
    Screen.Cursor := crDefault;
  end;
end;

function TfrmPLLex.SaveFreetext: Boolean;
var
  FTMsgDialog: TForm;
  SaveFT: Boolean;
begin
  SaveFT := False;
  FTMsgDialog := CreateFreetextMessage(UpperCase(ebLex.Text), FICDVersion);

  with FTMsgDialog do
  try
    Position := poOwnerFormCenter;

    if (ShowModal = ID_YES) then
    begin
      SaveFT := True;
    end;
    finally
      Free;

    Result := SaveFT;
  end;
end;

function TFrmPLLex.SetFreetextProblem: String;
var
  ICDCode: String;
begin
  if FI10Active then ICDCode := 'R69.' else ICDCode := '799.9';
  Result := '1^' + ebLex.Text + '^' + ICDCode + '^^^^|' + ebLex.Text;
end;

procedure TfrmPLLex.EnableExtend;
begin
  bbSearch.Enabled := false;
  bbExtendedSearch.Visible := true;
  bbExtendedSearch.Enabled := true;
  bbExtendedSearch.setFocus;
end;

procedure TfrmPLLex.DisableExtend;
begin
  bbSearch.Enabled := true;
  bbExtendedSearch.Enabled := false;
end;

procedure TfrmPLLex.EnableFreeText;
begin
  bbFreetext.Visible := true;
  bbFreetext.Enabled := true;
end;

procedure TfrmPLLex.DisableFreeText;
begin
  bbFreetext.Enabled := false;
  bbFreetext.Visible := false;
end;

procedure TfrmPLLex.FormShow(Sender: TObject);
begin
  ebLex.setfocus;
  RequestNTRT := False;
  if FSuppressCodes then
  begin
    ctfLex.hdrColumns.Sections[1].Width := 0;
    ctfLex.hdrColumns.Sections[1].MaxWidth := 0;
    ctfLex.hdrColumns.Sections[2].Width := 0;
    ctfLex.hdrColumns.Sections[2].MaxWidth := 0;
  end;
  if Piece(FICDVersion, U, 1) = '10D' then
  begin
    ctfLex.hdrColumns.Sections[2].Width := 0;
    ctfLex.hdrColumns.Sections[2].MaxWidth := 0;
  end;
  CenterForm(ctfLex, ctfLex.ClientWidth);
  if FSuppressCodes then
     ctfLex.hdrColumns.Sections[0].MinWidth := ctfLex.hdrColumns.Sections[0].Width;
end;

procedure TfrmPLLex.lvLexClick(Sender: TObject);
begin
  inherited;
  bbOK.Enabled := true;
  bbOKClick(sender);
end;

procedure TfrmPLLex.lvLexCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
var
  Format, i: Integer;
  Left: Array[0..2] of Integer;
  ARect: TRect;
begin
  inherited;
  DefaultDraw := True;
  // if Problem Text is long, draw the ListView element yourself
  if TextWidthByFont(Font.Handle, Item.Caption) > 490 then
  begin
    // draw the Problem Text
    ARect := Item.DisplayRect(drLabel);
    Left[0] := ARect.Left;
    Left[1] := Left[0] + Sender.Column[0].Width;
    Left[2] := Left[1] + Sender.Column[1].Width;
    ARect.Left := ARect.Left + 2;
    ARect.Right := ARect.Right - 2;
    Format := (DT_LEFT or DT_NOPREFIX or DT_WORD_ELLIPSIS);
    DrawText(Sender.Canvas.Handle, PChar(Item.Caption), Length(Item.Caption), ARect, Format);
    // now draw SNOMED-CT & ICD codes
    for i := 0 to Item.SubItems.Count - 1 do
    begin
      ARect.Left := Left[i + 1] + Sender.Margins.Left;
      ARect.Right := ARect.Left + Sender.Column[i + 1].Width - Sender.Margins.Right;
      DrawText(Sender.Canvas.Handle, PChar(Item.SubItems[i]), Length(Item.SubItems[i]), ARect, Format);
    end;
    DefaultDraw := False;
  end;
end;

function TfrmPLLex.ctfLexGridWidth(ctf: TColumnTreeFrame): Integer;
var
  i, w: Integer;
begin
  w := 0;
  for i := 0 to ctf.hdrColumns.Sections.Count - 1 do
    w := w + ctf.hdrColumns.Sections[i].Width;

  Result := w;
end;

procedure TfrmPLLex.lvLexInfoTip(Sender: TObject; Item: TListItem;
  var InfoTip: string);
begin
  inherited;
  // Only show hint if caption is less than width of Column[0]
  if TextWidthByFont(Font.Handle, Item.Caption) < (Sender as TListview).Column[0].Width then
    InfoTip := '';
end;

end.
