unit fDebugReport;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, StdCtrls, Buttons, ExtCtrls, ORNet, Trpcb, uCore;

type

  tRPCArray = record
    RPCData: TStringList;
  end;

  tDebugThread = class(TThread)
  private
    fThreadDone: Boolean;
    fDescription: TStringList;
    RPCArray: array of tRPCArray;
    ThreadBroker: TRPCBroker;
  protected
    procedure Execute; override;
  public
    constructor Create(ActionDescription: TStrings; RPCParams: string);
    destructor Destroy; override;
  end;

  TfrmDebugReport = class(TForm)
    pnlLeft: TPanel;
    img1: TImage;
    pnlMain: TPanel;
    splUser: TSplitter;
    Panel1: TPanel;
    lbl2: TLabel;
    ActionMemo: TMemo;
    pnl1: TPanel;
    lbl1: TLabel;
    IssueMemo: TMemo;
    pnl2: TPanel;
    btnSend: TBitBtn;
    btnCancel: TBitBtn;
    procedure ActionMemoChange(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDebugReport: TfrmDebugReport;

implementation

{$R *.dfm}

procedure TfrmDebugReport.ActionMemoChange(Sender: TObject);
begin
  btnSend.Enabled := Trim(ActionMemo.Text) > '';
end;

procedure TfrmDebugReport.btnCancelClick(Sender: TObject);
begin
  Self.Close;
end;

procedure TfrmDebugReport.btnSendClick(Sender: TObject);
var
  DebugThread: tDebugThread;
  ConnectionParam: String;
//  SavedCursor: Integer;
  ReturnCursor: Integer;
begin
  ReturnCursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  try
   if Trim(ActionMemo.Text) > '' then
   begin
     ConnectionParam := RPCBrokerV.Server + '^' +
              IntToStr(RPCBrokerV.ListenerPort) + '^' +
              GetAppHandle(RPCBrokerV) + '^' +
              RPCBrokerV.User.Division;

     DebugThread := tDebugThread.Create(ActionMemo.Lines, ConnectionParam);
{$WARN SYMBOL_DEPRECATED OFF} // researched
     DebugThread.Resume;
{$WARN SYMBOL_DEPRECATED ON} // researched
     Self.Close;
  end;
  finally
   Screen.Cursor := ReturnCursor;
  end;
end;

procedure TfrmDebugReport.FormShow(Sender: TObject);
begin
  ActionMemo.Text := '';
  btnSend.Enabled := False;
  ActionMemo.SetFocus;
end;

constructor tDebugThread.Create(ActionDescription: TStrings; RPCParams: string);

function Piece(const S: string; Delim: char; PieceNum: Integer): string;
{ returns the Nth piece (PieceNum) of a string delimited by Delim }
var
  i: Integer;
  Strt, Next: PChar;
begin
  i := 1;
  Strt := PChar(S);
  Next := StrScan(Strt, Delim);
  while (i < PieceNum) and (Next <> nil) do
  begin
    Inc(i);
    Strt := Next + 1;
    Next := StrScan(Strt, Delim);
  end;
  if Next = nil then Next := StrEnd(Strt);
  if i < PieceNum then Result := '' else SetString(Result, Strt, Next - Strt);
end;

begin
  inherited Create(True);
  fThreadDone := false;
  fDescription := TStringList.Create;
  fDescription.Assign(ActionDescription);
  FreeOnTerminate := True;
  SetLength(RPCArray, 0);
  try
   ThreadBroker := TRPCThreadBroker.Create(nil);
   ThreadBroker.Server := Piece(RPCParams, '^', 1);
   ThreadBroker.ListenerPort := StrToIntDef(Piece(RPCParams, '^', 2), 0000);
   ThreadBroker.LogIn.LogInHandle := Piece(RPCParams, '^', 3);
   ThreadBroker.LogIn.Division := Piece(RPCParams, '^', 4);
   ThreadBroker.LogIn.Mode := lmAppHandle;
   ThreadBroker.KernelLogIn := False;
   ThreadBroker.Connected := True;

  except
   FreeAndNil(ThreadBroker);
  end;
end;

destructor tDebugThread.Destroy;
var
  I: Integer;
begin
  inherited;
  fDescription.Free;
  fThreadDone := true;
  for I := High(RPCArray) downto Low(RPCArray) do
    if Assigned(RPCArray[i].RPCData) then
      FreeAndNil(RPCArray[i].RPCData);
  SetLength(RPCArray, 0);
  ThreadBroker.Connected := false;
  FreeAndNil(ThreadBroker);
end;

procedure tDebugThread.Execute;
var
  I: Integer;
  UniqueKey: string;

  function FilteredString(const x: string; ATabWidth: Integer = 8): string;
var
  i, j: Integer;
  c: char;
begin
  Result := '';
  for i := 1 to Length(x) do begin
    c := x[i];
    if c = #9 then begin
      for j := 1 to (ATabWidth - (Length(Result) mod ATabWidth)) do
        Result := Result + ' ';
    end else if CharInSet(c, [#32..#127]) then begin
      Result := Result + c;
    end else if CharInSet(c, [#10, #13, #160]) then begin
      Result := Result + ' ';
    end else if CharInSet(c, [#128..#159]) then begin
      Result := Result + '?';
    end else if CharInSet(c, [#161..#255]) then begin
      Result := Result + x[i];
    end;
  end;

  if Copy(Result, Length(Result), 1) = ' ' then Result := TrimRight(Result) + ' ';
end;

  procedure SendTheRpc(RPCList: TStringList; UniqueKey: string);
  var
    LnCnt: Integer;
  begin
    with ThreadBroker do
    begin
      ClearParameters := True;
      RemoteProcedure := 'ORDEBUG SAVERPCS';

      //send the unique key
      Param[0].PType := literal;
      Param[0].Value := UniqueKey;

      //send the RPC Data
      Param[1].PType := list;
      for LnCnt := 0 to RPCList.Count - 1 do
        ThreadBroker.Param[1].Mult[IntToStr(LnCnt)] := FilteredString(RPCList.Strings[LnCnt]);

      ThreadBroker.Call;

    end;
  end;

  procedure SendTheDesc(Description: TStringList; UniqueKey: string);
  var
    LnCnt: Integer;
  begin
    with ThreadBroker do
    begin
      ClearParameters := True;
      RemoteProcedure := 'ORDEBUG SAVEDESC';

      //send the unique key
      Param[0].PType := literal;
      Param[0].Value := UniqueKey;

      //send the RPC Data
      Param[1].PType := list;
      for LnCnt := 0 to Description.Count - 1 do
        ThreadBroker.Param[1].Mult[IntToStr(LnCnt)] := FilteredString(Description.Strings[LnCnt]);

      ThreadBroker.Call;
      //CallBroker;

    end;
  end;

begin
  if Terminated then Exit;

  //set unique key
  UniqueKey := IntToStr(User.DUZ) + '^' + FormatDateTime('mm/dd/yyyy hh:mm:ss', Now());

  //save the users text
  SendTheDesc(fDescription, UniqueKey);

  //Collect all the RPC's up to that point
  for I := (RetainedRPCCount - 1) downto 0 do
  begin
    SetLength(RPCArray, Length(RPCArray) + 1);
    RPCArray[High(RPCArray)].RPCData := TStringList.Create;
    LoadRPCData(RPCArray[High(RPCArray)].RPCData, I);
  end;

  //Send in the rpc list
  for I := High(RPCArray) downto Low(RPCArray) do
  begin
    SendTheRpc(RPCArray[i].RPCData, UniqueKey);
  end;

  Sleep(Random(100));
end;


end.

