unit fPCELex;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, uCore,
  fAutoSz, StdCtrls, ORFn, ORCtrls, ExtCtrls, Buttons, VA508AccessibilityManager,
  ComCtrls, mColumnTree, fBase508Form, CommCtrl, mRadioListView, ORStaticText;

type
  TfrmPCELex = class(TfrmBase508Form)
    txtSearch: TCaptionEdit;
    cmdSearch: TButton;
    pnlStatus: TPanel;
    pnlDialog: TPanel;
    pnlButtons: TPanel;
    cmdOK: TButton;
    cmdCancel: TButton;
    cmdExtendedSearch: TBitBtn;
    pnlSearch: TPanel;
    pnlList: TPanel;
    lblStatus: TVA508StaticText;
    ctfLex: TColumnTreeFrame;
    lblSelect: TVA508StaticText;
    lblSearch: TLabel;
    procedure cmdSearchClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure txtSearchChange(Sender: TObject);
    procedure cmdExtendedSearchClick(Sender: TObject);
    function isNumeric(inStr: String): Boolean;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
//    procedure lvLexCustomDrawItem(Sender: TCustomListView; Item: TListItem;
//      State: TCustomDrawState; var DefaultDraw: Boolean);
//    procedure lvLexInfoTip(Sender: TObject; Item: TListItem;
//      var InfoTip: string);
    procedure ctfLextvTreeChange(Sender: TObject; Node: TTreeNode);
    procedure ctfLextvTreeClick(Sender: TObject);
    procedure ctfLextvTreeDblClick(Sender: TObject);
    procedure ctfLextvTreeEnter(Sender: TObject);
    procedure ctfLextvTreeExit(Sender: TObject);
    procedure ctfLextvTreeHint(Sender: TObject; const Node: TTreeNode;
      var Hint: string);
    procedure ctfLextvTreeExpanding(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
  private
    FLexApp: Integer;
    FSuppressCodes: Boolean;
    FCode:   string;
    FDate:   TFMDateTime;
    FICDVersion: String;
    FI10Active: Boolean;
    FExtend: Boolean;
    FMessage: String;
    FSingleCodeSys: Boolean;
    FCodeSys: String;
    LexShowHint: TShowHintEvent;

    TreeView1HintText: string;
    DefTreeViewWndProc: TWndMethod;

    function ParseNarrCode(ANarrCode: String): String;
    function ctfLexGridWidth: Integer;
    procedure SetApp(LexApp: Integer);
    procedure SetDate(ADate: TFMDateTime);
    procedure SetICDVersion;
    procedure enableExtend;
    procedure disableExtend;
    procedure updateStatus(status: String);
    procedure SetColumnTreeModel(ResultSet: TStrings);
    procedure processSearch;
    procedure setClientWidth;
    procedure CenterForm(w: Integer);
    procedure ApplicationShowHint(var HintStr: String; var CanShow: Boolean;
      var HintInfo: Controls.THintInfo);

    procedure TreeViewWndProc(var Message: TMessage);
  end;

  // subclass THintWindow to override font size
  TTreeViewHintWindowClass = class(THintWindow)
  public
    constructor Create(AOwner: TComponent); override;
    procedure SetFontSize(fontsize: Integer);
    function GetFontSize: Integer;
  end;

procedure LexiconLookup(var Code: string; ALexApp: Integer; ADate: TFMDateTime = 0; AExtend: Boolean = False; ASearchString: String = ''; AMessage: String = '');

implementation

{$R *.DFM}

uses rPCE, uProbs, rProbs, UBAGlobals;

var
  tvHintWindowClass: TTreeViewHintWindowClass;
  TriedExtend: Boolean = false;

constructor TTreeViewHintWindowClass.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  // use CPRS font size for hint window
  SetFontSize(Application.MainForm.Font.Size);
  tvHintWindowClass := Self;
end;

function TTreeViewHintWindowClass.GetFontSize: Integer;
begin
  Result := Canvas.Font.Size;
end;

procedure TTreeViewHintWindowClass.SetFontSize(fontsize: Integer);
begin
  Canvas.Font.Size := fontsize;
end;

procedure LexiconLookup(var Code: string; ALexApp: Integer; ADate: TFMDateTime = 0; AExtend: Boolean = False; ASearchString: String = ''; AMessage: String = '');
var
  frmPCELex: TfrmPCELex;
begin
  frmPCELex := TfrmPCELex.Create(Application);
  try
    ResizeFormToFont(TForm(frmPCELex));
    if (ADate = 0) and not ((Encounter.VisitCategory = 'E') or (Encounter.VisitCategory = 'H')
      or (Encounter.VisitCategory = 'D')) then
        ADate := Encounter.DateTime;
    if (ASearchString <> '') then
      frmPCELex.txtSearch.Text := Piece(frmPCELex.ParseNarrCode(ASearchString), U, 2);
    frmPCELex.SetApp(ALexApp);
    frmPCELex.SetDate(ADate);
    frmPCELex.SetICDVersion;
    frmPCELex.FMessage := AMessage;
    frmPCELex.FExtend := AExtend;
    if (ALexApp = LX_ICD) then
      frmPCELex.FExtend := True;
    frmPCELex.ShowModal;
    Code := frmPCELex.FCode;
    if (ASearchString <> '') and (Pos('(SCT', ASearchString) > 0) and (ALexApp <> LX_SCT) then
      SetPiece(Code, U, 2, ASearchString);
  finally
    frmPCELex.Free;
  end;
end;

procedure TfrmPCELex.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  Application.OnShowHint := LexShowHint;
  Release;
end;

procedure TfrmPCELex.FormCreate(Sender: TObject);
var
  UserProps: TStringList;
begin
  inherited;
  FCode := '';
  FCodeSys := '';
  FI10Active := False;
  FSingleCodeSys := True;
  FExtend := False;
  UserProps := TStringList.Create;
  FastAssign(InitUser(User.DUZ), UserProps);
  PLUser := TPLUserParams.create(UserProps);
  FSuppressCodes := PLUser.usSuppressCodes;
  ResizeAnchoredFormToFont(self);
  LexShowHint := Application.OnShowHint;
  Application.OnShowHint := ApplicationShowHint;

  DefTreeViewWndProc := ctfLex.tvTree.WindowProc;
  ctfLex.tvTree.WindowProc := TreeViewWndProc;
end;

procedure TfrmPCELex.FormShow(Sender: TObject);
var
  lt: String;
  dh, lh: Integer;
begin
  inherited;
  if FSuppressCodes then
  begin
    ctfLex.hdrColumns.Sections[1].Width := 0;
    ctfLex.hdrColumns.Sections[2].Width := 0;
    ctfLex.hdrColumns.Sections[3].Width := 0;
  end;
  if FMessage <> '' then
  begin
    lt := lblSearch.Caption;
    lh := lblSearch.Height;
    lblSearch.AutoSize := True;
    lblSearch.Caption := FMessage + CRLF + CRLF + lt;
    lblSearch.AutoSize := False;
    dh := (lblSearch.Height - lh);
    pnlSearch.Height := pnlSearch.Height + dh;
    Height := Height + dh;
  end;
  CenterForm(ctfLex.ClientWidth);
  if FExtend and (txtSearch.Text <> '') then
  begin
    if FExtend then
      cmdExtendedSearch.Click
    else
      cmdSearch.Click;
  end;
end;

procedure TfrmPCELex.SetApp(LexApp: Integer);
begin
  FLexApp := LexApp;
  case LexApp of
  LX_ICD: begin
            Caption := 'Lookup Diagnosis';
            lblSearch.Caption := 'Search for Diagnosis:';
          end;
  LX_CPT: begin
            Caption := 'Lookup Procedure';
            lblSearch.Caption := 'Search for Procedure:';
          end;
  end;
end;

procedure TfrmPCELex.SetDate(ADate: TFMDateTime);
begin
  FDate := ADate;
end;

procedure TfrmPCELex.SetICDVersion;
begin
  FICDVersion := Encounter.GetICDVersion;
  if (Piece(FICDVersion, '^', 1) = '10D') then
    FI10Active := True;
  cmdExtendedSearch.Hint := 'Search ' + Piece(FICDVersion, '^', 2) + ' Diagnoses...';
  ctfLex.hdrColumns.Sections[3].Text := Piece(FICDVersion, '^', 2);
end;

procedure TfrmPCELex.TreeViewWndProc(var Message: TMessage);
var
  Pt: TPoint;
  Node: TTreeNode;
  LItemRect: TRect;
  LMaxWidth: Integer;
begin
  if Message.Msg = WM_NOTIFY then
    begin
      with TWMNotify(Message) do
        begin
          if NMHdr^.code = TTN_NEEDTEXTW then
            begin
              if (PToolTipTextW(NMHdr)^.uFlags and TTF_IDISHWND) <> 0 then
                begin
                  GetCursorPos(Pt);
                  Pt := ctfLex.tvTree.ScreenToClient(Pt);
                  Node := ctfLex.tvTree.GetNodeAt(Pt.X, Pt.Y);
                  if Node <> nil then
                    begin
                      TreeView1HintText := Node.Text;

                      with PToolTipTextW(NMHdr)^ do
                        begin
                          lpszText := PWideChar(TreeView1HintText);
                          hInst := 0;
                        end;

                      LItemRect := Node.DisplayRect(True);
                      if LItemRect.Left < 0 then
                        LItemRect.Left := 0;
                      LItemRect.TopLeft := ctfLex.tvTree.ClientToScreen(LItemRect.TopLeft);

                      LMaxWidth := SendMessage(NMHdr^.hwndFrom, TTM_GETMAXTIPWIDTH, 0, 0);
                      if LMaxWidth = -1 then
                        begin
                          LMaxWidth := 250; // use whatever you need...
                          SendMessage(NMHdr^.hwndFrom, TTM_SETMAXTIPWIDTH, LMaxWidth, 0);
                        end;

                      SendMessage(NMHdr^.hwndFrom, TTM_ADJUSTRECT, WPARAM(True), LPARAM(@LItemRect));
                      SetWindowPos(NMHdr^.hwndFrom, HWND_TOP, LItemRect.Left, LItemRect.Top,
                        0, 0, SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOOWNERZORDER);

                      Message.Result := 1;
                    end;
                end;
            end;

          Exit;
        end;
    end;
  DefTreeViewWndProc(Message);
end;

procedure TfrmPCELex.enableExtend;
begin
  cmdExtendedSearch.Visible := true;
  cmdExtendedSearch.Enabled := true;
end;

procedure TfrmPCELex.disableExtend;
begin
  cmdExtendedSearch.Enabled := false;
  cmdExtendedSearch.Visible := false;
  if not FI10Active then
    FExtend := False;
end;

procedure TfrmPCELex.txtSearchChange(Sender: TObject);
begin
  inherited;
  cmdSearch.Default := True;
  cmdOK.Default := False;
  cmdCancel.Default := False;
  disableExtend;
  if ctfLex.tvTree.Items.Count > 0 then
  begin
    ctfLex.tvTree.Selected := nil;
    ctfLex.tvTree.Items.Clear;
    CenterForm(Constraints.MinWidth);
  end;
end;

procedure TfrmPCELex.cmdSearchClick(Sender: TObject);
begin
  TriedExtend := false;
  FCodeSys := '';
  FSingleCodeSys := True;
  if not FI10Active and (FLexApp = LX_ICD) then
    FExtend := False;
  processSearch;
end;

procedure TfrmPCELex.setClientWidth;
var
  i, maxw, tl, maxtl, csl, maxcsl, cl, maxcl, il, maxil: integer;
  node: TColumnTreeNode;
begin
  maxtl := 0;
  maxcsl := 0;
  maxcl := 0;
  maxil := 0;
  for i := 0 to pred(ctfLex.tvTree.Items.Count) do
  begin
    node := ctfLex.tvTree.Items[i] as TColumnTreeNode;
    tl := TextWidthByFont(Font.Handle, node.Text);
    if (tl > maxtl) then
      maxtl := tl;
    csl := TextWidthByFont(Font.Handle, node.CodeSys);
    if (csl > maxcsl) then
      maxcsl := csl;
    cl := TextWidthByFont(Font.Handle, node.Code);
    if (cl > maxcl) then
      maxcl := cl;
    il := TextWidthByFont(Font.Handle, node.Columns[3]);
    if (il > maxil) then
      maxil := il;
  end;

  il := TextWidthByFont(Font.Handle, Piece(FICDVersion, '^', 2));
  if ((maxil <> 0) and (il > maxil)) then
    maxil := il;

  csl := TextWidthByFont(Font.Handle, 'Code System');
  if (csl > maxcsl) then
    maxcsl := csl;

  //max text width = 500
  if maxtl > 490 then
    maxtl := 490;

  //set TreeView column widths
  ctfLex.hdrColumns.Sections[0].Width := maxtl + 10;
  if FSuppressCodes then
  begin
    maxw := maxtl + 10;
  end
  else
  begin
    if FSingleCodeSys then
    begin
      ctfLex.hdrColumns.Sections[1].Width := 0;
      ctfLex.hdrColumns.Sections[1].MaxWidth := 0;
      ctfLex.hdrColumns.Sections[2].Text := FCodeSys;
      if (maxcsl > maxcl) then
         maxcl := maxcsl;      
    end
    else
    begin
      ctfLex.hdrColumns.Sections[1].Width := maxcsl + 15;
      ctfLex.hdrColumns.Sections[2].Text := 'Code';
    end;
    ctfLex.hdrColumns.Sections[2].Width := maxcl + 15;
    if (maxil = 0) then
      ctfLex.hdrColumns.Sections[3].Width := 0
    else
      ctfLex.hdrColumns.Sections[3].Width := maxil + 15;
    maxw := maxtl + maxcsl + maxcl + maxil + 55;
  end;

  //resize lv to maximum pixel width of its elements
  if (maxw > 0) and (self.ClientWidth <> maxw) then
  begin
    CenterForm(maxw);
  end;
end;

procedure TfrmPCELex.ApplicationShowHint(var HintStr: String;
  var CanShow: Boolean; var HintInfo: Controls.THintInfo);
begin
  if HintInfo.HintControl = ctfLex.tvTree then
  begin
    HintInfo.HintWindowClass := TTreeViewHintWindowClass;
    if tvHintWindowClass <> nil then
      if tvHintWindowClass.GetFontSize <> Application.MainForm.Font.Size then
        tvHintWindowClass.SetFontSize(Application.MainForm.Font.Size);
  end;
end;

procedure TfrmPCELex.CenterForm(w: Integer);
var
  wdiff, mainw, gw: Integer;
begin
  mainw := Application.MainForm.Width;
  self.Constraints.MaxWidth := 0;
  if (w > mainw) then
  begin
    w := mainw;
  end;

  self.ClientWidth := w + (ctfLex.Width - ctfLex.ClientWidth) + (pnlList.Padding.Left + pnlList.Padding.Right);
  gw := ctfLexGridWidth;
  if (ctfLex.tvTree.ClientWidth > gw) then
    ctfLex.hdrColumns.Sections[0].Width := ctfLex.hdrColumns.Sections[0].Width + (ctfLex.tvTree.ClientWidth - gw);

  wdiff := ((mainw - self.Width) div 2);
  self.Left := Application.MainForm.Left + wdiff;
  self.Constraints.MaxWidth := self.Width;

  invalidate;
end;

procedure TfrmPCELex.SetColumnTreeModel(ResultSet: TStrings);
var
  i: Integer;
  Node, StubNode: TColumnTreeNode;
  RecStr: String;
begin
  ctfLex.tvTree.Items.Clear;
  for i := 0 to ResultSet.Count - 1 do
  begin
    RecStr := ResultSet[i];
    if Piece(RecStr, '^', 8) = '' then
      Node := (ctfLex.tvTree.Items.Add(nil, Piece(RecStr, '^', 2))) as TColumnTreeNode
    else
      Node := (ctfLex.tvTree.Items.AddChild(ctfLex.tvTree.Items[(StrToInt(Piece(RecStr, '^', 8))-1)], Piece(RecStr, '^', 2))) as TColumnTreeNode;

    with Node do
    begin
      VUID := Piece(RecStr, '^', 1);
      Text := Piece(RecStr, '^', 2);
      CodeSys := Piece(RecStr, '^', 3);

      if ((FCodeSys <> '') and (CodeSys <> FCodeSys)) then
        FSingleCodeSys := False;

      FCodeSys := CodeSys;

      Code := Piece(RecStr, '^', 4);

      if Piece(RecStr, '^', 8) <> '' then
        ParentIndex := IntToStr(StrToInt(Piece(RecStr, '^', 8)) - 1);

      //TODO: Need to accommodate Designation Code in ColumnTreeNode...
      if CodeSys = 'SNOMED CT' then
        CodeIEN := Code
      else
        CodeIEN := Piece(RecStr, '^', 9);


      Columns := TStringList.Create;
      //Columns[0] = Text
      Columns.Add(Piece(RecStr, '^', 2));
      //Columns[1] = CodeSys
      Columns.Add(Piece(RecStr, '^', 3));
      //Columns[2] = Code
      Columns.Add(Piece(RecStr, '^', 4));
      //Columns[3] = Mapped ICD target(s)
      Columns.Add(Piece(RecStr, '^', 6));
    end;
    if (Node.VUID = '+') then
    begin
      StubNode := (ctfLex.tvTree.Items.AddChild(Node, 'Searching...')) as TColumnTreeNode;
      with StubNode do
      begin
        VUID := '';
        Text := 'Searching...';
        CodeSys := 'ICD-10-CM';

        if ((FCodeSys <> '') and (CodeSys <> FCodeSys)) then
          FSingleCodeSys := False;

        FCodeSys := CodeSys;

        Code := '';
        CodeIEN := '';

        ParentIndex := IntToStr(Node.Index);
        Columns := TStringList.Create;
        //Columns[0] = Text
        Columns.Add('Searching...');
        //Columns[1] = CodeSys
        Columns.Add('ICD-10-CM');
        //Columns[2] = Code
        Columns.Add('');
        //Columns[3] = Mapped ICD target(s)
        Columns.Add('');
      end;
    end;
  end;
  //sort treenodes
  ctfLex.tvTree.AlphaSort(True);
end;

procedure TfrmPCELex.processSearch;
const
  TX_SRCH_REFINE1 = 'Your search ';
  TX_SRCH_REFINE2 = ' matched ';
  TX_SRCH_REFINE3 = ' records, too many to display.' + CRLF + CRLF + 'Suggestions:' + CRLF +
                    #32#32#32#32#42 + '   Refine your search by adding more words' + CRLF + #32#32#32#32#42 + '   Try different keywords';
  MaxRec = 0000;
var
  LexResults: TStringList;
  found, subset, SearchStr: String;
  FreqOfText: integer;
  Match: TColumnTreeNode;
begin
  if Length(txtSearch.Text) = 0 then
  begin
   InfoBox('Enter a term to search for, then click "SEARCH"', 'Information', MB_OK or MB_ICONINFORMATION);
   exit; {don't bother to drop if no text entered}
  end;

  if (FLexApp = LX_ICD) or (FLexApp = LX_SCT) then
  begin
    if FExtend and (FLexApp = LX_ICD) then
      subset := Piece(FICDVersion, '^', 2) + ' Diagnoses'
    else
      subset := 'SNOMED CT Concepts';
  end
  else if FLexApp = LX_CPT then
    subset := 'Current Procedural Terminology (CPT)'
  else
    subset := 'Clinical Lexicon';

  LexResults := TStringList.Create;

  try
    Screen.Cursor := crHourGlass;
    updateStatus('Searching ' + subset + '...');
    SearchStr := Uppercase(txtSearch.Text);
    FreqOfText := GetFreqOfText(SearchStr);
    if FreqOfText > MaxRec then
    begin
      InfoBox(TX_SRCH_REFINE1 + #39 + SearchStr + #39 + TX_SRCH_REFINE2 + IntToStr(FreqOfText) + TX_SRCH_REFINE3,'Refine Search', MB_OK or MB_ICONINFORMATION);
      lblStatus.Caption := '';
      Exit;
    end;
    ListLexicon(LexResults, SearchStr, FLexApp, FDate, FExtend, FI10Active);

    if (Piece(LexResults[0], u, 1) = '-1') then
    begin
      found := '0 matches found';
      if FExtend then
        found := found + ' by ' + subset + ' Search.'
      else
        found := found + '.';
      lblSelect.Visible := False;
      txtSearch.SetFocus;
      txtSearch.SelectAll;
      cmdOK.Default := False;
      cmdOK.Enabled := False;
      ctfLex.tvTree.Enabled := False;
      ctfLex.tvTree.Items.Clear;
      cmdCancel.Default := False;
      cmdSearch.Default := True;
//      if not FExtend and ((FLexApp = LX_SCT) or (FLexApp = LX_ICD)) then
      if not FExtend and (FLexApp = LX_ICD) then
      begin
//        enableExtend;
//        cmdExtendedSearch.Setfocus;
        cmdExtendedSearch.Click;
        Exit;
      end;
    end
    else
    begin
      found := inttostr(LexResults.Count) + ' matches found';
      if FExtend then
        found := found + ' by ' + subset + ' Search.'
      else
        found := found + '.';

      SetColumnTreeModel(LexResults);

      setClientWidth;
      lblSelect.Visible := True;
      ctfLex.tvTree.Enabled := True;
      ctfLex.tvTree.SetFocus;

      Match := ctfLex.FindNode(SearchStr);

      if Match <> nil then
      begin  {search term is on return list, so highlight it}
        cmdOk.Enabled := True;
        ActiveControl := cmdOK;
      end;

//      if (not FExtend) and ((FLexApp = LX_ICD) or (FLexApp = LX_SCT)) and (not isNumeric(txtSearch.Text)) then
      if (not FExtend) and (FLexApp = LX_ICD) and (not isNumeric(txtSearch.Text)) then
        enableExtend;
      cmdSearch.Default := False;
    end;
    updateStatus(found);
  finally
    LexResults.Free;
    Screen.Cursor := crDefault;
  end;
end;

{procedure TfrmPCELex.lvLexCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
var
  Format, i: Integer;
  Left: Array[0..3] of Integer;
  ARect: TRect;
begin
  inherited;
  DefaultDraw := True;
  // if Problem Text is long, draw the ListView element yourself
  if TextWidthByFont(Font.Handle, Item.Caption) > 490 then
  begin
    // draw the Problem Text
    ARect := Item.DisplayRect(drLabel);
    Left[0] := ARect.Left;
    Left[1] := Left[0] + Sender.Column[0].Width;
    Left[2] := Left[1] + Sender.Column[1].Width;
    Left[3] := Left[2] + Sender.Column[2].Width;
    ARect.Left := ARect.Left + 2;
    ARect.Right := ARect.Right - 2;
    Format := (DT_LEFT or DT_NOPREFIX or DT_WORD_ELLIPSIS);
    DrawText(Sender.Canvas.Handle, PChar(Item.Caption), Length(Item.Caption), ARect, Format);
    // now draw SNOMED-CT & ICD codes
    for i := 0 to Item.SubItems.Count - 1 do
    begin
      ARect.Left := Left[i + 1] + Sender.Margins.Left;
      ARect.Right := ARect.Left + Sender.Column[i + 1].Width - Sender.Margins.Right;
      DrawText(Sender.Canvas.Handle, PChar(Item.SubItems[i]), Length(Item.SubItems[i]), ARect, Format);
    end;
    DefaultDraw := False;
  end;
end;}

procedure TfrmPCELex.cmdExtendedSearchClick(Sender: TObject);
begin
  inherited;
  FExtend := True;
  FCodeSys := '';
  FSingleCodeSys := True;
  processSearch;
  disableExtend;
end;

procedure TfrmPCELex.cmdOKClick(Sender: TObject);
var
  Node: TColumnTreeNode;
begin
  inherited;
  if(ctfLex.SelectedNode = nil) then
    Exit;
  Node := ctfLex.SelectedNode;
  if ((FLexApp = LX_ICD) or (FLexApp = LX_SCT)) and (Node.Code <> '') then
  begin
    if (Copy(Node.CodeSys, 0, 3) = 'ICD') then
      FCode := Node.Code + U + Node.Text
    else if (Copy(Node.CodeSys, 0, 3) = 'SNO')  then
      FCode := Node.Columns[3] + U + Node.Text + ' (SNOMED CT ' + Node.Code + ')';

    FCode := FCode + U + Node.CodeIEN + U + Node.CodeSys;
  end
  else if BAPersonalDX then
    FCode := LexiconToCode(StrToInt(Node.VUID), FLexApp, FDate) + U + Node.Text + U + Node.VUID
  else
    FCode := LexiconToCode(StrToInt(Node.VUID), FLexApp, FDate) + U + Node.Text;
  Close;
end;

procedure TfrmPCELex.cmdCancelClick(Sender: TObject);
begin
  inherited;
  FCode := '';
  Close;
end;

function TfrmPCELex.ctfLexGridWidth: Integer;
var
  i, w: Integer;
begin
  w := 0;
  for i := 0 to ctfLex.hdrColumns.Sections.Count - 1 do
    w := w + ctfLex.hdrColumns.Sections[i].Width;

  Result := w;
end;

procedure TfrmPCELex.ctfLextvTreeChange(Sender: TObject; Node: TTreeNode);
begin
  inherited;
  ctfLex.tvTreeChange(Sender, Node);
  if (ctfLex.SelectedNode = nil) or (ctfLex.SelectedNode.VUID = '+')  then
  begin
    cmdOK.Enabled := false;
    cmdOk.Default := false;
  end
  else  // valid Node selected
  begin
    cmdOK.Enabled := true;
    cmdOK.Default := true;
    cmdSearch.Default := false;
  end;
end;

procedure TfrmPCELex.ctfLextvTreeClick(Sender: TObject);
begin
  inherited;
  if(ctfLex.SelectedNode <> nil) and (ctfLex.SelectedNode.VUID <> '+') then
  begin
    cmdOK.Enabled := true;
    cmdSearch.Default := False;
    cmdOK.Default := True;
  end;
end;

procedure TfrmPCELex.ctfLextvTreeDblClick(Sender: TObject);
begin
  inherited;
  ctfLextvTreeClick(Sender);
  if ctfLex.SelectedNode.VUID <> '+' then
    cmdOKClick(Sender);
end;

procedure TfrmPCELex.ctfLextvTreeEnter(Sender: TObject);
begin
  inherited;
  if (ctfLex.SelectedNode = nil) then
    cmdOK.Enabled := false
  else
    cmdOK.Enabled := true;
end;

procedure TfrmPCELex.ctfLextvTreeExit(Sender: TObject);
begin
  inherited;
  if (ctfLex.SelectedNode = nil) then
    cmdOK.Enabled := false
  else
    cmdOK.Enabled := true;
end;

procedure TfrmPCELex.ctfLextvTreeExpanding(Sender: TObject; Node: TTreeNode;
  var AllowExpansion: Boolean);
var
  ctNode, ChildNode, StubNode: TColumnTreeNode;
  ChildRecs: TStringList;
  RecStr: String;
  i: integer;
begin
  inherited;
  ctNode := Node as TColumnTreeNode;

  if ctNode.VUID = '+' then
  begin
    ChildRecs := TStringList.Create;
    ListLexicon(ChildRecs, ctNode.Code, FLexApp, FDate, True, FI10Active);

    //clear node's placeholder child
    ctNode.DeleteChildren;

    //create children
    for i := 0 to ChildRecs.Count - 1 do
    begin
      RecStr := ChildRecs[i];
      ChildNode := (ctfLex.tvTree.Items.AddChild(ctNode, Piece(RecStr, '^', 2))) as TColumnTreeNode;

      with ChildNode do
      begin
        VUID := Piece(RecStr, '^', 1);
        Text := Piece(RecStr, '^', 2);
        CodeSys := Piece(RecStr, '^', 3);

        if ((FCodeSys <> '') and (CodeSys <> FCodeSys)) then
          FSingleCodeSys := False;

        Code := Piece(RecStr, '^', 4);

        if Piece(RecStr, '^', 8) <> '' then
          ParentIndex := IntToStr(StrToInt(Piece(RecStr, '^', 8)) - 1);

        if CodeSys = 'SNOMED CT' then
          CodeIEN := Code
        else
          CodeIEN := Piece(RecStr, '^', 9);

        Columns := TStringList.Create;
        //Columns[0] = Text
        Columns.Add(Piece(RecStr, '^', 2));
        //Columns[1] = CodeSys
        Columns.Add(Piece(RecStr, '^', 3));
        //Columns[2] = Code
        Columns.Add(Piece(RecStr, '^', 4));
        //Columns[3] = Mapped ICD target(s)
        Columns.Add(Piece(RecStr, '^', 6));
      end;

      if (ChildNode.VUID = '+') then
      begin
        StubNode := (ctfLex.tvTree.Items.AddChild(ChildNode, 'Searching...')) as TColumnTreeNode;
        with StubNode do
        begin
          VUID := '';
          Text := 'Searching...';
          CodeSys := 'ICD-10-CM';

          if ((FCodeSys <> '') and (CodeSys <> FCodeSys)) then
            FSingleCodeSys := False;

          FCodeSys := CodeSys;
          Code := '';
          CodeIEN := '';

          ParentIndex := IntToStr(Node.Index);
          Columns := TStringList.Create;
          //Columns[0] = Text
          Columns.Add('Searching...');
          //Columns[1] = CodeSys
          Columns.Add('ICD-10-CM');
          //Columns[2] = Code
          Columns.Add('');
          //Columns[3] = Mapped ICD target(s)
          Columns.Add('');
        end;
      end;
    end;
  end;
  AllowExpansion := True;
  //sort treenodes
  ctfLex.tvTree.AlphaSort(True);
  ctfLex.tvTree.Invalidate;
end;

procedure TfrmPCELex.ctfLextvTreeHint(Sender: TObject; const Node: TTreeNode;
  var Hint: string);
begin
  inherited;
  // Only show hint if caption is less than width of Column[0]
  if TextWidthByFont(Font.Handle, Node.Text) < ctfLex.hdrColumns.Sections[0].Width then
    Hint := ''
  else
    Hint := Node.Text;
end;

{procedure TfrmPCELex.lvLexInfoTip(Sender: TObject; Item: TListItem;
  var InfoTip: string);
begin
  inherited;
  // Only show hint if caption is less than width of Column[0]
  if TextWidthByFont(Font.Handle, Item.Caption) < (Sender as TListview).Column[0].Width then
    InfoTip := '';
end;}

procedure TfrmPCELex.updateStatus(status: String);
begin
  lblStatus.caption := status;
  lblStatus.Invalidate;
  lblStatus.Update;
end;

function TfrmPCELex.isNumeric(inStr: String): Boolean;
var
  dbl: Double;
  error, intDecimal: Integer;
begin
  Result := False;
  if (FormatSettings.DecimalSeparator <> '.') then
    intDecimal := Pos(FormatSettings.DecimalSeparator, inStr)
  else
    intDecimal := 0;
  if (intDecimal > 0) then
    inStr[intDecimal] := '.';
  Val(inStr, dbl, error);
  if (dbl = 0.0) then
    ; //do nothing
  if (intDecimal > 0) then
    inStr[intDecimal] := FormatSettings.DecimalSeparator;
  if (error = 0) then
    Result := True;
end;

function TfrmPCELex.ParseNarrCode(ANarrCode: String): String;
var
  narr, code: String;
  ps: Integer;
begin
  narr := ANarrCode;
  ps := Pos('(SCT', narr);
  if not (ps > 0) then
    ps := Pos('(SNOMED', narr);
  if not (ps > 0) then
    ps := Pos('(ICD', narr);
  if (ps > 0) then
  begin
    narr := TrimRight(Copy(ANarrCode, 0, ps - 1));
    code := Copy(ANarrCode, ps, ANarrCode.Length);
    code := Piece(Piece(Piece(code, ')', 1), '(', 2), ' ', 2);
  end
  else
    code := '';
  Result := code + U + narr;
end;

end.

