define([
	'jQuery',
	'async',
	'common'
], function(jQuery, async, commonTests){
	var $$ = jQuery.noConflict(true),
		myFrame = $$("#myFrame"),
		setup = function(){
			var host = window.location.protocol + "//" + window.location.host;
			var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname,
				pathArr = referencePath.split('/'),
				appPath = 'AntibiogramWeb';
			
			pathArr.pop();
			pathArr.pop();
			referencePath = pathArr.join('/');

			// make sure EULA test loads before the other tests
			require(['eula'], function() {
				require(['application']); // App framework
				require(['searchView']); // Facility search
				require(['completeView']); // Complete view
			});

			async.series([
				function(next){
					$$(document).ready(function(){
						next();
					});
				},
				// **TO LOG IN**
				/* Removing Auth logic, standalone app will not need to log in
				function(next){
					myFrame.attr('src', referencePath + '../../ssoeproxy/logout')
						.one('load', function(){
							next();
						});
				},
				function(next){
					var url = host + '/MobileHealthPlatformWeb/oauthlogin?redirect_uri=';
					//http://localhost:8080/MobileHealthPlatformWeb/oauthlogin?redirect_uri=http://localhost:8080/AntibiogramWeb/
					var redirectUrl = window.location.protocol + "//" + window.location.host + '/AntibiogramWeb/';
					myFrame.attr('src', url + redirectUrl)
						.one('load', function() { next(); });
				},*/
				// **END TO LOG IN**
				// **TO NOT LOG IN**
				/*function(next) {
				myFrame.attr('src', referencePath + '/' + appPath).one('load', function() { next(); });
				},*/
				// **END TO NOT LOG IN**
				/*function(next){
                    afterJqueryLoad(function () {
                    	//grab jQuery from inside the document
                        $ = jQuery = myFrame[0].contentWindow.jQuery;

                        // **TO LOG IN**
                        $("#name-c").val('zztest.staff01');
                        $("#password").val('pass');
                        $('#autocomplete-container input').val('DC VAMC');
                        $('#facilityName').val('DC VAMC');
                        $("#facilityCode").val('688');
                        // **END TO LOG IN**
                                	
                        //next();
                        $("#logonForm").submit();
                        
                        myFrame.one('load', function(){
                            afterJqueryLoad(function(){
                            	afterOauthTokenInSessionStorage(function(){
                                    next();
                                });
                            });
                        });
                        //next();
                    });
				}*/
			], function(){
				start();
			});

			QUnit.testStart(function(){
                var key = '/AntibiogramWeb/eula';
                window.localStorage[key] = JSON.stringify({dateAccepted: new Date().getTime()});
				stop();
				myFrame.off("load");
				myFrame.attr('src', referencePath)
					.on("load", function(){
						//grab jQuery from inside the document
						$ = jQuery = myFrame[0].contentWindow.jQuery;
						/*if($('h2:contains("End User License Agreement")').length === 1){
                            $('#accept-btn').trigger('tap');
                        }*/

						//turn off async so tests will wait for ajax results
						$.ajaxSetup({ async: false });
						$.getScript(referencePath + "/test/jquery.simulate.js");

						//turn off animations so they do not break tests
						$.support.cssTransitions = false;
						$.fx.off = true;

						var started = false;
						var iFrameDocument = myFrame[0].contentDocument ? myFrame[0].contentDocument : (myFrame[0].contentWindow.document || myFrame[0].document);
						
						// workaround for iframe's load event not working properly
						$(iFrameDocument).ready(function() {
							setTimeout(function() {
								if (!started) {
									started = true;
									QUnit.start();
								}
							}, 1000);
						});
						
						// if workaround fails (jquery ready fired before we could register handler), wait 5 seconds and run
						setTimeout(function() {
							if (!started) {
								started = true;
								QUnit.start();
							}
						}, 5000);
					});
			});
		};

		function afterJqueryLoad(callback){
            if(typeof myFrame[0].contentWindow.jQuery === 'undefined'){
                setTimeout(function(){
                	afterJqueryLoad(callback);
                }, 50);
            }
            else {
        		callback();
            }
        }

        function afterOauthTokenInSessionStorage(callback){
            var token = myFrame[0].contentWindow.sessionStorage.token;
            if(typeof token !== 'undefined' && token && token !== 'null'){
            	window.sessionStorage['token']=token;
            	callback();
            }
            else{
                setTimeout(function(){		
                    afterOauthTokenInSessionStorage(callback);
                }, 200);
            }
        }

	return {
		initialize: setup
	};

});

