define([
	'jQuery',
	'helpers'
], function($$, helpers) {

    module("Organism Search View Tests");

	//***** FUNCTIONS ******//
    function openSearchPage(next) {
		// click the Search button
		ok($( "#footer-antibiogram-search-btn" ).simulate("click"), "When I click the Search button");

		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
	function validateFooter(next) {
        var $footer = $("div[data-role='footer']");
        // make sure the footer is visible
        ok($footer.is(":visible"), "Footer is visible");
        // make sure complete link is present
        ok($footer.find("#footer-launchpad-btn").is(":visible"), "Launchpad link is visible");
        ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
        ok($footer.find("#footer-search-all-btn").is(":visible"), "Complete link is visible");
        ok($footer.find("#footer-about-btn").is(":visible"), "About link is visible");
        next();
    }
    function findFacility(facName, facCode) {
    	// make sure the "Find Facility" box is visible
        ok($("#facilityName").is(":visible"), "Find Facility box is visible");
        // enter facility
        ok($("#facilityName").val(facName).trigger("keydown"), "When I type 'DC' in the box");
        setTimeout(function() {
    		$('.ui-menu-item').find('a').eq(0).trigger("click");
    	}, 100);
        // check contents of box
        equal($("#facilityName").val(), facName, "What I typed is in the box");
        // populate hidden field
        ok($("#facilityCode").val(facCode), "When I populate the hidden field");
        // check contents of hidden field
        equal($("#facilityCode").val(), facCode, "Facility code is populated");
    }

	//***** TESTS *****//
	test("MDPD-641, MDPD-1558, MDPD-1419, MDPD-1421, MDPD-1424, MDPD-1417, MDPD-628, MDPD-652 | "+
        /*"When user is logged in and goes to Search page, facility is already selected, "+*/
        "When user searches for a facility on the Search page, the list of facilities comes up, "+
        "Organism (Search) page can be reached and contains correct elements, "+
        "When facility is entered on Search page, user can type and see list of organisms ", function() {
		stop();
		expect(29);
		async.series([
            openSearchPage,
            validateFooter,
            function (next) {
                // make sure the "Find Facility" box is visible (MDPD-1419)
                ok($("#facilityName").is(":visible"), "Find Facility box is visible");
                // make sure the Data Range selector is visible (MDPD-1421)
                ok($("#select-date-range").is(":visible"), "Data Range selector is visible");
                // make sure the "Search Organisms" box is visible (MDPD-1424)
                ok($("#organismName").is(":visible"), "Search Organisms box is visible");
                next();
            },
		function (next) {
            // Choose a 'new' facility
            findFacility("DC VAMC","688");
            // make sure the "Search Organisms" box is visible
            ok($("#organismName").is(":visible"), "Search Organisms box is visible");
			setTimeout(function() {
				next();
			}, 100);
		},
		// MDPD-652 verify auto-complete
		function (next) {
			// type "as" in the box
			ok($("#organismName").val("esch").trigger("keydown"), "When I type 'esch' in the box");
			setTimeout(function() {
				next();
			}, 100);
		},
        function (next) {
            setTimeout(function() {
                // list appears (MDPD-652)
                ok($("ul.ui-autocomplete li.ui-menu-item:contains('ESCHERICHIA COLI')").is(":visible"), "'ESCHERICHIA COLI' is visible in list");
                next();
            }, 1000);
        },
		// MDPD-628 search for ESCHERICHIA COLI
        function (next) {
			// selecting an organism from the list of organisms
			ok($("#organismName").val("ESCHERICHIA COLI").trigger("keydown"), "When I type 'ESCHERICHIA COLI' in the box");
			equal($("#organismName").val(), "ESCHERICHIA COLI", "What I typed is in the box");
			// populate hidden field
			ok($("#organismId").val("1400002234"), "When I populate the hidden field");
			// check contents of hidden field
			equal($("#organismId").val(), "1400002234", "Organism id is populated");
			setTimeout(function() {
				next();
			}, 100);
		},
		// MDPD-628 clicking ESCHERICHIA COLI from the organisms list
		function (next) {
			$('.ui-autocomplete').eq(1).find('a').eq(0).trigger("click");
			setTimeout(function() {
				next();
			}, 100);
		},
		// MDPD-628 checking contents of the antibiotic table and verifying sort
		function (next) {
			ok($( "th.antibiotic" ).is(":visible"), "antibiotic column is visible");
			ok($( "th.percent" ).is(":visible"), "Susceptibility column is visible");
			ok($( "table.antibiotic-results tbody tr" ).length > 0, "table has data");
			ok($( "th.antibiotic" ).simulate("click"), "When I click the column header Antibiotic");
			var firstAntibiotic = $('table.antibiotic-results tbody tr td:nth-child(1)').first().text();
			var lastAntibiotic = $('table.antibiotic-results tbody tr td:nth-child(1)').last().text();
			ok(firstAntibiotic < lastAntibiotic, "anitbiotic column is sorted");
			ok($( "th.percent" ).simulate("click"), "When I click the column header susceptibility");
			ok($( "th.percent" ).simulate("click"), "When I click the column header susceptibility");
			var firstPercent = $('table.antibiotic-results tbody tr td:nth-child(2)').first().text();
			var lastPercent = $('table.antibiotic-results tbody tr td:nth-child(2)').last().text();
			ok(firstPercent >= lastPercent, "susceptibility column is sorted");
			setTimeout(function() {
				next();
			}, 100);
		}], start);
	});
});