define([
	'jQuery',
	'helpers',
	'common'
], function($$, helpers) {

    module("Eula Tests");

	//***** FUNCTIONS ******//
    function clickDecline() {
		$('#decline-btn').trigger('tap');
	}
	function clickAccept() {
		$('#accept-btn').trigger('tap');
	}
	function triggerEULA() {
		var key = '/AntibiogramWeb/eula',
		testFrame = window.frames[0],
		acceptedDate = testFrame.localStorage[key];

		if (typeof acceptedDate !== 'undefined') {
			testFrame.localStorage.removeItem(key);
			window.frames[0].location = testFrame.location.pathname + '#eula';
		}
	}
	function clickLogInOrOut(next) {
		// click the Login/Logout button
		ok($("#footer-logout-btn").simulate("click"), "When I click the Login/Logout button");

		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
    function openAboutPage(next) {
		// click the About button
		ok($( "#footer-about-btn" ).simulate("click"), "When I click the About button");

		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}

	//***** TESTS *****//
	// Acceptance Criteria MDPD-641
	test('ANTIBIOTIC-142 | EULA Opens', function() {
		stop();
		async.series([function(next){
			triggerEULA();
			setTimeout(next, 500);
		}, function(next) {
			$('#eula').animationComplete(function() {
				next();
			});
		}, function(next) {
			ok($('.ui-dialog .ui-header h2.ui-title'), 'End User License Agreement');
			next();
		}], start);
	});

	test('ANTIBIOTIC-142 | Declining EULA sends me to Launchpad', function(){
		QUnit.stop(2);
		expect(2);
		async.series([
			function(next){
				triggerEULA();
				setTimeout(next, 500);
			}, function(next) {
				$('#eula').animationComplete(function() {
					next();
				});
			},
			function(next){
				ok($('#decline-btn').is(':visible'), 'Decline button is visible');

				var myFrame = $$('#myFrame');
				myFrame.one('load', function() {
					$ = jQuery = myFrame[0].contentWindow.jQuery;
					next();
				});
				clickDecline();
			},
			function(next){
				equal($("#header h1").text(), "Launchpad", "Then I can see the Launchpad");
				setTimeout(next, 500);
			}
		], function () {
			start();
		});
	});

	test('ANTIBIOTIC-142 | Accepting EULA adds storage', function() {
		stop();
		expect(2);
		async.series([
			function(next){
				triggerEULA();
				setTimeout(next, 500);
			}, function(next) {
				$('#eula').animationComplete(function() {
					next();
				});
			},
			function(next){
				ok($('#accept-btn').is(':visible'), 'Accept button is visible');
				clickAccept();
				setTimeout(next, 500);
			}, function(next) {
				ok(window.frames[0].localStorage['/AntibiogramWeb/eula'], 'Eula was saved to local-storage');
				setTimeout(next, 500);
			}], start);
	});

	test('ANTIBIOTIC-142 | Accepting EULA closes dialog', function() {
		stop();
		expect(2);
		async.series([
			function(next){
				triggerEULA();
				setTimeout(next, 500);
			}, function(next) {
				$('#eula').animationComplete(function() {
					next();
				});
			},
			function(next){
				ok($('#accept-btn').is(':visible'), 'Accept button is visible');
				clickAccept();
				setTimeout(next, 500);
			}, function(next) {
				equal($("#header h1").text(), 'Antibiogram', "Then I can see the title of the app - Antibiogram");
				setTimeout(next, 500);
			}], start);
	});

});