define([
	'jQuery',
	'helpers'
], function($$, helpers) {

    module("Complete View Tests");

    //***** FUNCTIONS ******//
    function openCompletePage(next) {
        // click the Complete button
        ok($( "#footer-search-all-btn" ).simulate("click"), "When I click the Complete button");

        // best way is to listen to page load event
        setTimeout(function() {
            next();
        }, 1000);
    }
    function validateFooter(next) {
		var $footer = $("div[data-role='footer']");
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		// make sure complete link is present
		ok($footer.find("#footer-launchpad-btn").is(":visible"), "Launchpad link is visible");
        ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
        ok($footer.find("#footer-search-all-btn").is(":visible"), "Complete link is visible");
        ok($footer.find("#footer-about-btn").is(":visible"), "About link is visible");
        next();
	}
    function findFacility(facName, facCode) {
    	// make sure the "Find Facility" box is visible
        ok($("#facilityName").is(":visible"), "Find Facility box is visible");
        // enter facility
        ok($("#facilityName").val(facName).trigger("keydown"), "When I type 'DC' in the box");
        setTimeout(function() {
    		$('.ui-menu-item').find('a').eq(0).trigger("click");
    	}, 100);
        // check contents of box
        equal($("#facilityName").val(), facName, "What I typed is in the box");
        // populate hidden field
        ok($("#facilityCode").val(facCode), "When I populate the hidden field");
        // check contents of hidden field
        equal($("#facilityCode").val(), facCode, "Facility code is populated");
    }

    //***** TESTS ******//
	test("MDPD-641, ANTIBIOTIC-118, ANTIBIOTIC-136, MDPD-1420, MDPD-1422, MDPD-1417 | "+
        /*"When user is logged in, facility is already selected,  "+*/
        "When facility is entered user can type and see complete data grid, "+
        "When facility is entered user can type and see PDF button, "+
        "Facility (Complete) page can be reached and contains correct elements", function() {
		stop();
		expect(18);
		async.series([
            openCompletePage,
			validateFooter,
            function (next) {
                // make sure the "Find Facility" box is visible (MDPD-1420)
                ok($("#facilityName").is(":visible"), "Find Facility box is visible");
                // make sure the Data Range selector is visible (MDPD-1422)
                ok($("#select-date-range").is(":visible"), "Data Range selector is visible");
                // make sure the "Search Organisms" box is *NOT* visible
                equal($("#organismName").is(":visible"), false, "Search Organisms box is *not* visible");
                next();
            },
            function (next) {
                // Choose a 'new' facility
                findFacility("DC VAMC","688");
				// wait for complete view to load
				setTimeout(function() {
					next();
				}, 500);
			},
			// ANTIBIOTIC-118 checking contents of the complete table and verifying sort
			function (next) {
				//check for cloned column
				ok($("table.complete-results.DTFC_Cloned").is(":visible"), "static left column is visible");
				//has top heading row within scrolling area
				ok($('.dataTables_scroll table.complete-results thead th').length > 0, "column headings are populated");
				//has left heading column
				ok($('table.complete-results.DTFC_Cloned tbody tr').length > 0, "static left column headings are populated");
                setTimeout(function() {
                    next();
                }, 100);
			},
			// ANTIBIOTIC-136 verifying that the PDF button is visible
			function (next) {
				ok($('.pdf-button' ).is(":visible"), "PDF Button is visible");
				setTimeout(function() {
					next();
				}, 100);
			}
		], start);
	});
});