define([
	'jQuery',
	'helpers'
], function($$, helpers) {

    module("Application Tests");

	//***** FUNCTIONS ******//
	function clickDecline() {
		$('#decline-btn').trigger('click');
	}
	function clickAccept() {
		$('#accept-btn').trigger('click');
	}
	function triggerEULA() {
		var key = '/AntibiogramWeb/antibiogram/eula',
		testFrame = window.frames[0],
		acceptedDate = testFrame.localStorage[key];

		if (typeof acceptedDate !== 'undefined') {
			testFrame.localStorage.removeItem(key);
			window.frames[0].location = testFrame.location.pathname + '#eula';
		}
	}
	function clickLogInOrOut(next) {
		// click the Login/Logout button
		ok($("#footer-logout-btn").simulate("click"), "When I click the Login/Logout button");

		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
    function openAboutPage(next) {
		// click the About button
		ok($( "#footer-about-btn" ).simulate("click"), "When I click the About button");

		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
	function validateFooter(next) {
        var $footer = $("div[data-role='footer']");
        // make sure the footer is visible
        ok($footer.is(":visible"), "Footer is visible");
        // make sure complete link is present
        ok($footer.find("#footer-launchpad-btn").is(":visible"), "Launchpad link is visible");
        ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
        ok($footer.find("#footer-search-all-btn").is(":visible"), "Complete link is visible");
        ok($footer.find("#footer-about-btn").is(":visible"), "About link is visible");
        next();
    }

	//***** TESTS *****//
	// Acceptance Criteria MDPD-412, MDPD-415, MDPD-1417, MDPD-1418
	test("MDPD-412, MDPD-415, MDPD-1417, MDPD-1418 | Landing page can be reached and contains correct elements", function() {
		stop();
		expect(8);
		async.series([function (next) {
				// Antibiogram header is visible (MDPD-415)
				ok($("h1:contains('Antibiogram')").is(":visible"), "Antibiogram header is visible");
				// Instructions content is visible (MDPD-1418)
				ok($( 'li:contains("Select Search or All")' ).is(":visible"), "Instructions content is visible");
				// URL contains "antibiogram" (MDPD-412)
				ok(window.location.pathname.indexOf("AntibiogramWeb") > -1, "URL contains application name");
				next();
			},
			validateFooter,
			function(next) {
				next();
			}], start);
	});
	// THERE IS NO AC FOR THIS - AMANDA
	test("About page can be reached and contains correct elements", function() {
		stop();
		expect(7);
		async.series([
			validateFooter,
            openAboutPage,
			function (next) {
				// make sure the "About" dialog is visible
				ok($("div[data-role='dialog']").find("h2:contains('About')").is(":visible"), "About dialog is visible");
				next();
			}, function(next) {
				next();
			}], start);

	});

});