define([
	'Global',
	'Resources',
	'UserSession',
	'FooterButtons',
	'Text!../html/templates/common/footer.html',
	'Text!../html/templates/common/userBar.html',
	'Text!../html/templates/common/footerMenuPopup.html'
	],
	function(Global, resources, UserSession, footerButtons, footerTemplate, userBarTemplate, footerMenuPopup) {
		var FooterView = Backbone.View.extend({
			tagName: 'div',
			attributes: {"data-role":"navbar"},
			initialize: function(patient) {
				this.patient = patient;
				this.mhpuser = new UserSession().get('mhpuser');
				this.template = _.template(footerTemplate);
				this.userTemplate = _.template(userBarTemplate);
				this.menuTemplate = _.template(footerMenuPopup);
			},
			render: function(breakpoint) {
				var template = this.template,
					userBar = this.userTemplate,
					mhpuser = this.mhpuser,
					footerSize = footerButtons.length,
					defaultFooterSize = breakpoint ? breakpoint : 5, //jquery Mobile sets breakpoint at 5
					menuTemplate = this.menuTemplate,
					menuSize = 0,
					menuButtons = [],
					moreBtn = {id: "footer-more-btn", url: "#", icon: "grid", active: "false", title: "More"},
					$container = $(this.el);

				$container.empty().append('<ul>');

				if (footerSize > defaultFooterSize) {
					menuSize = footerSize - (defaultFooterSize - 1);
				}

				for (var i=0; i<footerSize; i++) {
					if (i < footerSize - menuSize) {
						var active = footerButtons.models[i].get('active') ? "ui-btn-active" : "";

						$('ul', $container)
							.append(template($.extend({}, mhpuser, footerButtons.models[i].toJSON(), {active: active})));
					} else {
						menuButtons.push(footerButtons.models[i].toJSON());
					}
				}

				/* Removing userBar - ANTIBIOTIC-409 $container.append(userBar($.extend({}, {user: mhpuser}, this.patient)));*/
				
				var $result = $container;
				
				if (menuSize > 0) {
					$('>ul', $container).append(template(moreBtn));
					$result = $container.add(menuTemplate({models: menuButtons}));
				}
				
				return $result;
			},
			events: {
				"tap a": "routeSelection",
				"keydown a": "handleKeyDown"
			},

			routeSelection: function(e) {
				e.preventDefault();
				var $this = $(e.currentTarget),
					scope = this,
					//If specific to footer links, should probably pick one convention
					//Filter is requirement of isotope
					target = $this.data('filter') ?
						$this.data('filter') :
						$this.attr('id'),
					referencePath = Global.getUtilities().getReferencePath();

				if (target !== undefined) {
					switch (target) {
						case "footer-logout-btn":
							if (typeof this.mhpuser !== "undefined") {
								var logoutUrl = userResources.get('logout').get('href');
								$.ajax({
								    url: userResources.get('token').get('href'),
								    type: 'DELETE',
								    success: function(data){
										sessionStorage.clear();
										window.location = logoutUrl;
								    }	
								});
							} else {
								window.location = referencePath + "../oauthlogin";
							}
							break;
						case "footer-launchpad-btn":
							window.location = referencePath + $this.attr('href');
							break;
						case ".app": case ".link": case "*":
							$('#container').isotope({ filter: target });
							$("#footer").jqmData('previousFooterSelectedTab', $('#footer .ui-btn-active').attr('id'));
							break;
						case "footer-more-btn":
							var $moreMenu = $('#footer-menu-popup');
							$moreMenu.off('.more-menu');
							$moreMenu.popup('open', {positionTo: $this});
							$moreMenu.on('tap.more-menu', 'a', function(e){
								e.stopPropagation();
								$moreMenu.popup('close');
								scope.routeSelection(e);
							});
							$moreMenu.on('keydown.more-menu', 'a', function(e){
								scope.handleKeyDown(e);
							});
							$this.removeClass('ui-btn-active');
							break;
						default:
							target = target.replace('-btn', '').replace('footer-', '');
							Global.getUtilities().eventAggregator.trigger(target);
					}
				}
			},
			handleKeyDown: function (e) {
				if (e.which === 13) {
					e.preventDefault();

					$(e.currentTarget).trigger('tap');
				}
			}
		});

		return FooterView;
	}
);