define([
    'Global',
    'Text!../html/templates/about.html'
],
    function (Global, aboutTemplate) {
        'use strict';
        return Backbone.View.extend({
            id: 'about',
            attributes: {'data-role': 'dialog'},
            initialize: function () {
                this.compiledTemplate = _.template(aboutTemplate);
            },
            render: function () {
                var $container = $(this.el);
                $('body').append($container.empty().append(this.compiledTemplate()));
            },
            clear: function () {

            },
            events: {
                "tap a[title='Close']": "home"
            },
            home: function (e) {
                e.preventDefault();
                history.back();
            }
        });
    }
);