/* Author: Agilex

 */
var formatDate = function (date) {
    'use strict';
    date = new Date(date);
    if (typeof date !== 'undefined' && !isNaN(date)) {
        var month = date.getMonth() + 1,
            day = date.getDate(),
            year = date.getFullYear();

        day = day < 10 ? '0' + day : day;
        month = month < 10 ? '0' + month : month;

        return (month + "/" + day + "/" + year);
    }

    return '';
};

var produceDate = function (duration, date) {
    'use strict';
    var nonNullDate = date ? new Date(date) : new Date();
    return subtractFromDate(0, 0, duration, 0, 0, 0, 0, nonNullDate);
};

var subtractFromDate = function (month, day, year, hours, minutes, seconds, milliseconds, date) {
    'use strict';
    return formatDate(subtractFromDateUnformatted(month, day, year, hours, minutes, seconds, milliseconds, date));
};

var produceDateFromMonths = function (durationInMonths, date) {
    'use strict';
    var nonNullDate = date ? new Date(date) : new Date();
    return subtractFromDate(durationInMonths, 0, 0, 0, 0, 0, 0, nonNullDate);
};

var produceDateFromDays = function (durationInDays, date) {
    'use strict';
    var nonNullDate = date ? new Date(date) : new Date();
    return subtractFromDate(0, durationInDays, 0, 0, 0, 0, 0, nonNullDate);
};

var subtractFromDateUnformatted = function (month, day, year, hours, minutes, seconds, milliseconds, date) {
    'use strict';
    month = date.getMonth() - parseInt(month,10);
    day = date.getDate() - parseInt(day,10);
    year = date.getFullYear() - parseInt(year,10);
    hours = date.getHours() - parseInt(hours,10);
    minutes = date.getMinutes() - parseInt(minutes,10);
    seconds = date.getSeconds() - parseInt(seconds,10);
    milliseconds = date.getMilliseconds() - parseInt(milliseconds,10);

    return new Date(year, month, day, hours, minutes, seconds, milliseconds);
};

var addCustomDates = function (dateFrom, dateTo, callbackFn) {
    'use strict';
    $('#add-custom').before('<li data-startDate="'+ dateFrom +'" data-endDate="'+ dateTo +'">'+ dateFrom + ' - ' + dateTo + '<div class="listing-bg"></div></li>');

    if ($.isFunction(callbackFn)) {
        callbackFn.call();
    }
};

var indexOf = function (array, searchElement) {
    'use strict';
    var size = array.length,
        i = 0;
    for (i; i < size; i++) {
        if (array[i] === searchElement) {
            return i;
        }
    }
    return -1;
};

var formatTime = function (date) {
    'use strict';
    var d = new Date(date),
        hh = d.getHours(),
        m = d.getMinutes(),
        s = d.getSeconds(),
        dd = "AM",
        h = hh;

    if (h >= 12) {
        h = hh - 12;
        dd = "PM";
    }

    h = h === 0 ? 12 : h;

    m = m < 10 ? "0" + m : m;

    s = s < 10 ? "0" + s : s;

    /* if you want 2 digit hours:
     h = h<10?"0"+h:h; */

    return h + ":" + m + " " + dd;
};

var formatDateToDays = function (date, shortenWeekday) {
    'use strict';
    var d = new Date(date),
        weekday = shortenWeekday ? ["Sun", "Mon", "Tue", "Wed", "Thur", "Fri", "Sat"] : ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
        month = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

    return "<span><strong>" + weekday[d.getDay()] + "</strong></span>" + " <span>" + month[d.getMonth()] + ' ' + d.getDate() + ', ' + d.getFullYear() + '</span>';

};

var writeLocationsToStorage = function (key, value) {
    'use strict';
    if (value) {
        try {
            if (typeof(window.localStorage) !== 'undefined') {
                var currentArray = readLocationsFromStorage(key),
                    currentArrayLength = currentArray.length,
                    i = 0;

                if (currentArrayLength > 0) {
                    for (i; i < currentArrayLength; i++) {
                        if (!currentArray[i] || currentArray[i].name === value.name) {
                            currentArray.splice(i, 1);
                        }
                    }
                    if (currentArray.length >= 3) {
                        currentArray.pop();
                    }
                }
                currentArray.unshift(value);
                window.localStorage[key] = JSON.stringify(currentArray);
            }
        } catch (e) {
            /*if (e == QUOTA_EXCEEDED_ERR) {
             alert('Quota exceeded!');
             }*/
        }
    }
};

var readLocationsFromStorage = function (key) {
    'use strict';
    var value = null;
    if (typeof(window.localStorage) !== 'undefined') {
        value = JSON.parse(window.localStorage[key] || null);
    }

    if (value) {
        var currentArrayLength = value.length;
        for (var i = 0; i < currentArrayLength; i ++) {
            if (!value[i]) {
                value.splice(i, 1);
            }
        }
    }

    return value ? value : [];
};

var getUriByTitle = function (atomLinks, title) {
    'use strict';
    var uri = null;
    $.each(atomLinks, function (index, atomLink) {
        if (atomLink.rel === 'related' && atomLink.title === title){
            uri = atomLink.href;
            return;
        }
    });

    return uri;
};

var flattenLinks = function (object) {
    'use strict';
    var links = object.get('link'),
        size = links.length,
        i = 0;
    for (i; i<size; i++) {
        object.set(links[i].title,links[i]);
    }
    object.unset('link');
};

// First letter of first entire string
var capitaliseFirstLetter = function (string) {
    'use strict';
    string = string.toLowerCase();
    return string.charAt(0).toUpperCase() + string.slice(1);
};

// First letter of each word in string
var titleCase = function (str) {
    'use strict';
    return str.replace(/\w\S*/g, function (txt) {
        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
    });
};


var isWithinDateRange = function(startDate, endDate, checkDate) {
	if (typeof startDate === 'undefined' || typeof endDate === 'undefined') {
		return true;
	} else {
		var sDate = new Date(startDate);
		var eDate = new Date(endDate);
		var cDate = new Date(checkDate);
		return cDate >= sDate && cDate <= eDate;
	}
};

var getAlertLevel = function(daysOnList) {
	if (daysOnList >= 38) {
		return 'C';
	} else if (daysOnList >= 37) {
		return 'B';
	} else if (daysOnList >= 35) {
		return 'A';
	} else if (daysOnList >= 8) {
		return 'C';
	} else if (daysOnList >= 7) {
		return 'B';
	} else if (daysOnList >= 5) {
		return 'A';
	} else {
		return '';
	}
	return '';
};


