define([
	'Global',
	'App',
	'mainView',
	'antibiogramView',
	'footerView',
	'antibiogramSearchView',
	'aboutView',
	'eulaView',
	'UserSession'
], function (Global, App, MainView, AntibiogramView, FooterView, AntibiogramSearchView, AboutView, EulaView, UserSession) {

	var AppRouter = Backbone.Router.extend({
			initialize: function () {
				var app = {user: ''};
				this.userSession = new UserSession();
				if (this.userSession.isLoggedIn()) {
					app.user = this.userSession.get('mhpuser');
				}
				Global.getUtilities().globalInit(app);
				this.title = defineResourceTitles().title;
				this.location = window.location.hash;

				var eulaHTML = new EulaView().template.call();
				this.eulaModifiedDate = $('#modified-date', eulaHTML).text();
			},
			routes: {
				'':						'defaultAction',
				'antibiogram':			'showAntibiogram',
				'antibiogram-search':	'showAntibiogramSearch',
				'search-all':			'showAll',
				'about':				'showAboutPage',
				'eula':					'showEula',
				'*actions':				'defaultAction'
			},

			showAntibiogram: function () {
				this.openPage(new AntibiogramView());
			},
			showAll: function () {
				this.openPage(new AntibiogramSearchView());
			},
			showAntibiogramSearch: function () {
				this.openPage(new AntibiogramSearchView());
			},
			showAboutPage: function () {
				this.openPage(new AboutView());
			},
			showEula: function() {
				this.openPage(new EulaView({location: this.location}));
			},
			defaultAction: function () {
				appRouter.navigate('#antibiogram', {trigger: true});
			},

			openPage: function (page) {
				var pageType = $(page.el).eq(0).attr('data-role'),
					location = window.location.hash,
					eulaCheck = Global.getUtilities().checkEULA(window.location.hash, this.eulaModifiedDate);
				if (eulaCheck !== location){
					appRouter.navigate('#eula', {trigger: true});
				} else if (pageType === 'dialog') {
					page.render();
					if($.mobile.pageContainer){
						$.mobile.changePage("#" + page.id, {transition: 'pop'});
					}
				} else {
					this.buildMain.call(this, page);
					this.activateFooter(Backbone.history.fragment);
					$('#main').animationComplete(function () {
						page.render();
					});
					if($.mobile.pageContainer){
						$.mobile.changePage($('#main'), {allowSamePageTransition: true});
					}
				}
			},
			activateFooter: function (page) {
				$('#footer a, #footer-menu-popup li, #footer-menu-popup a').removeClass('ui-btn-active');
				$('#footer a[href="#'+ page +'"]').addClass('ui-btn-active');
				$('#footer-menu-popup a[href="#'+ page +'"]').parents('li').addClass('ui-btn-active');
			},
			buildMain: (_.once(function(page) {
				var mainView = new MainView(),
					fromMainLoad = true;
				$('body').append(mainView.render());
				page.render(fromMainLoad);
			}))
		});

	var appRouter = new AppRouter(),
		eventAggregator = Global.getUtilities().eventAggregator;

	_.map(appRouter.routes, function(method, key) {
		eventAggregator.on(key, function() {
			appRouter.navigate('#'+key, {trigger: true});
		});
	});

	eventAggregator.on("footer", function() {
		$('#footer-menu-popup-popup, #footer-menu-popup-screen').remove();
		var $footer = $('#footer > .ui-navbar');

		var moreCount = 0,
			count = $('>ul', $footer).find('li').length;

		for (var i=0; i<count; i++) {
			var realWidth = $('>ul li:nth-child('+(i+1)+')', $footer).width();
			$('>ul li:nth-child('+(i+1)+')', $footer).css('width','auto');
			tempWidth = $('>ul li:nth-child('+(i+1)+')', $footer).width();
			if (realWidth > tempWidth) {
				moreCount++;
			}
		}

		var $generatedFooter = new FooterView().render(moreCount);

		$('#footer').empty().append($generatedFooter).trigger('create');
		$('#footer-menu-popup').removeAttr('style');
		appRouter.activateFooter(Backbone.history.fragment);
	});

	Backbone.history.start();
});
