define(
	['Resources', 'Global'],
	function(resources, Global) {
		var Antibiogram = Backbone.Model.extend({
			
			initialize: function(facilityCode) {
				this.url = resources.get('antibiogram-facility').get('href');
				this.url += "?facilitySiteCode=" + facilityCode;
				this.fetch({async: false});	
				Global.getUtilities().flattenLinks(this);
			}	
		
		});
	
		Antibiogram.instance = function() {
			return singleInstance = typeof singleInstance === "undefined"
				? new Antibiogram()
				: singleInstance;
		};
		
		return Antibiogram;
	}
);

