require.config({
	paths: {
		// path configuration assumes .js suffix

		// Libraries
		'jQuery': 'libs/jquery-1.8.2.min',
		'jQueryUI': 'libs/jquery-ui-1.9.0.custom.min',
		// custom version of jQM, see comments section in library for custom change log
		'jQM': 'libs/jquery.mobile-1.2.0-CUSTOM',
		'dataTables': 'libs/jquery.dataTables.min',
		'fixedColumns': 'libs/FixedColumns.min',
		'Underscore': 'libs/underscore',
		'Backbone': 'libs/backbone',
		'FormParams': 'libs/jquery.formparams',
		'Global': 'global',
		'DateFormatJS': 'libs/date.format',
		'Confirm': 'libs/jquery.confirm', //????

		// Custom Helpers
		'jQMConfig': 'libs/jqm-config', // Disables JQM Routing
		'Utilities': 'utilities',
		'App': 'app',
		
		// Models
		'ResourceLink': 'models/resourceLink',
		'UserSession': 'models/userSession',
		'FooterButton': 'models/footerButtonModel',
		'Facility': 'models/facility',
		'Organism': 'models/organism',
		'Antibiogram': 'models/antibiogram',
		'AntibiogramSummary': 'models/antibiogramSummary',
		

		// Collections
		'Resources': 'collections/resources',
		'FooterButtons': 'collections/footerButtons',
		'Facilities': 'collections/facilities',
		'Organisms': 'collections/organisms',
		'AntibiogramMatrix': 'collections/antibiogramMatrix',

		// Views
		'mainView': 'views/mainView',
		'headerView': 'views/headerView',
		'footerView': 'views/footerView',
		'antibiogramView': 'views/antibiogramView',
		'antibiogramSearchView': 'views/antibiogramSearchView',
		'AntibiogramSummaryView': 'views/antibiogramSummaryView',
		'aboutView': 'views/aboutView',
		'eulaView': 'views/eulaView',
		
		
		// require js plugins
		'Text': 'text'
    },
    waitSeconds: 30,
	shim: {
		'jQuery': {
			exports: '$'
		},
		'jQueryUI': {
			deps: ['jQuery']
		},	
		'jQMConfig': {
			deps: ['jQuery']
		},
		'jQM': {
			deps: ['jQMConfig']
		},
		'FormParams': {
			deps: ['jQuery']
		},
		'dataTables': {
			deps: ['jQuery']
		},
		'fixedColumns': {
			deps: ['jQuery','dataTables']
		},
		'Underscore': {
			exports: '_'
		},
		'Backbone': {
			deps: ['Underscore', 'FormParams', 'jQM', 'jQueryUI'],
			exports: 'Backbone'
		},
		'Utilities': {
			deps: ['Backbone']
		},
		'Global': {
			deps: ['Backbone', 'Utilities']
		}
	}
});

require(['router']);
