define(
	['Backbone', 'AntibiogramSummary'],
	function(Backbone, AntibiogramSummary) {
		var AntibiogramMatrix = Backbone.Collection.extend({
			model: AntibiogramSummary,
			initialize: function(url) {
				this.antibiotics = [];
			},
			parse: function(response) {
				antibiotics = response.antibiotics;
				var organisms = response.organismAntibiogramMatrices;
				if(typeof organisms !== "undefined"){
					for (var i = 0; i < organisms.length; i++) {
						
						var currentOrganism = organisms[i];
						var summary = {};

						summary.organismName = currentOrganism.organismName;
						summary.isolatesCount = currentOrganism.isolatesCount;
						summary.susceptible = {};

						//give each antibiotic a default susceptibility of empty
						for (var j = 0; j < antibiotics.length; j++) {
							summary.susceptible[antibiotics[j]] = "";
						}

						//now populate the value for valid columns
						for (var j = 0; j < currentOrganism.antibiogramSummaries.length; j++) {
							summary.susceptible[currentOrganism.antibiogramSummaries[j].antibioticName] = Math.floor(currentOrganism.antibiogramSummaries[j].ratio);
						}

						this.push(summary);
					}
				
					//add spaces around slashes for readability
					$.each(antibiotics, function(i, val){
						if (val.indexOf("/")>0){
							antibiotics[i] = val.replace(/(\/)/g," $1 ");
						}
					});
				}
				this.antibiotics = antibiotics;
							
				//return models
				return this.models;
				
			}
		});
		return AntibiogramMatrix;
	}
);
