/*
  Copyright 2010 Google Inc.

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/

/** @fileoverview Example of how to use the bookmark bubble. */

addEventListener('load', function() {
  setTimeout(function() {
    var bubble = new google.bookmarkbubble.Bubble();


    bubble.hasHashParameter = function() {
      return $.cookie('bubble');
    };

    bubble.setHashParameter = function() {
      if (!this.hasHashParameter()) {
        $.cookie('bubble', true, { expires: 365 });
      }
    };

    bubble.getViewportHeight = function() {
      //console.log('Example of how to override getViewportHeight.');
      return innerHeight;
    };

    bubble.getViewportScrollY = function() {
      //console.log('Example of how to override getViewportScrollY.');
      return pageYOffset;
    };

    bubble.registerScrollHandler = function(handler) {
      //console.log('Example of how to override registerScrollHandler.');
      addEventListener('scroll', handler, false);
    };

    bubble.deregisterScrollHandler = function(handler) {
      //console.log('Example of how to override deregisterScrollHandler.');
      removeEventListener('scroll', handler, false);
    };

    bubble.showIfAllowed();
  }, 1000);
}, false);
