
module.exports = function( grunt ) {

	// grunt.loadTasks('test/grunt-tasks');
	var testUrl = "http://localhost:8080/AntibiogramWeb/test/",
		dest = process.env.CATALINA_HOME + "/webapps/AntibiogramWeb/",
		_ = require('underscore'),
		cheerio = require( "cheerio" ),
		config = {
			qunit_junit: {
				options: {
					dest:"./test"
				}
			},
			jshint: {
				options:{
					'laxcomma': true
				},
				webapp: [
					"antibiogram/js/**.js",
					"!antibiogram/{**/,**/**/,}jquery**.js",
					"!antibiogram/{**/,**/**/,}bookmark_bubble**.js",
					"!antibiogram/{**/,**/**/,}browserSniffer**.js",
					"!antibiogram/{**/,**/**/,}text**.js"
				],
				test: [
					"test/*.js",
					"!test/{**/,**/**/,}qunit.js",
					"!test/runner.js",
					"!test/testUtilities.js",
					"!test/async.js",
					"!test/asyncSeries.js"
				]
			},
			optimize: {
				"antibiogram": "config"
			},
			deoptimize: {
				"antibiogram": "config"
			},
			copy: {
			},
			requirejs: { // base task that optimize (multitask) will use
				compile: {
					options: {
						baseUrl: "",
						mainConfigFile: "",
						name: "",
						out: ""
					}
				}
			},
			qunit: {
				options: {
					timeout: 60000
				}
			}, // end qunit
			shell: {
				command: 'node_modules/phantomjs/bin/phantomjs test/runner.js ' + testUrl + ' 1200',
					options: {
						stdout: true
					}
			}
		}; // end var config


	config.qunit.Antibiogram = {
		options:{
			urls:[ testUrl ],
			timeout: 60000
		}
	};
	config.copy.antibiogram = {
		src:  ["antibiogram/{**/**/**/,**/**/,**/,}**"],
		dest: dest
	};
	config.copy.test = {
		src:  ["test/{**/**/**/,**/**/,**/,}**"],
		dest: dest
	};

	grunt.loadNpmTasks('grunt-contrib-requirejs');
	grunt.loadNpmTasks('grunt-contrib-qunit');

	grunt.loadNpmTasks('grunt-contrib-jshint');

	grunt.loadNpmTasks('grunt-include-replace');

	grunt.loadNpmTasks('grunt-contrib-concat');
	grunt.loadNpmTasks('grunt-contrib-uglify');
	grunt.loadNpmTasks('grunt-contrib-watch');
	grunt.loadNpmTasks('grunt-contrib-nodeunit');
	grunt.loadNpmTasks('grunt-contrib-connect');

	grunt.loadNpmTasks('grunt-contrib-copy');
	grunt.loadNpmTasks('grunt-contrib-watch');
	grunt.loadNpmTasks('grunt-qunit-junit');
	grunt.loadNpmTasks('grunt-shell');
	grunt.initConfig( config );

	grunt.registerTask( "lint", ["jshint"] );
	grunt.registerTask( "test", ["qunit"] );
	grunt.registerTask( "deploy", ["copy"] );
	grunt.registerTask( "default", ["jshint", "copy", "qunit"] );
};

