/*
 * Decompiled with CFR 0.152.
 */
package org.missinglink.http.client;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.missinglink.http.client.HttpClient;

public class HttpResponse {
    protected HttpClient httpClient;
    protected int status;
    protected String message;
    protected byte[] entity;
    protected String contentEncoding;
    protected String contentType;
    protected int contentLength;
    protected Date date;
    protected Date expires;
    protected Date lastModified;
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public HttpResponse(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public List<String> getHeader(String header) {
        if (this.headers.containsKey(header)) {
            return this.headers.get(header);
        }
        return null;
    }

    public String getHeaderSingleValue(String header) {
        if (this.headers.containsKey(header) && null != this.headers.get(header) && this.headers.get(header).size() > 0) {
            return this.headers.get(header).get(0);
        }
        return null;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public byte[] getEntity() {
        return this.entity;
    }

    public String getEntityAsString() throws IOException {
        if (null != this.entity && this.entity.length > 0) {
            return new String(this.entity);
        }
        return null;
    }

    public void setEntity(byte[] responseEntity) {
        this.entity = responseEntity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

