rhBlowfish ;
 ; Cache Object Script implementation of the Blowfish symmetric block cipher;;;;;Build 1
 ; Copyright (C) 2001 COD International BV
 ; Naarden, The Netherlands <www.codgroep.nl>. All rights reserved.
 ; You are free to use this code in your applications without liability
 ; or compensation, but the courtesy of both notification of use and	
 ; inclusion of due credit are requested. You must keep this copyright
 ; notice intact.
 ; It is PROHIBITED to distribute or reproduce this code for profit
 ; or otherwise, on any web site, ftp server or BBS, or by any
 ; other means, including CD-ROM or other physical media, without the
 ; EXPRESS WRITTEN PERMISSION of the copyright holder.
 ; Use at your own risk.
 ; COD International BV offers no warranty of its fitness for any
 ; purpose whatsoever, and accept no liability whatsoever for any
 ; loss or damage incurred by its use.
 ; If you use it, or found it useful, or can suggest an improvement
 ; please let us know at <development@codgroep.nl>.
 ; Author: Herman Slagman
 ; Blowfish is a symmetric block cipher that can be used as a drop-in
 ; replacement for DES or IDEA.
 ; It takes a variable-length key, from 32 bits to 448 bits, making it
 ; ideal for both domestic and exportable use.
 ; Blowfish was designed in 1993 by Bruce Schneier as a fast, free
 ; alternative to existing encryption algorithms.
 ; Since then it has been analyzed considerably, and it is slowly gaining
 ; acceptance as a strong encryption algorithm.
 ; Blowfish is unpatented and license-free, and is available free for all uses. 
 ; <www.counterpane.com/blowfish.html>
 ; Restrictions.
 ; This code relies heavily on macro preprocessor commands, it should
 ; therefor be compiled as a Cache Object Script MAC routine.
 ; It also uses the Cache 4.x and higher COS language enhancements, such
 ; as multiline commands, and needs to be adjusted for use on earlier
 ; Note.
 ; Based on the Visual Basic implementation of David Ireland, DI Management Services Pty Ltd, Sydney Australia
 ; <www.di-mgt.com.au>
EncryptString(sText,sKey)
 New i,nLen,nPad,sPad,nBlocks,sPlain,S,P,awData,sCipher,Bytes,j
 Do InitialiseKey(sKey)
 Set nLen = $Length(sText)
 Set nPad = ((nLen \ 8) + 1) * 8 - nLen
 Set sPad = $Translate($Justify("",nPad)," ",$Char(nPad))  ; Pad with # of pads (1-8)
 Set sPlain = sText_sPad
 Set nLen = $Length(sPlain)
 Set nBlocks = nLen \ 8
 ; Split string into blocks of 2 x 32-bit words
 For i = 0:8:(nBlocks - 1*8) {
     Set awData(i\8*2)=$Ascii(sPlain,i+1)*(16777216)+($Ascii(sPlain,i+2)*(65536))+($Ascii(sPlain,i+3)*256)+$Ascii(sPlain,i+4)
     Set awData(i\8*2+1)=$Ascii(sPlain,i+5)*(16777216)+($Ascii(sPlain,i+6)*(65536))+($Ascii(sPlain,i+7)*256)+$Ascii(sPlain,i+8)
 }
 Do Enc(nBlocks * 2)
 ; Put back into a string
 Set sCipher = ""
 For i = 0:1:nBlocks-1 {
     Do WordSplit(awData(i * 2),.Bytes)
     For j=0:1:3 Set sCipher = sCipher_$Char(Bytes(j))
     Do WordSplit(awData(i * 2+1),.Bytes)
     For j=0:1:3 Set sCipher = sCipher_$Char(Bytes(j))
 }
 Quit sCipher
Enc(nWords)
 New i,xL,xR
 For i = 0:2:nWords-1 {
     Set xL = awData(i), xR = awData(i+1)
     Do EncipherBlock(.xL,.xR)
     Set awData(i) = xL, awData(i+1) = xR
 }
 Quit
EncryptFile(FileIn,FileOut,sKey)
 New i,nLen,nPad,sPad,nBlocks,sPlain,S,P,awData,sCipher,Bytes,j
 Open FileIn:"rs":0 If '$Test Quit
 Open FileOut:"wns":0 If '$Test Close FileIn Quit
 Do InitialiseKey(sKey)
 Set $Ztrap="EncEOF"
 For  {
    Kill Bytes
    For i=0:1:7 Use FileIn Read *Bytes(i)
    Do EncryptBytes(.Bytes)
    For i=0:1:7 Use FileOut Write $Char(Bytes(i))
 }
EncEOF
 If $ZE'["ENDOFFILE" Close FileIn,FileOut Write $ZE Quit
 Set nPad=8-$Order(Bytes(""),-1)
 For i=1:1:nPad Set Bytes(8-i)=nPad
 Do EncryptBytes(.Bytes)
 For i=0:1:7 Use FileOut Write $Char(Bytes(i))
 Close FileIn
 Close FileOut   
 Quit
EncryptBytes(Bytes)
 ; Encrypt an array of 8 bytes
 New wordL,wordR
 ; Convert to 2 x words
 Set wordL = Bytes(0)*(16777216)+(Bytes(1)*(65536))+(Bytes(2)*256)+Bytes(3)
 Set wordR = Bytes(4)*(16777216)+(Bytes(5)*(65536))+(Bytes(6)*256)+Bytes(7)
 ; Encrypt it
 Do EncipherBlock(.wordL, .wordR)
 ; Put back into bytes
 Set Bytes(0)=wordL#(4294967296)\(16777216)   
 Set Bytes(1)=wordL#(16777216)\(65536)
 Set Bytes(2)=wordL#(65536)\256   
 Set Bytes(3)=wordL#256
 Set Bytes(4)=wordR#(4294967296)\(16777216)   
 Set Bytes(5)=wordR#(16777216)\(65536)
 Set Bytes(6)=wordR#(65536)\256   
 Set Bytes(7)=wordR#256
 Quit
EncipherBlock(xL,xR)
 New i,temp
 For i = 0:1:15 {
    Set xL = $$XOR(xL,P(i))
    Set xR = $$XOR($$F(xL),xR)
    Set temp = xL
    Set xL = xR
    Set xR = temp
 }
 Set temp = xL
 Set xL = xR
 Set xR = temp
 Set xR = $$XOR(xR,P(16))
 Set xL = $$XOR(xL,P(17))
 Quit
DecryptString(sCipher,sKey)
 New awData,D1,D2,i,j,sPlain,S,P,nPad
 New nLen,nBlocks,D,Bytes
 Do InitialiseKey(sKey)
 Set nLen = $Length(sCipher)
 Set nBlocks = nLen \ 8
 ; Split string into blocks of 2 x 32-bit words
 For i = 0:8:(nBlocks - 1*8) {
     Set awData(i\8*2) = $Ascii(sCipher,i+1)*(16777216)+($Ascii(sCipher,i+2)*(65536))+($Ascii(sCipher,i+3)*256)+$Ascii(sCipher,i+4)
     Set awData(i\8*2+1) = $Ascii(sCipher,i+5)*(16777216)+($Ascii(sCipher,i+6)*(65536))+($Ascii(sCipher,i+7)*256)+$Ascii(sCipher,i+8)
 }
 ; Decrypt it
 Do Dec(nBlocks * 2)
 ; Put back into a string
 Set sPlain = ""
 For i = 0:1:nBlocks-1 {
     Do WordSplit(awData(i * 2),.Bytes)
     For j=0:1:3 Set sPlain = sPlain_$Char(Bytes(j))
     Do WordSplit(awData(i * 2+1),.Bytes)
     For j=0:1:3 Set sPlain = sPlain_$Char(Bytes(j))
 }
 ; Strip padding
 Set nPad = $Ascii(sPlain,$Length(sPlain))
 Set sPlain = $Extract(sPlain,0, nLen - nPad)
 Quit sPlain
Dec(nWords)
 New i,xL,xR
 For i = 0:2:nWords-1 {
    Set xL = awData(i),xR = awData(i+1)
    Do DecipherBlock(.xL,.xR)
    Set awData(i) = xL, awData(i+1) = xR
 }
 Quit
DecryptFile(FileIn,FileOut,Key)
 New i,nLen,nPad,sPad,nBlocks,sPlain,S,P,awData,sCipher,Bytes,j,InitByte
 Set $ZTrap=""
 Open FileIn:"rs":0 If '$Test Use 0 Write "Cannot open "_FileIn_" for input",! Quit
 Open FileOut:"wns":0 If '$Test Use 0 Write "Cannot open "_FileOut_" for output",! Close FileIn Quit
 Do InitialiseKey(Key)
 Set $ZTrap="DecEOF"
 ; we need InitByte to detect EOF before writing the last 8 Bytes
 Use FileIn Read *InitByte
 For  {
    Kill Bytes
    Set Bytes(0)=InitByte
    For i=1:1:7 Use FileIn Read *Bytes(i)
    Do DecryptBytes(.Bytes)
    ; we need to know if we are at EOF in order to remove padding
    Use FileIn Read *InitByte
    For i=0:1:7 Use FileOut Write $Char(Bytes(i))
 }
DecEOF ;
 If $ZE'["ENDOFFILE" Close FileIn,FileOut Use 0 Write "Error = "_$ZE,! Quit
 Set $ZTrap=""
 ; Don't write pad bytes
 For i=0:1:7-Bytes(7) Use FileOut Write $Char(Bytes(i))
 Close FileIn
 Close FileOut   
 Quit
DecryptBytes(Bytes)
 ; Decrypt an array of 8 bytes
 New wordL,wordR
 ; Convert to 2 x words
 Set wordL = Bytes(0)*(16777216)+(Bytes(1)*(65536))+(Bytes(2)*256)+(Bytes(3))
 Set wordR = Bytes(4)*(16777216)+(Bytes(5)*(65536))+(Bytes(6)*256)+(Bytes(7))
 ; Decrypt it
 Do DecipherBlock(.wordL, .wordR)
 ; Put back into bytes
 Set Bytes(0)=wordL#(4294967296)\(16777216)   
 Set Bytes(1)=wordL#(16777216)\(65536)
 Set Bytes(2)=wordL#(65536)\256   
 Set Bytes(3)=wordL#256
 Set Bytes(4)=wordR#(4294967296)\(16777216)   
 Set Bytes(5)=wordR#(16777216)\(65536)
 Set Bytes(6)=wordR#(65536)\256   
 Set Bytes(7)=wordR#256
 Quit
DecipherBlock(xL,xR)
 New i,temp
 For i = 17:-1:2 {
    Set xL = $$XOR(xL,P(i))
    Set xR = $$XOR($$F(xL),xR)
    Set temp = xL
    Set xL = xR
    Set xR = temp
 }
 Set temp = xL
 Set xL = xR
 Set xR = temp
 Set xR = $$XOR(xR,P(1))
 Set xL = $$XOR(xL,P(0))
 Quit
F(x) 
 New y,Bytes,B0,B1,B2,B3
 ; x is a 4 byte word (32 bits)
 Set B0=x#(4294967296)\(16777216)   
 Set B1=x#(16777216)\(65536)
 Set B2=x#(65536)\256   
 Set B3=x#256
 Set y = $$WordAdd(S(0, B0), S(1, B1))
 Set y = $$XOR(y,S(2, B2))
 Set y = $$WordAdd(y, S(3, B3))
 Quit y
ShiftLeftBy8(wordX)
 New SL
 Set SL=wordX*256#4294967296
 If SL>2147483647 Set SL=SL-4294967296
 Quit SL
WordAdd(wordA,wordB)
 ; Adds words A and B avoiding overflow
 New WA
 If wordA < 0 Set wordA = wordA + 4294967296
 If wordB < 0 Set wordB = wordB + 4294967296
 Set WA=wordA+wordB
 If WA > 2147483647 Set WA = WA - 4294967296
 Quit WA
WordSplit(Word,Bytes)
 ;' Splits 32-bit word (long) into 4 x 8-bit bytes
 Set Bytes(0)=Word#(4294967296)\(16777216)   
 Set Bytes(1)=Word#(16777216)\(65536)
 Set Bytes(2)=Word#(65536)\256   
 Set Bytes(3)=Word#256
 Quit 
WordJoin(a,b,c,d)
 ; Joins 4 x 8-bit bytes to form 32-bit word a.b.c.d
 Quit a*16777216+(b*65536)+(c*256)+d
UnsignedToLong(value)
 If value < 0 ! value '< 4294967296 Quit  ;Error 6 ' Overflow
 If value '> 2147483647 Quit value
 Quit value - 4294967296
LongToUnsigned(value)
 If value < 0 Quit value + 4294967296
 Quit value
AND(a,b)
 New r
 Set r=$ZBoolean(a,b,1)
 If r>2147483647 Set r=r-4294967296
 Quit r
XOR(a,b)
 New r   
 Set r = $ZBoolean(a,b,6)
 If r>2147483647 Set r=r-4294967296
 Quit r
OR(a,b)
 New r   
 Set r = $ZBoolean(a,b,7)
 If r>2147483647 Set r=r-4294967296
 Quit r
InitialiseKey(Key)
 New i,j,K,wData,wDataL,wDataR,Hash
 New S1,S2,P1
 ; Because creating a key can take a while we save created keys in a global under an encrypted key
 ; DSS/LM - Substitute VA Kernel MD5 hash for routine rhMD5 (next line)
 ;Set Hash=$$Encrypt^rhMD5(Key)
 Set Hash=$$UP^XLFSTR($$MAIN^XUMF5BYT($$HEX^XUMF5AU($$MD5R^XUMF5AU(Key))))
 ; DSS/LM - End substitution
 If $Data(^rhBlowfish(Hash)) Do  Quit
 .   Set S1="" For  Set S1=$Order(^rhBlowfish(Hash,"S",S1)) Quit:S1=""  Do
 ..      Set S2=""  For  Set S2=$Order(^rhBlowfish(Hash,"S",S1,S2)) Quit:S2=""  Set S(S1,S2)=^(S2)
 .   Set P1="" For  Set P1=$Order(^rhBlowfish(Hash,"P",P1)) Quit:P1=""  Set P(P1)=^(P1)
 Set NrBytes=$Length(Key)
 Do InitArrays
 Set j = 1
 For i = 0:1:17 {
    Set wData = 0
    For K = 0:1:3 {
       Set wData = $$OR($$ShiftLeftBy8(wData),$Ascii(Key,j))
       Set j = j + 1
       If j>NrBytes Set j = 1
    }
    Set P(i) = $$XOR(P(i),wData)
 }
 Set wDataL = 0
 Set wDataR = 0
 For i = 0:2:17 {
    Do EncipherBlock(.wDataL, .wDataR)
    Set P(i) = wDataL
    Set P(i + 1) = wDataR
 }
 For i = 0:1:3 {
    For j = 0:2:255 {
       Do EncipherBlock(.wDataL, .wDataR)
       Set S(i, j) = wDataL
       Set S(i, j + 1) = wDataR
    }
 }
 ; save the key for future use
 Set S1=""
 For  {
    Set S1=$Order(S(S1))
    If S1="" Quit
    Set S2=""
    For  {
       Set S2=$Order(S(S1,S2))
       If S2="" Quit
       Set ^rhBlowfish(Hash,"S",S1,S2)=S(S1,S2)
    }
 }
 Set P1=""
 For  {
    Set P1=$Order(P(P1))
    If P1="" Quit
    Set ^rhBlowfish(Hash,"P",P1)=P(P1)
 }
 Quit
InitArrays ; Init arrays
 Kill S,P
 Set S(0,0)=3509652390,S(0,1)=2564797868,S(0,2)=805139163,S(0,3)=3491422135,S(0,4)=3101798381,S(0,5)=1780907670
 Set S(0,6)=3128725573,S(0,7)=4046225305,S(0,8)=614570311,S(0,9)=3012652279,S(0,10)=134345442,S(0,11)=2240740374
 Set S(0,12)=1667834072,S(0,13)=1901547113,S(0,14)=2757295779,S(0,15)=4103290238,S(0,16)=227898511,S(0,17)=1921955416
 Set S(0,18)=1904987480,S(0,19)=2182433518,S(0,20)=2069144605,S(0,21)=3260701109,S(0,22)=2620446009,S(0,23)=720527379
 Set S(0,24)=3318853667,S(0,25)=677414384,S(0,26)=3393288472,S(0,27)=3101374703,S(0,28)=2390351024,S(0,29)=1614419982
 Set S(0,30)=1822297739,S(0,31)=2954791486,S(0,32)=3608508353,S(0,33)=3174124327,S(0,34)=2024746970,S(0,35)=1432378464
 Set S(0,36)=3864339955,S(0,37)=2857741204,S(0,38)=1464375394,S(0,39)=1676153920,S(0,40)=1439316330,S(0,41)=715854006
 Set S(0,42)=3033291828,S(0,43)=289532110,S(0,44)=2706671279,S(0,45)=2087905683,S(0,46)=3018724369,S(0,47)=1668267050
 Set S(0,48)=732546397,S(0,49)=1947742710,S(0,50)=3462151702,S(0,51)=2609353502,S(0,52)=2950085171,S(0,53)=1814351708
 Set S(0,54)=2050118529,S(0,55)=680887927,S(0,56)=999245976,S(0,57)=1800124847,S(0,58)=3300911131,S(0,59)=1713906067
 Set S(0,60)=1641548236,S(0,61)=4213287313,S(0,62)=1216130144,S(0,63)=1575780402,S(0,64)=4018429277,S(0,65)=3917837745
 Set S(0,66)=3693486850,S(0,67)=3949271944,S(0,68)=596196993,S(0,69)=3549867205,S(0,70)=258830323,S(0,71)=2213823033
 Set S(0,72)=772490370,S(0,73)=2760122372,S(0,74)=1774776394,S(0,75)=2652871518,S(0,76)=566650946,S(0,77)=4142492826
 Set S(0,78)=1728879713,S(0,79)=2882767088,S(0,80)=1783734482,S(0,81)=3629395816,S(0,82)=2517608232,S(0,83)=2874225571
 Set S(0,84)=1861159788,S(0,85)=326777828,S(0,86)=3124490320,S(0,87)=2130389656,S(0,88)=2716951837,S(0,89)=967770486
 Set S(0,90)=1724537150,S(0,91)=2185432712,S(0,92)=2364442137,S(0,93)=1164943284,S(0,94)=2105845187,S(0,95)=998989502
 Set S(0,96)=3765401048,S(0,97)=2244026483,S(0,98)=1075463327,S(0,99)=1455516326,S(0,100)=1322494562,S(0,101)=910128902
 Set S(0,102)=469688178,S(0,103)=1117454909,S(0,104)=936433444,S(0,105)=3490320968,S(0,106)=3675253459,S(0,107)=1240580251
 Set S(0,108)=122909385,S(0,109)=2157517691,S(0,110)=634681816,S(0,111)=4142456567,S(0,112)=3825094682,S(0,113)=3061402683
 Set S(0,114)=2540495037,S(0,115)=79693498,S(0,116)=3249098678,S(0,117)=1084186820,S(0,118)=1583128258,S(0,119)=426386531
 Set S(0,120)=1761308591,S(0,121)=1047286709,S(0,122)=322548459,S(0,123)=995290223,S(0,124)=1845252383,S(0,125)=2603652396
 Set S(0,126)=3431023940,S(0,127)=2942221577,S(0,128)=3202600964,S(0,129)=3727903485,S(0,130)=1712269319,S(0,131)=422464435
 Set S(0,132)=3234572375,S(0,133)=1170764815,S(0,134)=3523960633,S(0,135)=3117677531,S(0,136)=1434042557,S(0,137)=442511882
 Set S(0,138)=3600875718,S(0,139)=1076654713,S(0,140)=1738483198,S(0,141)=4213154764,S(0,142)=2393238008,S(0,143)=3677496056
 Set S(0,144)=1014306527,S(0,145)=4251020053,S(0,146)=793779912,S(0,147)=2902807211,S(0,148)=842905082,S(0,149)=4246964064
 Set S(0,150)=1395751752,S(0,151)=1040244610,S(0,152)=2656851899,S(0,153)=3396308128,S(0,154)=445077038,S(0,155)=3742853595
 Set S(0,156)=3577915638,S(0,157)=679411651,S(0,158)=2892444358,S(0,159)=2354009459,S(0,160)=1767581616,S(0,161)=3150600392
 Set S(0,162)=3791627101,S(0,163)=3102740896,S(0,164)=284835224,S(0,165)=4246832056,S(0,166)=1258075500,S(0,167)=768725851
 Set S(0,168)=2589189241,S(0,169)=3069724005,S(0,170)=3532540348,S(0,171)=1274779536,S(0,172)=3789419226,S(0,173)=2764799539
 Set S(0,174)=1660621633,S(0,175)=3471099624,S(0,176)=4011903706,S(0,177)=913787905,S(0,178)=3497959166,S(0,179)=737222580
 Set S(0,180)=2514213453,S(0,181)=2928710040,S(0,182)=3937242737,S(0,183)=1804850592,S(0,184)=3499020752,S(0,185)=2949064160
 Set S(0,186)=2386320175,S(0,187)=2390070455,S(0,188)=2415321851,S(0,189)=4061277028,S(0,190)=2290661394,S(0,191)=2416832540
 Set S(0,192)=1336762016,S(0,193)=1754252060,S(0,194)=3520065937,S(0,195)=3014181293,S(0,196)=791618072,S(0,197)=3188594551
 Set S(0,198)=3933548030,S(0,199)=2332172193,S(0,200)=3852520463,S(0,201)=3043980520,S(0,202)=413987798,S(0,203)=3465142937
 Set S(0,204)=3030929376,S(0,205)=4245938359,S(0,206)=2093235073,S(0,207)=3534596313,S(0,208)=375366246,S(0,209)=2157278981
 Set S(0,210)=2479649556,S(0,211)=555357303,S(0,212)=3870105701,S(0,213)=2008414854,S(0,214)=3344188149,S(0,215)=4221384143
 Set S(0,216)=3956125452,S(0,217)=2067696032,S(0,218)=3594591187,S(0,219)=2921233993,S(0,220)=2428461,S(0,221)=544322398
 Set S(0,222)=577241275,S(0,223)=1471733935,S(0,224)=610547355,S(0,225)=4027169054,S(0,226)=1432588573,S(0,227)=1507829418
 Set S(0,228)=2025931657,S(0,229)=3646575487,S(0,230)=545086370,S(0,231)=48609733,S(0,232)=2200306550,S(0,233)=1653985193
 Set S(0,234)=298326376,S(0,235)=1316178497,S(0,236)=3007786442,S(0,237)=2064951626,S(0,238)=458293330,S(0,239)=2589141269
 Set S(0,240)=3591329599,S(0,241)=3164325604,S(0,242)=727753846,S(0,243)=2179363840,S(0,244)=146436021,S(0,245)=1461446943
 Set S(0,246)=4069977195,S(0,247)=705550613,S(0,248)=3059967265,S(0,249)=3887724982,S(0,250)=4281599278,S(0,251)=3313849956
 Set S(0,252)=1404054877,S(0,253)=2845806497,S(0,254)=146425753,S(0,255)=1854211946
 Set S(1,0)=1266315497,S(1,1)=3048417604,S(1,2)=3681880366,S(1,3)=3289982499,S(1,4)=2909710000,S(1,5)=1235738493
 Set S(1,6)=2632868024,S(1,7)=2414719590,S(1,8)=3970600049,S(1,9)=1771706367,S(1,10)=1449415276,S(1,11)=3266420449
 Set S(1,12)=422970021,S(1,13)=1963543593,S(1,14)=2690192192,S(1,15)=3826793022,S(1,16)=1062508698,S(1,17)=1531092325
 Set S(1,18)=1804592342,S(1,19)=2583117782,S(1,20)=2714934279,S(1,21)=4024971509,S(1,22)=1294809318,S(1,23)=4028980673
 Set S(1,24)=1289560198,S(1,25)=2221992742,S(1,26)=1669523910,S(1,27)=35572830,S(1,28)=157838143,S(1,29)=1052438473
 Set S(1,30)=1016535060,S(1,31)=1802137761,S(1,32)=1753167236,S(1,33)=1386275462,S(1,34)=3080475397,S(1,35)=2857371447
 Set S(1,36)=1040679964,S(1,37)=2145300060,S(1,38)=2390574316,S(1,39)=1461121720,S(1,40)=2956646967,S(1,41)=4031777805
 Set S(1,42)=4028374788,S(1,43)=33600511,S(1,44)=2920084762,S(1,45)=1018524850,S(1,46)=629373528,S(1,47)=3691585981
 Set S(1,48)=3515945977,S(1,49)=2091462646,S(1,50)=2486323059,S(1,51)=586499841,S(1,52)=988145025,S(1,53)=935516892
 Set S(1,54)=3367335476,S(1,55)=2599673255,S(1,56)=2839830854,S(1,57)=265290510,S(1,58)=3972581182,S(1,59)=2759138881
 Set S(1,60)=3795373465,S(1,61)=1005194799,S(1,62)=847297441,S(1,63)=406762289,S(1,64)=1314163512,S(1,65)=1332590856
 Set S(1,66)=1866599683,S(1,67)=4127851711,S(1,68)=750260880,S(1,69)=613907577,S(1,70)=1450815602,S(1,71)=3165620655
 Set S(1,72)=3734664991,S(1,73)=3650291728,S(1,74)=3012275730,S(1,75)=3704569646,S(1,76)=1427272223,S(1,77)=778793252
 Set S(1,78)=1343938022,S(1,79)=2676280711,S(1,80)=2052605720,S(1,81)=1946737175,S(1,82)=3164576444,S(1,83)=3914038668
 Set S(1,84)=3967478842,S(1,85)=3682934266,S(1,86)=1661551462,S(1,87)=3294938066,S(1,88)=4011595847,S(1,89)=840292616
 Set S(1,90)=3712170807,S(1,91)=616741398,S(1,92)=312560963,S(1,93)=711312465,S(1,94)=1351876610,S(1,95)=322626781
 Set S(1,96)=1910503582,S(1,97)=271666773,S(1,98)=2175563734,S(1,99)=1594956187,S(1,100)=70604529,S(1,101)=3617834859
 Set S(1,102)=1007753275,S(1,103)=1495573769,S(1,104)=4069517037,S(1,105)=2549218298,S(1,106)=2663038764,S(1,107)=504708206
 Set S(1,108)=2263041392,S(1,109)=3941167025,S(1,110)=2249088522,S(1,111)=1514023603,S(1,112)=1998579484,S(1,113)=1312622330
 Set S(1,114)=694541497,S(1,115)=2582060303,S(1,116)=2151582166,S(1,117)=1382467621,S(1,118)=776784248,S(1,119)=2618340202
 Set S(1,120)=3323268794,S(1,121)=2497899128,S(1,122)=2784771155,S(1,123)=503983604,S(1,124)=4076293799,S(1,125)=907881277
 Set S(1,126)=423175695,S(1,127)=432175456,S(1,128)=1378068232,S(1,129)=4145222326,S(1,130)=3954048622,S(1,131)=3938656102
 Set S(1,132)=3820766613,S(1,133)=2793130115,S(1,134)=2977904593,S(1,135)=26017576,S(1,136)=3274890735,S(1,137)=3194772133
 Set S(1,138)=1700274565,S(1,139)=1756076034,S(1,140)=4006520079,S(1,141)=3677328699,S(1,142)=720338349,S(1,143)=1533947780
 Set S(1,144)=354530856,S(1,145)=688349552,S(1,146)=3973924725,S(1,147)=1637815568,S(1,148)=332179504,S(1,149)=3949051286
 Set S(1,150)=53804574,S(1,151)=2852348879,S(1,152)=3044236432,S(1,153)=1282449977,S(1,154)=3583942155,S(1,155)=3416972820
 Set S(1,156)=4006381244,S(1,157)=1617046695,S(1,158)=2628476075,S(1,159)=3002303598,S(1,160)=1686838959,S(1,161)=431878346
 Set S(1,162)=2686675385,S(1,163)=1700445008,S(1,164)=1080580658,S(1,165)=1009431731,S(1,166)=832498133,S(1,167)=3223435511
 Set S(1,168)=2605976345,S(1,169)=2271191193,S(1,170)=2516031870,S(1,171)=1648197032,S(1,172)=4164389018,S(1,173)=2548247927
 Set S(1,174)=300782431,S(1,175)=375919233,S(1,176)=238389289,S(1,177)=3353747414,S(1,178)=2531188641,S(1,179)=2019080857
 Set S(1,180)=1475708069,S(1,181)=455242339,S(1,182)=2609103871,S(1,183)=448939670,S(1,184)=3451063019,S(1,185)=1395535956
 Set S(1,186)=2413381860,S(1,187)=1841049896,S(1,188)=1491858159,S(1,189)=885456874,S(1,190)=4264095073,S(1,191)=4001119347
 Set S(1,192)=1565136089,S(1,193)=3898914787,S(1,194)=1108368660,S(1,195)=540939232,S(1,196)=1173283510,S(1,197)=2745871338
 Set S(1,198)=3681308437,S(1,199)=4207628240,S(1,200)=3343053890,S(1,201)=4016749493,S(1,202)=1699691293,S(1,203)=1103962373
 Set S(1,204)=3625875870,S(1,205)=2256883143,S(1,206)=3830138730,S(1,207)=1031889488,S(1,208)=3479347698,S(1,209)=1535977030
 Set S(1,210)=4236805024,S(1,211)=3251091107,S(1,212)=2132092099,S(1,213)=1774941330,S(1,214)=1199868427,S(1,215)=1452454533
 Set S(1,216)=157007616,S(1,217)=2904115357,S(1,218)=342012276,S(1,219)=595725824,S(1,220)=1480756522,S(1,221)=206960106
 Set S(1,222)=497939518,S(1,223)=591360097,S(1,224)=863170706,S(1,225)=2375253569,S(1,226)=3596610801,S(1,227)=1814182875
 Set S(1,228)=2094937945,S(1,229)=3421402208,S(1,230)=1082520231,S(1,231)=3463918190,S(1,232)=2785509508,S(1,233)=435703966
 Set S(1,234)=3908032597,S(1,235)=1641649973,S(1,236)=2842273706,S(1,237)=3305899714,S(1,238)=1510255612,S(1,239)=2148256476
 Set S(1,240)=2655287854,S(1,241)=3276092548,S(1,242)=4258621189,S(1,243)=236887753,S(1,244)=3681803219,S(1,245)=274041037
 Set S(1,246)=1734335097,S(1,247)=3815195456,S(1,248)=3317970021,S(1,249)=1899903192,S(1,250)=1026095262,S(1,251)=4050517792
 Set S(1,252)=356393447,S(1,253)=2410691914,S(1,254)=3873677099,S(1,255)=3682840055
 Set S(2,0)=3913112168,S(2,1)=2491498743,S(2,2)=4132185628,S(2,3)=2489919796,S(2,4)=1091903735,S(2,5)=1979897079
 Set S(2,6)=3170134830,S(2,7)=3567386728,S(2,8)=3557303409,S(2,9)=857797738,S(2,10)=1136121015,S(2,11)=1342202287
 Set S(2,12)=507115054,S(2,13)=2535736646,S(2,14)=337727348,S(2,15)=3213592640,S(2,16)=1301675037,S(2,17)=2528481711
 Set S(2,18)=1895095763,S(2,19)=1721773893,S(2,20)=3216771564,S(2,21)=62756741,S(2,22)=2142006736,S(2,23)=835421444
 Set S(2,24)=2531993523,S(2,25)=1442658625,S(2,26)=3659876326,S(2,27)=2882144922,S(2,28)=676362277,S(2,29)=1392781812
 Set S(2,30)=170690266,S(2,31)=3921047035,S(2,32)=1759253602,S(2,33)=3611846912,S(2,34)=1745797284,S(2,35)=664899054
 Set S(2,36)=1329594018,S(2,37)=3901205900,S(2,38)=3045908486,S(2,39)=2062866102,S(2,40)=2865634940,S(2,41)=3543621612
 Set S(2,42)=3464012697,S(2,43)=1080764994,S(2,44)=553557557,S(2,45)=3656615353,S(2,46)=3996768171,S(2,47)=991055499
 Set S(2,48)=499776247,S(2,49)=1265440854,S(2,50)=648242737,S(2,51)=3940784050,S(2,52)=980351604,S(2,53)=3713745714
 Set S(2,54)=1749149687,S(2,55)=3396870395,S(2,56)=4211799374,S(2,57)=3640570775,S(2,58)=1161844396,S(2,59)=3125318951
 Set S(2,60)=1431517754,S(2,61)=545492359,S(2,62)=4268468663,S(2,63)=3499529547,S(2,64)=1437099964,S(2,65)=2702547544
 Set S(2,66)=3433638243,S(2,67)=2581715763,S(2,68)=2787789398,S(2,69)=1060185593,S(2,70)=1593081372,S(2,71)=2418618748
 Set S(2,72)=4260947970,S(2,73)=69676912,S(2,74)=2159744348,S(2,75)=86519011,S(2,76)=2512459080,S(2,77)=3838209314
 Set S(2,78)=1220612927,S(2,79)=3339683548,S(2,80)=133810670,S(2,81)=1090789135,S(2,82)=1078426020,S(2,83)=1569222167
 Set S(2,84)=845107691,S(2,85)=3583754449,S(2,86)=4072456591,S(2,87)=1091646820,S(2,88)=628848692,S(2,89)=1613405280
 Set S(2,90)=3757631651,S(2,91)=526609435,S(2,92)=236106946,S(2,93)=48312990,S(2,94)=2942717905,S(2,95)=3402727701
 Set S(2,96)=1797494240,S(2,97)=859738849,S(2,98)=992217954,S(2,99)=4005476642,S(2,100)=2243076622,S(2,101)=3870952857
 Set S(2,102)=3732016268,S(2,103)=765654824,S(2,104)=3490871365,S(2,105)=2511836413,S(2,106)=1685915746,S(2,107)=3888969200
 Set S(2,108)=1414112111,S(2,109)=2273134842,S(2,110)=3281911079,S(2,111)=4080962846,S(2,112)=172450625,S(2,113)=2569994100
 Set S(2,114)=980381355,S(2,115)=4109958455,S(2,116)=2819808352,S(2,117)=2716589560,S(2,118)=2568741196,S(2,119)=3681446669
 Set S(2,120)=3329971472,S(2,121)=1835478071,S(2,122)=660984891,S(2,123)=3704678404,S(2,124)=4045999559,S(2,125)=3422617507
 Set S(2,126)=3040415634,S(2,127)=1762651403,S(2,128)=1719377915,S(2,129)=3470491036,S(2,130)=2693910283,S(2,131)=3642056355
 Set S(2,132)=3138596744,S(2,133)=1364962596,S(2,134)=2073328063,S(2,135)=1983633131,S(2,136)=926494387,S(2,137)=3423689081
 Set S(2,138)=2150032023,S(2,139)=4096667949,S(2,140)=1749200295,S(2,141)=3328846651,S(2,142)=309677260,S(2,143)=2016342300
 Set S(2,144)=1779581495,S(2,145)=3079819751,S(2,146)=111262694,S(2,147)=1274766160,S(2,148)=443224088,S(2,149)=298511866
 Set S(2,150)=1025883608,S(2,151)=3806446537,S(2,152)=1145181785,S(2,153)=168956806,S(2,154)=3641502830,S(2,155)=3584813610
 Set S(2,156)=1689216846,S(2,157)=3666258015,S(2,158)=3200248200,S(2,159)=1692713982,S(2,160)=2646376535,S(2,161)=4042768518
 Set S(2,162)=1618508792,S(2,163)=1610833997,S(2,164)=3523052358,S(2,165)=4130873264,S(2,166)=2001055236,S(2,167)=3610705100
 Set S(2,168)=2202168115,S(2,169)=4028541809,S(2,170)=2961195399,S(2,171)=1006657119,S(2,172)=2006996926,S(2,173)=3186142756
 Set S(2,174)=1430667929,S(2,175)=3210227297,S(2,176)=1314452623,S(2,177)=4074634658,S(2,178)=4101304120,S(2,179)=2273951170
 Set S(2,180)=1399257539,S(2,181)=3367210612,S(2,182)=3027628629,S(2,183)=1190975929,S(2,184)=2062231137,S(2,185)=2333990788
 Set S(2,186)=2221543033,S(2,187)=2438960610,S(2,188)=1181637006,S(2,189)=548689776,S(2,190)=2362791313,S(2,191)=3372408396
 Set S(2,192)=3104550113,S(2,193)=3145860560,S(2,194)=296247880,S(2,195)=1970579870,S(2,196)=3078560182,S(2,197)=3769228297
 Set S(2,198)=1714227617,S(2,199)=3291629107,S(2,200)=3898220290,S(2,201)=166772364,S(2,202)=1251581989,S(2,203)=493813264
 Set S(2,204)=448347421,S(2,205)=195405023,S(2,206)=2709975567,S(2,207)=677966185,S(2,208)=3703036547,S(2,209)=1463355134
 Set S(2,210)=2715995803,S(2,211)=1338867538,S(2,212)=1343315457,S(2,213)=2802222074,S(2,214)=2684532164,S(2,215)=233230375
 Set S(2,216)=2599980071,S(2,217)=2000651841,S(2,218)=3277868038,S(2,219)=1638401717,S(2,220)=4028070440,S(2,221)=3237316320
 Set S(2,222)=6314154,S(2,223)=819756386,S(2,224)=300326615,S(2,225)=590932579,S(2,226)=1405279636,S(2,227)=3267499572
 Set S(2,228)=3150704214,S(2,229)=2428286686,S(2,230)=3959192993,S(2,231)=3461946742,S(2,232)=1862657033,S(2,233)=1266418056
 Set S(2,234)=963775037,S(2,235)=2089974820,S(2,236)=2263052895,S(2,237)=1917689273,S(2,238)=448879540,S(2,239)=3550394620
 Set S(2,240)=3981727096,S(2,241)=150775221,S(2,242)=3627908307,S(2,243)=1303187396,S(2,244)=508620638,S(2,245)=2975983352
 Set S(2,246)=2726630617,S(2,247)=1817252668,S(2,248)=1876281319,S(2,249)=1457606340,S(2,250)=908771278,S(2,251)=3720792119
 Set S(2,252)=3617206836,S(2,253)=2455994898,S(2,254)=1729034894,S(2,255)=1080033504
 Set S(3,0)=976866871,S(3,1)=3556439503,S(3,2)=2881648439,S(3,3)=1522871579,S(3,4)=1555064734,S(3,5)=1336096578
 Set S(3,6)=3548522304,S(3,7)=2579274686,S(3,8)=3574697629,S(3,9)=3205460757,S(3,10)=3593280638,S(3,11)=3338716283
 Set S(3,12)=3079412587,S(3,13)=564236357,S(3,14)=2993598910,S(3,15)=1781952180,S(3,16)=1464380207,S(3,17)=3163844217
 Set S(3,18)=3332601554,S(3,19)=1699332808,S(3,20)=1393555694,S(3,21)=1183702653,S(3,22)=3581086237,S(3,23)=1288719814
 Set S(3,24)=691649499,S(3,25)=2847557200,S(3,26)=2895455976,S(3,27)=3193889540,S(3,28)=2717570544,S(3,29)=1781354906
 Set S(3,30)=1676643554,S(3,31)=2592534050,S(3,32)=3230253752,S(3,33)=1126444790,S(3,34)=2770207658,S(3,35)=2633158820
 Set S(3,36)=2210423226,S(3,37)=2615765581,S(3,38)=2414155088,S(3,39)=3127139286,S(3,40)=673620729,S(3,41)=2805611233
 Set S(3,42)=1269405062,S(3,43)=4015350505,S(3,44)=3341807571,S(3,45)=4149409754,S(3,46)=1057255273,S(3,47)=2012875353
 Set S(3,48)=2162469141,S(3,49)=2276492801,S(3,50)=2601117357,S(3,51)=993977747,S(3,52)=3918593370,S(3,53)=2654263191
 Set S(3,54)=753973209,S(3,55)=36408145,S(3,56)=2530585658,S(3,57)=25011837,S(3,58)=3520020182,S(3,59)=2088578344
 Set S(3,60)=530523599,S(3,61)=2918365339,S(3,62)=1524020338,S(3,63)=1518925132,S(3,64)=3760827505,S(3,65)=3759777254
 Set S(3,66)=1202760957,S(3,67)=3985898139,S(3,68)=3906192525,S(3,69)=674977740,S(3,70)=4174734889,S(3,71)=2031300136
 Set S(3,72)=2019492241,S(3,73)=3983892565,S(3,74)=4153806404,S(3,75)=3822280332,S(3,76)=352677332,S(3,77)=2297720250
 Set S(3,78)=60907813,S(3,79)=90501309,S(3,80)=3286998549,S(3,81)=1016092578,S(3,82)=2535922412,S(3,83)=2839152426
 Set S(3,84)=457141659,S(3,85)=509813237,S(3,86)=4120667899,S(3,87)=652014361,S(3,88)=1966332200,S(3,89)=2975202805
 Set S(3,90)=55981186,S(3,91)=2327461051,S(3,92)=676427537,S(3,93)=3255491064,S(3,94)=2882294119,S(3,95)=3433927263
 Set S(3,96)=1307055953,S(3,97)=942726286,S(3,98)=933058658,S(3,99)=2468411793,S(3,100)=3933900994,S(3,101)=4215176142
 Set S(3,102)=1361170020,S(3,103)=2001714738,S(3,104)=2830558078,S(3,105)=3274259782,S(3,106)=1222529897,S(3,107)=1679025792
 Set S(3,108)=2729314320,S(3,109)=3714953764,S(3,110)=1770335741,S(3,111)=151462246,S(3,112)=3013232138,S(3,113)=1682292957
 Set S(3,114)=1483529935,S(3,115)=471910574,S(3,116)=1539241949,S(3,117)=458788160,S(3,118)=3436315007,S(3,119)=1807016891
 Set S(3,120)=3718408830,S(3,121)=978976581,S(3,122)=1043663428,S(3,123)=3165965781,S(3,124)=1927990952,S(3,125)=4200891579
 Set S(3,126)=2372276910,S(3,127)=3208408903,S(3,128)=3533431907,S(3,129)=1412390302,S(3,130)=2931980059,S(3,131)=4132332400
 Set S(3,132)=1947078029,S(3,133)=3881505623,S(3,134)=4168226417,S(3,135)=2941484381,S(3,136)=1077988104,S(3,137)=1320477388
 Set S(3,138)=886195818,S(3,139)=18198404,S(3,140)=3786409000,S(3,141)=2509781533,S(3,142)=112762804,S(3,143)=3463356488
 Set S(3,144)=1866414978,S(3,145)=891333506,S(3,146)=18488651,S(3,147)=661792760,S(3,148)=1628790961,S(3,149)=3885187036
 Set S(3,150)=3141171499,S(3,151)=876946877,S(3,152)=2693282273,S(3,153)=1372485963,S(3,154)=791857591,S(3,155)=2686433993
 Set S(3,156)=3759982718,S(3,157)=3167212022,S(3,158)=3472953795,S(3,159)=2716379847,S(3,160)=445679433,S(3,161)=3561995674
 Set S(3,162)=3504004811,S(3,163)=3574258232,S(3,164)=54117162,S(3,165)=3331405415,S(3,166)=2381918588,S(3,167)=3769707343
 Set S(3,168)=4154350007,S(3,169)=1140177722,S(3,170)=4074052095,S(3,171)=668550556,S(3,172)=3214352940,S(3,173)=367459370
 Set S(3,174)=261225585,S(3,175)=2610173221,S(3,176)=4209349473,S(3,177)=3468074219,S(3,178)=3265815641,S(3,179)=314222801
 Set S(3,180)=3066103646,S(3,181)=3808782860,S(3,182)=282218597,S(3,183)=3406013506,S(3,184)=3773591054,S(3,185)=379116347
 Set S(3,186)=1285071038,S(3,187)=846784868,S(3,188)=2669647154,S(3,189)=3771962079,S(3,190)=3550491691,S(3,191)=2305946142
 Set S(3,192)=453669953,S(3,193)=1268987020,S(3,194)=3317592352,S(3,195)=3279303384,S(3,196)=3744833421,S(3,197)=2610507566
 Set S(3,198)=3859509063,S(3,199)=266596637,S(3,200)=3847019092,S(3,201)=517658769,S(3,202)=3462560207,S(3,203)=3443424879
 Set S(3,204)=370717030,S(3,205)=4247526661,S(3,206)=2224018117,S(3,207)=4143653529,S(3,208)=4112773975,S(3,209)=2788324899
 Set S(3,210)=2477274417,S(3,211)=1456262402,S(3,212)=2901442914,S(3,213)=1517677493,S(3,214)=1846949527,S(3,215)=2295493580
 Set S(3,216)=3734397586,S(3,217)=2176403920,S(3,218)=1280348187,S(3,219)=1908823572,S(3,220)=3871786941,S(3,221)=846861322
 Set S(3,222)=1172426758,S(3,223)=3287448474,S(3,224)=3383383037,S(3,225)=1655181056,S(3,226)=3139813346,S(3,227)=901632758
 Set S(3,228)=1897031941,S(3,229)=2986607138,S(3,230)=3066810236,S(3,231)=3447102507,S(3,232)=1393639104,S(3,233)=373351379
 Set S(3,234)=950779232,S(3,235)=625454576,S(3,236)=3124240540,S(3,237)=4148612726,S(3,238)=2007998917,S(3,239)=544563296
 Set S(3,240)=2244738638,S(3,241)=2330496472,S(3,242)=2058025392,S(3,243)=1291430526,S(3,244)=424198748,S(3,245)=50039436
 Set S(3,246)=29584100,S(3,247)=3605783033,S(3,248)=2429876329,S(3,249)=2791104160,S(3,250)=1057563949,S(3,251)=3255363231
 Set S(3,252)=3075367218,S(3,253)=3463963227,S(3,254)=1469046755,S(3,255)=985887462
 For i=0:1:3 For j=0:1:255 If S(i,j)>2147483647 Set S(i,j)=S(i,j)-4294967296
 Set P(0)=608135816,P(1)=2242054355,P(2)=320440878,P(3)=57701188,P(4)=2752067618,P(5)=698298832
 Set P(6)=137296536,P(7)=3964562569,P(8)=1160258022,P(9)=953160567,P(10)=3193202383,P(11)=887688300
 Set P(12)=3232508343,P(13)=3380367581,P(14)=1065670069,P(15)=3041331479,P(16)=2450970073,P(17)=2306472731
 For i=0:1:17 If P(i)>2147483647 Set P(i)=P(i)-4294967296
 Quit
TestString(s) 
 New Key,String,t1,t2,t3,t4
 New E,D
 Set String=$Get(s)
 Set Key="Dog food is good for you, it makes you healthy and shiny too (Iggy Pop)"
 If $Get(String)="" {
            Set String="Blowfish is a symmetric block cipher that can be used as a drop-in replacement for DES or IDEA. "
               _"It takes a variable-length key, from 32 bits to 448 bits, making it ideal for both domestic and exportable use. "
               _"Blowfish was designed in 1993 by Bruce Schneier as a fast, free alternative to existing encryption algorithms. "
               _"Since then it has been analyzed considerably, and it is slowly gaining acceptance as a strong encryption algorithm. "
               _"Blowfish is unpatented and license-free, and is available free for all uses."
 }
 Set t1=$zh
 Set E=$$EncryptString(String,Key)
 Set t2=$zh
 ;Write "E=",E,!
 Set t3=$zh
 Set D=$$DecryptString(E,Key)
 Set t4=$zh
 ;Write "D=",D,!
 If D'=String Write "*** ERROR ****",!,String,!,"E=",E,!,"D=",D,!
 Write "Encryption "_$Length(String)_" chars : ",t2-t1," s.",!
 Write "Decryption "_$Length(E)_" bytes : ",t4-t3," s.",!
 Quit
TestFile
 New Key,String,t1,t2,t3,t4
 New E,D,F1,F2,F3
 Set Key="Pecunia non olet"
 Set F1=$Piece($ZUtil(86),"*",1) ; Current configuration file
 Set F2=$Piece(F1,"\",1,$Length(F1,"\")-1)_"\md5.enc"
 Set F3=$Piece(F1,"\",1,$Length(F1,"\")-1)_"\md5.dec"
 Set t1=$zh
 Do EncryptFile(F1,F2,Key)
 Set t2=$zh
 Set t3=$zh
 Do DecryptFile(F2,F3,Key)
 Set t4=$zh
 Write "Encryption "_$ZUtil(140,1,F1)_" bytes : ",t2-t1," s.",!
 Write "Decryption "_$ZUtil(140,1,F2)_" bytes : ",t4-t3," s.",!
 ;
 Quit
TestBytes
 New Key,String,t1,t2,t3,t4,S,P,Bytes,i
 New E,D,F1,F2,F3
 Set (E,D)=""
 Set Key="hebban olla uogala nestas bigunnan hinase hic enda thu"
 Do InitialiseKey(Key)
 Set String="ABCDEFGH"
 For i=0:1:7 Set Bytes(i)=$Ascii(String,i+1)
 Set t1=$zh
 Do EncryptBytes(.Bytes)
 Set t2=$zh
 For i=0:1:7 Set E=E_$Char(Bytes(i))
 Set t3=$zh
 Do DecryptBytes(.Bytes)
 Set t4=$zh
 For i=0:1:7 Set D=D_$Char(Bytes(i))
 If D'=String Write "**ERROR** String=",String," D=",D,!
 Write "Encryption: ",t2-t1," s.",!
 Write "Decryption: ",t4-t3," s.",!
 Quit
