VFDRPARK ;DSS/WLC - ARRA VTE REPORT APIS;02/17/2011 12:36 ; 03 May 2011  5:03 PM
 ;;2011.1.2;DSS,INC VXVISTA OPEN SOURCE;;28 Jan 2013;Build 153
 ;Copyright 1995-2013,Document Storage Systems Inc. All Rights Reserved
 ;
Q  ; call by line tag below
 ;
 ; API to return patient's age.  Input array is list of DFN's (VFDPAT(DFN(1))="", VFDPAT(DFN(2))="", VFDPAT(DFN(n))=""
 ; Return value is list of patients sent in with correspomding age:  VFDREP
 ;
AGE(VFDREP,VFDPAT)  ;
 N DFN,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=0 F  S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . I $D(DEBUG) B
 . S DFN=+$G(@VFDPAT@(VLP))
 . I $D(DEBUG) B
 . I +$$GET1^DIQ(2,+DFN_",",.033)>0 S AGE=+$$GET1^DIQ(2,+DFN_",",.033)
 . E  D
 . . K VADM S VADM("D")=$$NOW^XLFDT D DEM^VADPT S AGE=$G(VADM(4))
 . I $D(DEBUG) B
 . S @VFDREP@(VLP)=$S(AGE>0:AGE,1:"")
 . ;I $D(DEBUG) B
 Q
 ;
LOS(VFDREP,VFDPAT,VFDFG)  ;
 ; VFDFG:
 ;  Boolean to exclude if LOS < 2 days (1 = exclude, 0 = skip)
 N ADM,DDM,DIF,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S X=0 F  S X=$O(@VFDPAT@(X)) Q:'X  D
 . S ADM=+@VFDPAT@(X),DDM=$S($P(@VFDPAT@(X),U,2):$P(@VFDPAT@(X),U,2),1:$$NOW^XLFDT)
 . S DIF=$$FMDIFF^XLFDT(DDM,ADM,1)
 . S Y=1
 . I DIF>120 S Y=0
 . I DIF<2,VFDFG S Y=0
 . S @VFDREP@(X)=Y  ; exclude if Y=0
 . I $D(DEBUG) B
 Q
 ;
COMFORT(VFDREP,VFDPAT)  ;
 N ADM,DDM,DFN,CODE,REC,RET,VLP,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . S DFN=$P(@VFDPAT@(VLP),U,1),VST=$P(@VFDPAT@(VLP),U,2) K LOOKUP
 . I '$D(^VFD(21640.01,"C",DFN)) S @VFDPAT@(VLP)=0 Q
 . S REC=0 F  S REC=$O(^VFD(21640.01,"AD",VST,REC)) Q:'REC  D
 . . S CODE=$$GET1^DIQ(21640.01,REC_",",.01) S LOOKUP(CNT)=CODE,CNT=CNT+1
 . Q:'$D(LOOKUP)  K RET D ISINTBL^VFDRPARL(.RET,.LOOKUP,"JC TABLE 3-63 PALLIATIVE CARE MEASURE-PROCEDURE") S @VFDPAT@(VLP)=+RET(VLP)
 Q
 ; 
POV(VFDREP,VFDPAT,PORA)  ;
 ; API to return exceptions for ICD9 codes.
 ; INPUT:
 ; VFDPAT = array of patients as ^TMP("MAIN",$J,CNT)=Visit Ien ^ DFN
 ; PORA = Flag to indicate return of 'P'rincipal diagnosis only, or 'A'll.
 ;
 ; OUTPUT:
 ; Array of values where VFDREP(CNT)=ICD Code 1^ICD Code 2^ICD Code 3^ICD Code 4...ICD Code 8
 ;
 N CODE,CNT,DFN,VIEN,VLP,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=0 F  S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . S VIEN=+@VFDPAT@(VLP),DFN=$P(@VFDPAT@(VLP),U,2) S $P(@VFDREP@(VLP),U,8)=""
 . D ENCEVENT^PXAPI(VIEN)
 . S Y=0,CNT=1 F  S Y=$O(^TMP("PXKENC",$J,VIEN,"POV",Y)) Q:'Y  D
 . . S CODE=$$GET1^DIQ(80,Y_",",.01)
 . . I PORA="P",$P(^TMP("PXKENC",$J,VIEN,"POV",Y,0),U,12)="P" S $P(@VFDREP@(VLP),U,CNT)=CODE
 . . I PORA="A" S $P(@VFDREP@(VLP),U,CNT)=CODE
 . . S CNT=CNT+1
 . I $D(DEBUG) B
 Q
 ;
VTEP(VFDREP,VFDPAT)  ; find VTE Prophylaxis in VFD IHTSdo (#21640.01) file
 N ADM,CNT,DDM,DFN,CODE,FLG,LOOKUP,REC,RET,RET1,VLP,VLP1,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=0
 F  S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . S DFN=$P(@VFDPAT@(VLP),U,1),VST=$P(@VFDPAT@(VLP),U,2)
 . I '$D(^VFD(21640.01,"C",DFN)) S @VFDREP@(VLP)=0 Q
 . S REC="",CNT=1 K LOOKUP F  S REC=$O(^VFD(21640.01,"C",DFN,REC)) Q:'REC  D
 . . S CODE=$$GET1^DIQ(21640.01,REC_",",.01) S LOOKUP(CNT)=CODE,CNT=CNT+1
 . Q:'$D(LOOKUP)  K RET D ISINTBL^VFDRPARL($NA(RET),$NA(LOOKUP),"JC TABLE 3-249 VTE PROPHYLAXIS")
 . S @VFDREP@(VLP)=0
 . S FLG=1 F VLP1=1:1:(CNT-1) I $G(RET(VLP1))=1 S @VFDREP@(VLP)=1,FLG=1 Q
 . Q:FLG  D ISINTBL^VFDRPARL($NA(RET1),$NA(LOOKUP),"JC TABLE 3-252 VTE PROPHYLAXIS")
 . F VLP1=1:1:(CNT-1) I $G(RET1(VLP1))=1 S @VFDREP@(VLP)=1,FLG=1 Q
 Q
 ;
VTECON(VFDREP,VFDPAT)  ; VTE Confirmed
 N ADM,CNT,DDM,DFN,CODE,LOOKUP,REC,RET,RET1,VLP,VLP1,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=0
 F  S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . S DFN=$P(@VFDPAT@(VLP),U,1),VST=$P(@VFDPAT@(VLP),U,2)
 . I '$D(^VFD(21640.01,"C",DFN)) S @VFDREP@(VLP)=0 Q
 . S REC="",CNT=1 K LOOKUP F  S REC=$O(^VFD(21640.01,"C",DFN,REC)) Q:'REC  D
 . . S CODE=$$GET1^DIQ(21640.01,REC_",",.01) S LOOKUP(CNT)=CODE,CNT=CNT+1
 . S @VFDREP@(VLP)=0
 . D ISINTBL^VFDRPARL($NA(RET1),$NA(LOOKUP),"Table 3-240 JOINT COMMISSION VTE CONFIRMED VALUE SET")
 . F VLP1=1:1:(CNT-1) I $G(RET1(VLP1))=1 S @VFDREP@(VLP)=1 Q
 Q
 ; 
NOVTE(VFDREP,VFDPAT)  ; find reason for no VTE
 N ADM,CNT,DDM,DFN,CODE,LOOKUP,REC,RET,RET1,VLP,VLP1,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=0
 F  S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . S DFN=$P(@VFDPAT@(VLP),U,1),VST=$P(@VFDPAT@(VLP),U,2)
 . I '$D(^VFD(21640.01,"C",DFN)) S @VFDREP@(VLP)=0 Q
 . S REC="",CNT=1 K LOOKUP F  S REC=$O(^VFD(21640.01,"C",DFN,REC)) Q:'REC  D
 . . S CODE=$$GET1^DIQ(21640.01,REC_",",.01) S LOOKUP(CNT)=CODE,CNT=CNT+1
 . S @VFDREP@(VLP)=0
 . D ISINTBL^VFDRPARL($NA(RET1),$NA(LOOKUP),"JC TABLE 3-201 REASON FOR NO VTE PROPHYLAXIS-PHARM")
 . F VLP1=1:1:(CNT-1) I $G(RET1(VLP1))=1 S @VFDREP@(VLP)=1 Q
 Q
 ; 
NOVTE1(VFDREP,VFDPAT)  ; find reason for no VTE - Mechanical definition
 N ADM,CNT,DDM,DFN,CODE,LOOKUP,REC,RET,RET1,VLP,VLP1,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=0
 F  S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . S DFN=$P(@VFDPAT@(VLP),U,1),VST=$P(@VFDPAT@(VLP),U,2)
 . I '$D(^VFD(21640.01,"C",DFN)) S @VFDREP@(VLP)=0 Q
 . S REC="",CNT=1 K LOOKUP F  S REC=$O(^VFD(21640.01,"C",DFN,REC)) Q:'REC  D
 . . S CODE=$$GET1^DIQ(21640.01,REC_",",.01) S LOOKUP(CNT)=CODE,CNT=CNT+1
 . S @VFDREP@(VLP)=0
 . D ISINTBL^VFDRPARL($NA(RET1),$NA(LOOKUP),"JC TABLE 3-198 REASON FOR NO VTE PROPHYLAXIS-MECHANICAL DEFINITION")
 . F VLP1=1:1:(CNT-1) I $G(RET1(VLP1))=1 S @VFDREP@(VLP)=1 Q
 Q
 ;
MRV(VFDREP,VFDPAT)  ; find reason for no VTE - No Medical Reason
 N ADM,CNT,DDM,DFN,CODE,LOOKUP,REC,RET,RET1,VLP,VLP1,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=0
 F  S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . S DFN=$P(@VFDPAT@(VLP),U,1),VST=$P(@VFDPAT@(VLP),U,2)
 . I '$D(^VFD(21640.01,"C",DFN)) S @VFDREP@(VLP)=0 Q
 . S REC="",CNT=1 K LOOKUP F  S REC=$O(^VFD(21640.01,"C",DFN,REC)) Q:'REC  D
 . . S CODE=$$GET1^DIQ(21640.01,REC_",",.01) S LOOKUP(CNT)=CODE,CNT=CNT+1
 . S @VFDREP@(VLP)=0
 . D ISINTBL^VFDRPARL($NA(RET1),$NA(LOOKUP),"JC TABLE 3-165 MEDICAL REASON VALUE SET")
 . F VLP1=1:1:(CNT-1) I $G(RET1(VLP1))=1 S @VFDREP@(VLP)=1 Q
 Q
 ;
MND(VFDREP,VFDPAT)  ; find reason for no VTE - Mental Disorders
 N ADM,CNT,DDM,DFN,CODE,LOOKUP,REC,RET,RET1,VLP,VLP1,X,Y
 S VFDREP=$NA(^TMP("VFDRPARK",$J)) K @VFDREP
 I '$D(VFDPAT) S @VFDREP@(0)="-1^No Patient list sent." Q
 S VLP=0
 F  S VLP=$O(@VFDPAT@(VLP)) Q:'VLP  D
 . S DFN=$P(@VFDPAT@(VLP),U,1),VST=$P(@VFDPAT@(VLP),U,2)
 . I '$D(^VFD(21640.01,"C",DFN)) S @VFDREP@(VLP)=0 Q
 . S REC="",CNT=1 K LOOKUP F  S REC=$O(^VFD(21640.01,"C",DFN,REC)) Q:'REC  D
 . . S CODE=$$GET1^DIQ(21640.01,REC_",",.01) S LOOKUP(CNT)=CODE,CNT=CNT+1
 . S @VFDREP@(VLP)=0
 . D ISINTBL^VFDRPARL($NA(RET1),$NA(LOOKUP),"JC TABLE 3-150 MENTAL DISORDERS VALUE SET")
 . F VLP1=1:1:(CNT-1) I $G(RET1(VLP1))=1 S @VFDREP@(VLP)=1 Q
 Q
 ;
LOC(VFDREP,VFDST,VFDEND)  ; search for location of admission [ OBSTETRICS
 N ADM,CNT,DDM,DFN,CODE,LOOKUP,REC,RET,RET1,VAIP,VLP,VLP1,X,Y
 S VFDRET=$NA(^TMP("VFDDGPMU",$J)) K @VFDRET
 D ADMIT^VFDDGPMU(.VFDRET,VFDST,VFDEND) I '$D(VFDRET) S @VFDREP@(0)="-1^No Admissions found" Q
 S VFDP=0 F  S VFDP=$O(@VFDRET@(VFDP)) Q:'VFDP  D
 . S VFDV=0 F  S VFDV=$O(@VFDRET@(VFDP,VFDV)) Q:'VFDV  D
 . . S VFDDT=@VFDRET@(VFDP,VFDV)
 . . S DFN=VFDP K VAIP S VAIP("D")=VFDDT D IN5^VADPT S LOC=+$G(VAIP(13,4)) Q:'LOC
 . . N X S X=$$GET1^DIQ( 44,LOC_",",42,"E") S:X["ICU" @VFDREP@(VFDP,VFDV)=1 S:X["OBSTETRICS" @VFDREP@(VFDP,VFDV)=1 
 Q
 ;
STOP(VFDREP,VFDST,VFDEND)  ; search for Stop code [ MENTAL HEALTH
 N ADM,CNT,DDM,DFN,CODE,LOOKUP,REC,RET,RET1,VAIP,VLP,VLP1,X,Y
 S VFDRET=$NA(^TMP("VFDDGPMU",$J)) K @VFDRET
 D ADMIT^VFDDGPMU(.VFDRET,VFDST,VFDEND) I '$D(VFDRET) S @VFDREP@(0)="-1^No Admissions found" Q
 S VFDP=0 F  S VFDP=$O(@VFDRET@(VFDP)) Q:'VFDP  D
 . S VFDV=0 F  S VFDV=$O(@VFDRET@(VFDP,VFDV)) Q:'VFDV  D
 . . S VFDDT=@VFDRET@(VFDP,VFDV)
 . . S DFN=VFDP K VAIP S VAIP("D")=VFDDT D IN5^VADPT S LOC=+$G(VAIP(13,4)) Q:'LOC
 . . N X S X=$$GET1^DIQ( 44,LOC_",",8,"E") S:X["ICU" @VFDREP@(VFDP,VFDV)=1 S:X["MENTAL HEALTH" @VFDREP@(VFDP,VFDV)=1 
 Q
 ;
ICUSTAY(VFDREP,VFDST,VFDEND)  ; search for LOS in ICU
 N ADM,CNT,DDM,DFN,CODE,LOOKUP,REC,RET,RET1,VFADT,VAIP,VLP,VLP1,X,Y
 S VFDRET=$NA(^TMP("VFDRPARK",$J)) K @VFDRET
 D GET^VFDRPARL(VFDRET,VFDST,VFDEND,"AT") I '$D(VFDRET) S @VFDREP@(0)="-1^No Admissions found" Q
 S VFDP=0 F  S VFDP=$O(@VFDRET@(VFDP)) Q:'VFDP  D
 . S VFADT=$P($G(@VFDRET@(VFDP)),U,2)
 . S DFN=VFDP K VAIP S VAIP("E")=$P(@VFDRET@(VFDP),U,7) D IN5^VADPT S LOC=$G(VAIP(13,4)) Q:'LOC
 . N X S X=$G(VAIP(13,4)) D:X["ICU"  Q
 . . N CKIN,CKOUT S CKIN=+$G(VAIP(13,1)) S CKOUT=$S(+$G(VAIP(16,1)):+VAIP(16,1),+VAIP(17,1):+VAIP(17,1),1:$$NOW^XLFDT)
 . . I CKIN,CKOUT,$$FMDIFF^XLFDT(CKIN,CKOUT,1)>1 S @VFDREP@(VFDP,VFDV)=1 
 Q
 ;
