VFDRPARA ;DSS INC/AMC - VTE REPORTS ; 
 ;;2011.1.2;DSS,INC VXVISTA OPEN SOURCE;;28 Jan 2013;Build 153
 ;Copyright 1995-2013,Document Storage Systems Inc. All Rights Reserved
 ;
 Q
PRIPRV(VISIT) ;Identify the entry in the V PROVIDER file that is the primary provider for a given visit
 ;Returns V PROVIDER IEN ^ PROVIDER IEN ; PROVIDER NAME
 ;
 N VIEN,GET,IENS,FIL S VIEN=$$FIND1^DIC(9000010.06,,"Q",VISIT,"AD","I $P(^(0),U,4)=""P""")
 Q:'VIEN 0
 S FIL=9000010.06,IENS=VIEN_"," D GETS^DIQ(FIL,IENS,".01","IE","GET")
 Q:'$G(GET(FIL,IENS,.01,"I")) 0
 Q VIEN_U_$G(GET(FIL,IENS,.01,"I"))_";"_$G(GET(FIL,IENS,.01,"E"))
 ;
AGELOS(XX) ;
 ;X = do we check for less than 2 days LOS
 S XX=$G(XX)
 D GETPAT,LOADSCT
 I $G(VADM(4))<18 Q 1 ;patient under 18
 I 'X,LOS<2 Q 1 ;Length of stay less than 2 days
 I LOS>120 Q 1 ;length of stay greater than 120 days
 N CODE,Q
 S (Q,CODE)=0
 ;Check comfort measures
 F  S CODE=$O(^TMP("VFD-ARRA",$J,"CMFRT",CODE))  I $D(^TMP("VFD-PROC",$J,CODE)) S Q=1 Q
 Q:Q 1
 ;Check for clinical trial
 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"TRIAL",CODE)) Q:'CODE  I $D(^TMP("VFD-PROC",$J,CODE)) S Q=1 Q
 Q Q
 ;
VTE(RPT,STDT,ENDT) ;Entry point to produce VTE reportS
 S RPT=+$G(RPT) Q:RPT<1!(RPT>6) "-1^Invalid Input!"
 N AXY,VIST,LODT,VADM,ADMMOV,DCHMOV,ADMDT,DCHDT,X1,X2,X,LOS,RPTC,NUMER,DENOM,CPT,PROC,DISO,PRDT,EXCL,VTEDIAG,DFN,PRIPRV
 K ^TMP("VFD-ARRA",$J)
 S LODT=STDT-.9,ENDT=ENDT+.3,(NUMER,DENOM)=0
 I '$G(STDT)!'$G(ENDT) Q "-1^Invalid Input!"
 F II=1:1  S TABLE=$P($T(TABLES1+II),";",3) Q:TABLE=""  D LOADTBL(TABLE)
 D @("VTE"_RPT)
 K ^TMP("VFD-ARRA",$J)
 D CLNTMP
 Q AXY
VTE1 ;
 S X1=STDT,X2=-120 D C^%DTC S LODT=X-.9
 F  S LODT=$O(^AUPNVSIT("B",LODT)) Q:'LODT!(LODT>ENDT)  D  ;
 .K VADM
 .S VIEN=0 F  S VIEN=$O(^AUPNVSIT("B",LODT,VIEN)) Q:'VIEN  D  ;
 ..D CLNTMP
 ..Q:'$D(^DGPM("AVISIT",VIEN))
 ..S DFN=$$GET1^DIQ(9000010,VIEN,.05,"I"),PRIPRV=$$PRIPRV(VIEN)
 ..S ADMMOV=$$ADMMOV(VIEN) Q:'ADMMOV  S DCHMOV=$P(^DGPM(ADMMOV,0),U,17)
 ..Q:'DCHMOV
 ..S ADMDT=$P(^DGPM(ADMMOV,0),U),DCHDT=$P(^DGPM(DCHMOV,0),U)
 ..S X1=DCHDT,X2=ADMDT D ^%DTC S LOS=X
 ..S X1=ADMDT,X2=1 D C^%DTC S ADMPL1=X
 ..S ADMDT=ADMDT\1,ADMPL1=ADMPL1\1
 ..I DCHDT<STDT!(DCHDT>ENDT) Q
 ..S EXCL=0 D DENOM1,NUMER1:'EXCL
 S AXY=NUMER_U_DENOM_U_(NUMER/DENOM)
 Q
NUMER1 ;
 N CODE,DRUG,Q S Q=0
 ;Check procedures for VTE treatment 
 S CODE=0 F  S CODE=$O(^TMP("VFD-PROC",$J,CODE)) Q:'CODE  I $D(^TMP("VFD-ARRA",$J,"PROC",CODE)) S NUMER=NUMER+1,Q=1 Q
 Q:Q
 ;Check drugs for VTE treatment
 S DRUG=0 F  S DRUG=$O(^TMP("VFD-DRUG",$J,DRUG)) Q:'DRUG  I $D(^TMP("VFD-ARRA",$J,"MEDS",DRUG)) S NUMER=NUMER+1 Q
 Q
DENOM1 ;
 N CODE,Q S Q=0
 D LDMEDS
 S EXCL=$$AGELOS(0) Q:EXCL
 ;check admit loc for ICU, Behavioral Health or Obstetrics
 I $D(^TMP("VFD-ARRA",$J,"LOC",$P(^DGPM(ADMMOV,0),U,6))) S EXCL=1 Q
 ;Check for Stroke Diagnosis or VTE
 S CODE=0 F  S CODE=$O(^TMP("VFD-PROC",$J,CODE)) Q:'CODE  I $D(^TMP("VFD-ARRA",$J,"STK",CODE)) S Q=1 Q
 I Q S EXCL=1 Q
 S CODE=0 F  S CODE=$O(^TMP("VFD-PROC",$J,CODE)) Q:'CODE  I $D(^TMP("VFD-ARRA",$J,"PSYCH",CODE)) S Q=1 Q
 I Q S EXCL=1 Q
 S DENOM=DENOM+1
 Q
 ;
VTE2 ;
 F  S LODT=$O(^AUPNVSIT("B",LODT)) Q:'LODT!(LODT>ENDT)  D  ;
 .K VADM
 .S VIEN=0 F  S VIEN=$O(^AUPNVSIT("B",LODT,VIEN)) Q:'VIEN  D  ;
 ..D CLNTMP
 ..Q:'$D(^DGPM("AVISIT",VIEN))
 ..S DFN=$$GET1^DIQ(9000010,VIEN,.05,"I"),PRIPRV=$$PRIPRV(VIEN)
 ..S ADMMOV=$$ADMMOV(VIEN) Q:'ADMMOV  S DCHMOV=$P(^DGPM(ADMMOV,0),U,17)
 ..S ICUMOV=$$ICUMOV(ADMMOV) Q:'ICUMOV
 ..S ADMDT=$P(^DGPM(ADMMOV,0),U),DCHDT=$S(DCHMOV:$P(^DGPM(DCHMOV,0),U),1:DT)
 ..S X1=DCHDT,X2=ADMDT D ^%DTC S LOS=X
 ..S X1=ADMDT,X2=1 D C^%DTC S ADMPL1=X
 ..S ADMDT=ADMDT\1,ADMPL1=ADMPL1\1
 ..S EXCL=0 D DENOM2,NUMER2:'EXCL
 S AXY=NUMER_U_DENOM_U_(NUMER/DENOM)
 Q
 ;
ICUMOV(X) ;
 N MOV,LOC,Q S Q=0
 S MOV=0 F  S MOV=$O(^DGPM("CA",X,MOV)) Q:'MOV  S LOC=+$P(^DGPM(MOV,0),U,6) I LOC,$D(^TMP("VFD-ICU",$J,LOC)) S Q=MOV D  Q:Q
 .F  S MOV=$O(^DGPM("CA",X,MOV)) Q:'MOV  S LOC=+$P(^DGPM(MOV,0),U,6) I LOC,'$D(^TMP("VFD-ICU",$J,LOC)) S X1=$P(^DGPM(MOV,0),U),X2=$P(^DGPM(Q,0),U) D ^%DTC I X<2 S Q=0
 Q Q
DENOM2 ;
 N CODE,Q S Q=0
 D LDMEDS
 S EXCL=$$AGELOS(0) Q:EXCL
 ;check admit loc for Behavioral Health or Obstetrics
 I $D(^TMP("VFD-ARRA",$J,"LOC",$P(^DGPM(ADMMOV,0),U,6))) S EXCL=1 Q
 ;Check for Stroke Diagnosis or VTE
 S CODE=0 F  S CODE=$O(^TMP("VFD-PROC",$J,CODE)) Q:'CODE  I $D(^TMP("VFD-ARRA",$J,"STK",CODE)) S Q=1 Q
 I Q S EXCL=1 Q
 Q
 ;
NUMER2 ;
 N CODE,DRUG,Q S Q=0
 ;Check procedures for VTE treatment
 S CODE=0 F  S CODE=$O(^TMP("VFD-PROC",$J,CODE)) Q:'CODE  I $D(^TMP("VFD-ARRA",$J,"PROC",CODE)) S NUMER=NUMER+1,Q=1 Q
 Q:Q
 ;Check drugs for VTE treatment
 S DRUG=0 F  S DRUG=$O(^TMP("VFD-DRUG",$J,DRUG)) Q:'DRUG  I $D(^TMP("VFD-ARRA",$J,"MEDS",DRUG)) S NUMER=NUMER+1 Q
 Q
 ;
VTE3 ;
 F  S LODT=$O(^AUPNVSIT("B",LODT)) Q:'LODT!(LODT>ENDT)  D  ;
 .K VADM
 .S VIEN=0 F  S VIEN=$O(^AUPNVSIT("B",LODT,VIEN)) Q:'VIEN  D  ;
 ..D CLNTMP
 ..Q:'$D(^DGPM("AVISIT",VIEN))
 ..S DFN=$$GET1^DIQ(9000010,VIEN,.05,"I"),PRIPRV=$$PRIPRV(VIEN)
 ..S ADMMOV=$$ADMMOV(VIEN) Q:'ADMMOV  S DCHMOV=$P(^DGPM(ADMMOV,0),U,17)
 ..S ICUMOV=$$ICUMOV(ADMMOV) Q:'ICUMOV
 ..S ADMDT=$P(^DGPM(ADMMOV,0),U),DCHDT=$S(DCHMOV:$P(^DGPM(DCHMOV,0),U),1:DT)
 ..S X1=DCHDT,X2=ADMDT D ^%DTC S LOS=X
 ..D DENOM3,NUMER3:EXCL
 S AXY=NUMER_U_DENOM_U_(NUMER/DENOM)
 Q
DENOM3 ;
 N CODE,Q S Q=0
 D LDMEDS,LDRXS
 S EXCL=$$AGELOS(1) Q:EXCL
 ;Check for warfarin in the hospital
 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"WARMEDS",CODE)) Q:'CODE  Q:$D(^TMP("VFD-DRUG",$J,CODE))
 I 'CODE S EXCL=1 Q
 ;Check for warfarin at discharge
 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"WARMEDS",CODE)) Q:'CODE  Q:$D(^TMP("VFD-RXS",$J,CODE))
 I 'CODE S EXCL=1 Q
 ;check for VTE diagnostic testing
 S CODE=0 F  S CODE=$O(^TMP("VFD-PROC",$J,CODE)) Q:'CODE  Q:$D(^TMP("VFD-ARRA",$J,"DIAGTST",CODE))
 I 'CODE S EXCL=1 Q
 S DENOM=DENOM+1
 Q
 ;
NUMER3 ;
 N INR,CODE,Q,DRI,X1,X2,LAB,RSLT,DAYS  S (CODE,Q)=0,INR=$O(^LAB(60,"B","INR",0))
 D LDRSLT
 ;get the days on both warfarin and anticoagulation meds
 S DAYS=$$TWOMEDS,RSLT=$O(^TMP("VFD-LABS",$J,0)),RSLT=^(RSLT),RDT=9999999-$P($P(RSLT,";",3),"."),RSLT=+^LR($P(RSLT,";"),$P(RSLT,";",2),$P(RSLT,";",3),$P(RSLT,";",4))
 I DAYS>4,RSLT'<2,RDT'>$P(DAYS,U,3) S NUMER=NUMER+1 Q  ;5 or more, result >= 2 before stopping meds
 I DAYS>4,RSLT<2,$$DCHWRX S NUMER=NUMER+1 Q  ;5 or more, result < 2 sent home with meds
 I DAYS<5,$$DCHWRX S NUMER=NUMER+1 Q  ;less than 5 days and sent with meds
 Q
 ;
DCHWRX() ;Discharged with warfarin & anticoagulins
 N WAR,ANT
 S WAR=0 F  S WAR=$O(^TMP("VFD-ARRA",$J,"WARMEDS",WAR)) Q:'WAR  Q:$D(^TMP("VFD-RXS",$J,WAR))
 S ANT=0 F  S ANT=$O(^TMP("VFD-ARRA",$J,"ACGMEDS",ANT)) Q:'ANT  Q:$D(^TMP("VFD-RXS",$J,ANT))
 Q ANT&WAR
LDRSLT ;
 N LAB,INDX S INDX=$NA(^PXRMINDX(63,"PI",DFN,INR))
 F  S INDX=$Q(@INDX) Q:$QS(INDX,3)'=DFN!($QS(INDX,4)'=INR)  I $$GOODDT($QS(INDX,5),ADMDT,DCHDT) S LAB=$QS(INDX,6),^TMP("VFD-LABS",$J,$P(LAB,";",4))=LAB
 Q
TWOMEDS ;
 N WARF,ANTG,WAR,ANT,WSTRT,WSTOP,ASTRT,ASTOP,WARNG,ANTRNG,X1,X2
 S WARF=0 F  S WARF=$O(^TMP("VFD-ARRA",$J,"WARMEDS",WARF)) Q:'WARF  I $D(^TMP("VFD-DRUG",$J,WARF)) S WAR=$O(^(WARF,0)),WAR=^(WAR) D  Q:ANTG
 .S WSTRT=$P(WAR,U,3),WSTOP=$P(WAR,U,4),X2=WSTRT,X1=WSTOP D ^%DTC S WARNG=X
 .S ANTG=0 F  S ANTG=$O(^TMP("VFD-ARRA",$J,"ACGMEDS",ANTG)) Q:'ANTG  I $D(^TMP("VFD-DRUG",$J,ANTG)) S ANT=$O(^(ANTG,0)),ANT=^(ANT) D  Q
 ..S ASTRT=$P(ANT,U,3),ASTOP=$P(ANT,U,4),X2=ASTRT,X1=ASTOP D ^%DTC S ANTRNG=X
 ;Return the shortest day range
 I WARNG<ANTRNG Q WARNG_U_WSTRT_U_WSTOP
 Q ANTRNG_U_ASTRT_U_ASTOP
VTE4 ;
 S X1=STDT,X2=-120 D C^%DTC S LODT=X-.9
 F  S LODT=$O(^AUPNVSIT("B",LODT)) Q:'LODT!(LODT>ENDT)  D  ;
 .K VADM
 .S VIEN=0 F  S VIEN=$O(^AUPNVSIT("B",LODT,VIEN)) Q:'VIEN  D  ;
 ..D CLNTMP
 ..Q:'$D(^DGPM("AVISIT",VIEN))
 ..S DFN=$$GET1^DIQ(9000010,VIEN,.05,"I"),PRIPRV=$$PRIPRV(VIEN)
 ..S ADMMOV=$$ADMMOV(VIEN) Q:'ADMMOV  S DCHMOV=$P(^DGPM(ADMMOV,0),U,17)
 ..S ADMDT=$P(^DGPM(ADMMOV,0),U),DCHDT=$S(DCHMOV:$P(^DGPM(DCHMOV,0),U),1:DT)
 ..S X1=DCHDT,X2=ADMDT D ^%DTC S LOS=X
 ..I DCHDT<STDT!(DCHDT>ENDT) Q
 ..S EXCL=0 D DENOM4,NUMER4:'EXCL
 S AXY=NUMER_U_DENOM_U_(NUMER/DENOM)
 Q
DENOM4 ;
 N CODE,Q S Q=0
 D LDLABS,LDMEDS
 S EXCL=$$AGELOS(0) Q:EXCL
 ;Exclude if no warfarin meds
 S CODE=0 F  S CODE=$O(^TMP("VFD-DRUG",$J,CODE)) Q:'CODE  Q:$D(^TMP("VFD-ARRA",$J,"WARMEDS",CODE))
 I 'CODE S EXCL=1 Q
 ;Exclude if no VTE diagnostic testing
 S CODE=0 F  S CODE=$O(^TMP("VFD-PROC",$J,CODE)) Q:'CODE  Q:$D(^TMP("VFD-ARRA",$J,"DIAGTST",CODE))
 I 'CODE S EXCL=1 Q
 S DENOM=DENOM+1
 Q
 ;
LDLABS ;
 N LAB,INDX S INDX=$NA(^PXRMINDX(63,"PI",DFN))
 F  S INDX=$Q(@INDX) Q:$QS(INDX,3)'=DFN  I $$GOODDT($QS(INDX,5),ADMDT,DCHDT) S LAB=$QS(INDX,6),^TMP("VFD-LABS",$J,$P(LAB,";",4))=LAB
 Q
 ;
NUMER4 ;
 N CODE,Q
 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"TSTRSLT",CODE)) Q:'CODE  Q:$D(^TMP("VFD-LABS",$J,CODE))
 Q:'CODE
 S NUMER=NUMER+1
 Q
 ;
VTE5 ;
 F  S LODT=$O(^AUPNVSIT("B",LODT)) Q:'LODT!(LODT>ENDT)  D  ;
 .K VADM
 .S VIEN=0 F  S VIEN=$O(^AUPNVSIT("B",LODT,VIEN)) Q:'VIEN  D  ;
 ..D CLNTMP
 ..Q:'$D(^DGPM("AVISIT",VIEN))
 ..S DFN=$$GET1^DIQ(9000010,VIEN,.05,"I"),PRIPRV=$$PRIPRV(VIEN)
 ..S ADMMOV=$$ADMMOV(VIEN) Q:'ADMMOV  S DCHMOV=$P(^DGPM(ADMMOV,0),U,17)
 ..S ADMDT=$P(^DGPM(ADMMOV,0),U),DCHDT=$S(DCHMOV:$P(^DGPM(DCHMOV,0),U),1:DT)
 ..S X1=DCHDT,X2=ADMDT D ^%DTC S LOS=X
 ..S EXCL=0 D DENOM5,NUMER5:'EXCL
 S AXY=NUMER_U_DENOM_U_(NUMER/DENOM)
 Q
DENOM5 ;
 N CODE,Q,CD S Q=0
 D LDRXS
 S EXCL=$$AGELOS(0) Q:EXCL
 ;Check for VTE diagnosis 
 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"PROC",CODE)) Q:'CODE  Q:$D(^TMP("VFD-PROC",$J,CODE))
 I 'CODE S EXCL=1 Q
 ;Check for warfarin meds
 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"WARMEDS",CODE)) Q:'CODE  Q:$D(^TMP("VFD-RXS",$J,CODE))
 I 'CODE S EXCL=1 Q  ;No warf meds don't count
 S DENOM=DENOM+1
 Q
 ;
NUMER5 ;
 N CODE,CD
 F CD=1:1:4 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"EDU"_CD,CODE)) Q:'CODE  I $D(^TMP("VFD-PROC",$J,CODE)) S $P(EDU,U,CD)=1 Q
 Q:EDU'="1^1^1^1"
 S NUMER=NUMER+1
 Q
 ;
LDRXS ;
 N RX,RXDR,RXDT,DRUG,RXNORM
 S RX=0 F  S RX=$O(^PS(55,DFN,"P",RX)) Q:'RX  S RXDT=$P(^PSRX(RX,0),U,13) D:RXDT=DCHDT  ;
 .S DRUG=$P(^PSRX(RX,0),U,6),RXNORM=$$RXNORM(DRUG,5),^TMP("VFD-RXS",$J,RXNORM,RX)=""
 Q
 ;
VTE6 ;
 F  S LODT=$O(^AUPNVSIT("B",LODT)) Q:'LODT!(LODT>ENDT)  D  ;
 .K VADM
 .S VIEN=0 F  S VIEN=$O(^AUPNVSIT("B",LODT,VIEN)) Q:'VIEN  D  ;
 ..D CLNTMP
 ..Q:'$D(^DGPM("AVISIT",VIEN))
 ..S DFN=$$GET1^DIQ(9000010,VIEN,.05,"I"),PRIPRV=$$PRIPRV(VIEN)
 ..S ADMMOV=$$ADMMOV(VIEN) Q:'ADMMOV  S DCHMOV=$P(^DGPM(ADMMOV,0),U,17)
 ..S ADMDT=$P(^DGPM(ADMMOV,0),U),DCHDT=$S(DCHMOV:$P(^DGPM(DCHMOV,0),U),1:DT)
 ..S X1=DCHDT,X2=ADMDT D ^%DTC S LOS=X
 ..Q:$$VTEONADM
 ..S VTEDIAG=$$VTEONDT Q:'VTEDIAG
 ..S X1=VTEDIAG,X2=-1 D C^%DTC S VTEMNS1=X
 ..D DENOM6,NUMER6:'EXCL
 S AXY=NUMER_U_DENOM_U_(NUMER/DENOM)
 Q
 ;
VTEONADM() ;Check for VTE on admission if so don't count
 N CODE,CD,Q,EVDT
 S (Q,CODE)=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"PROC",CODE)) Q:'CODE  I $D(^TMP("VFD-PROC",$J,CODE)) D  Q:Q
 .S CD=0 F  S CD=$O(^TMP("VFD-PROC",$J,CODE,CD)) Q:'CD  S EVDT=^(CD) I EVDT=ADMDT S Q=1 Q
 Q Q
 ;
VTEONDT() ;Return the first date VTE diagnosed
 N CODE,CD,Q,EVDT S EVDT=""
 S (Q,CODE)=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"PROC",CODE)) Q:'CODE  I $D(^TMP("VFD-PROC",$J,CODE)) S EVDT=$O(^(CODE,0)),EVDT=^(EVDT) Q
 Q EVDT
 ;
DENOM6 ;
 N CODE,Q S Q=0
 D LDMEDS
 S EXCL=$$AGELOS(1) Q:EXCL
 ;Check for VTE testing
 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"DIAGTST",CODE)) Q:'CODE  Q:$D(^TMP("VFD-PROC",$J,CODE))
 I CODE S EXCL=1 Q
 ;Check for Diagnosis of VTE
 S CODE=0 F  S CODE=$O(^TMP("VFD-ARRA",$J,"PROC",CODE)) Q:'CODE  Q:$D(^TMP("VFD-PROC",$J,CODE))
 I 'CODE S EXCL=1 Q
 S DENOM=DENOM+1
 Q
 ;
NUMER6 ;
 N CODE,Q S Q=0
 F  S CODE=$O(^TMP("VFD-PROC",$J,CODE)) Q:'CODE  Q:$D(^TMP("VFD-ARRA",$J,"MECHDEV",CODE))
 I CODE S NUMER=NUMER+1 Q
 S CODE=0 F  S CODE=$O(^TMP("VFD-DRUG",$J,CODE)) Q:'CODE  Q:$D(^TMP("VFD-ARRA",$J,"MEDS",CODE))
 I CODE S NUMER=NUMER+1 Q
 Q
 ;
GETPAT ;
 S DFN=$P(^AUPNVSIT(VIEN,0),U,5)
 D DEM^VADPT
 Q
ADMMOV(X) ;
 N MOV,YY S MOV=0,YY=""
 Q:'$G(X)
 F  S MOV=$O(^DGPM("AVISIT",X,MOV)) Q:'MOV  I $P(^DGPM(MOV,0),U,14)=MOV S YY=MOV Q
 Q YY
LOADSCT ;
 K ^TMP("DILIST",$J)
 N CODE,II,EVDT
 D FIND^DIC(21640.01,,".01I;1201I","QX",VIEN,,"AD")
 S II=0 F  S II=$O(^TMP("DILIST",$J,VIEN,"ID",II)) Q:'II  S CODE=+$G(^(II,.01)),EVDT=$S($G(^(1201)):^(1201),1:ADMDT),^TMP("VFD-PROC",$J,CODE,II)=EVDT
 K ^TMP("DILIST",$J)
 Q
LDMEDS ;
 N UDI,UDDR,DRDT,ORID,DRUG,DRI,START,STOP,RXNORM
 S UDI=0 F  S UDI=$O(^PS(55,DFN,5,UDI)) Q:'UDI  S DRDT=$P(^(UDI,0),U,14)\1,ORID=UDI_"U" D:$$GOODDT(DRDT,ADMDT,ADMPL1)
 .S START=$P($G(^PS(55,DFN,5,UDI,2)),U,2),STOP=$P($G(^(2)),U,4)
 .S:'START START=DRDT S:'STOP STOP=DT
 .S DRI=0 S DRI=$O(^PS(55,DFN,5,UDI,1,DRI)) Q:'DRI  S DRUG=+$G(^(DRI,0)),RXNORM=$$RXNORM(DRUG,5) D  ;
 ..S ^TMP("VFD-DRUG",$J,RXNORM,DRI)=U_DRDT_U_START_U_STOP
 ..S BCDT=0 F  S BCDT=$O(^PSB(53.79,"AORDX",DFN,ORID,BCDT)) Q:'BCDT  S BCMA=0 F  S BCMA=$O(^PSB(53.79,"AORDX",DFN,ORID,BCDT,BCMA)) Q:'BCMA  D ;
 ...S:$P(^PSB(53.79,BCMA,0),U,9)="R" $P(^TMP("VFD-DRUG",$J,RXNORM,DRI),U)=1
 Q
LOADTBL(TT) ;
 N I,J,N,TBL,SUB,VAL
 S N="",TBL=$P(TT,U),SUB=$P(TT,U,2)
 F  S N=$O(^VFD(21631,"B",N)) Q:N=""  I N[TBL S J=$O(^(N,0)) D  Q
 .S I=0 F  S I=$O(^VFD(21631,J,1,I)) Q:'I  S VAL=$S($P(^VFD(21631,J,1,I,0),U,4):$P(^(0),U,4),1:$P(^(0),U)),^TMP("VFD-ARRA",$J,SUB,VAL)=""
 Q
 ;
GOODDT(X,Y,Z) ;
 I X'<Y,X'>Z Q 1
 Q 0
 ;
CLNTMP ;Clean out ^TMP for each visit
 N VFD S VFD="VFD-ARRA" F  S VFD=$O(^TMP(VFD)) Q:VFD=""!($E(VFD,1,4)'="VFD-")  K ^TMP(VFD,$J)
 Q
 ;
TABLES1 ;
 ;;3-249^MEDS
 ;;3-27^STK
 ;;3-30^STK
 ;;3-51^LOC
 ;;3-240^PROC
 ;;3-120^LOC
 ;;3-201^PROC
 ;;3-150^PSYCH
 ;;3-159^LOC
 ;;3-60^TRIAL
 ;;3-63^CMFRT
 ;;
TABLES2 ;
 ;;3-249^MEDS
 ;;3-27^STK
 ;;3-30^STK
 ;;3-51^LOC
 ;;3-240^PROC
 ;;3-120^ICU
 ;;3-159^LOC
 ;;3-60^TRIAL
 ;;3-63^CMFRT
 ;;
TABLES3 ;
 ;;3-264^ACGMEDS
 ;;3-270^WARMEDS
 ;;3-240^PROC
 ;;3-60^TRIAL
 ;;3-63^CMFRT
 ;;
TABLES4 ;
 ;;3-240^PROC
 ;;3-267^WARMEDS
 ;;3-243^DIAGTST
 ;;3-186^TSTRSLT
 ;;3-60^TRIAL
 ;;3-63^CMFRT
 ;;
TABLES5 ;
 ;;3-270^WARMEDS
 ;;3-240^PROC
 ;;3-87^EDU1
 ;;3-75^EDU2
 ;;3-78^EDU3
 ;;3-81^EDU4
 ;;3-69^DCHTYP
 ;;3-60^TRIAL
 ;;3-63^CMFRT
 ;;
TABLES6 ;
 ;;3-240^PROC
 ;;3-243^DIAGTST
 ;;3-252^MECHDEV
 ;;3-249^MEDS
 ;;3-60^TRIAL
 ;;3-63^CMFRT
 ;;
 Q
RXNORM(IEN,FIL) ;API - extrinsic function to return the RXNORM code related to a drug
 ;Input parameters
 ;    IEN - Internal Entry Number to file specified by parameter 2 (Required)
 ;    FIL - File Indicator (1 - Order,5 - Drug) (Required)
 ;    
 ;Return values
 ;    -1 - Missing input or IEN not found in file specified
 ;    "" - No RXNORM value was found in file 50.68
 ;    NNNNNNN - RXNORM number
 N DRUG,DRI,MSG,IENS S MSG="",DRUG=0
 I '$G(IEN)!'$G(FIL) Q -1
 D:FIL=1  I 'DRUG Q MSG
 .S (DRUG,DRI)=0 F  S DRI=$O(^OR(100,IEN,.1,DRI)) Q:'DRI  S DRUG=+$G(^(DRI,0)),DRUG=$$GET1^DIQ(101.43,DRUG,2,"E") I DRUG[";99PSP" S DRUG=+DRUG Q
 S:FIL=1 IEN=DRUG
 S IENS=$$GET1^DIQ(50,IEN,22,"I")
 Q:'IENS -1
 Q $$GET1^DIQ(50.68,IENS,21601.01,"I")
