SROESXA ;BIR/ADM - SURGERY E-SIG UTILITY ; [ 03/02/04  09:23 AM ]
 ;;3.0; Surgery ;**100**;24 Jun 93
 ;
 ;** NOTICE: This routine is part of an implementation of a nationally
 ;**         controlled procedure.  Local modifications to this routine
 ;**         are prohibited.
 ;
 ; Reference to $$WHATITLE^TIUPUTU supported by DBIA #3351
 ; Reference to DELETE^TIUSRVP supported by DBIA #3535
 ; Reference to MAKE^TIUSRVP supported by DBIA #3535
 ; Reference to UPDATE^TIUSRVP supported by DBIA #3535
 ;
 Q
AESA ; set logic for AESA cross-reference
 N SRDIV,SRINUSE,SRTN,ZTDESC,ZTRTN,ZTIO,ZTDTH,ZTSAVE,ZTSK
 S SRTN=DA I $P($G(^SRF(SRTN,"NON")),"^")="Y" Q
 Q:'$$INUSE(SRTN)
 S ZTDESC="Surgery Anesthesia Report Stub",ZTRTN="AR^SROESXA",ZTIO="",ZTDTH=$H,ZTSAVE("SRTN")="" D ^%ZTLOAD
 Q
INUSE(SRTN) ; is anesthesia report in use at this division?
 N SRDIV,SRINUSE
 S SRINUSE=0,SRDIV=$$SITE^SROUTL0(SRTN) S:SRDIV SRINUSE=$P($G(^SRO(133,SRDIV,.1)),"^",4)
 Q SRINUSE
AR ; create stub entry in TIU for anesthesia report
 N DFN,DIC,SR0,SRATT,SRAY,SRD,SRDOC,SRLOC,SRPRIN,SRTIU,SRV,SRX,TITLE,VDT,VLOC,VSTR,VSIT,X,Y
 I '$P($G(^SRF(SRTN,.2)),"^",4) D END Q
 S SRD=$P($G(^SRF(SRTN,"TIU")),"^",4) I SRD D END Q
 S SRX=$$WHATITLE^TIUPUTU("ANESTHESIA REPORT"),TITLE=$P(SRX,"^") I 'TITLE Q
 S SRDIV=$$SITE^SROUTL0(SRTN),SR0=^SRF(SRTN,0),DFN=$P(SR0,"^") D LOC
 S X=$G(^SRF(SRTN,.3)),SRPRIN=$P(X,"^"),SRATT=$P(X,"^",4)
 S SRAY(.02)=DFN,SRAY(.05)=1,SRAY(1205)=SRLOC,SRAY(1301)=$P(SR0,"^",9),SRAY(1405)=SRTN_";SRF(",SRAY(1701)="Case #: "_SRTN
 S:SRPRIN (SRAY(1202),SRAY(1204))=SRPRIN S:SRATT (SRAY(1208),SRAY(1209))=SRATT
 S X=$G(^SRF(SRTN,.2)),SRAY(.07)=$P(X,"^",10),SRAY(.08)=$P(X,"^",12)
 S VDT=$P(SR0,"^",9),VSIT=$P(SR0,"^",15),VLOC=""
 I 'VSIT S VLOC=SRLOC
 I VLOC S SRAY(1211)=VLOC,VSTR=VLOC_";"_VDT_";"_$S(+$D(^DPT(DFN,.1)):"I",1:"E")
 D MAKE^TIUSRVP(.SRTIU,DFN,TITLE,VDT,VLOC,VSIT,.SRAY,$G(VSTR),1,1) I SRTIU D
 .F  L +^SRF("TIU"_SRTN):5 I $T S $P(^SRF(SRTN,"TIU"),"^",4)=SRTIU L -^SRF("TIU"_SRTN) Q
 .D ALERT
END S ZTREQ="@"
 Q
LOC ; get patient location
 N SRDEF,SROR,SRT,SRWARD,VAIP,X,Y
 S VAIP("D")=$P(SR0,"^",9) D IN5^VADPT
 S SRWARD=$P(VAIP(5),"^"),(SRDEF,SRLOC)="",SROR=$P(SR0,"^",2) I SROR S SROR=$P(^SRS(SROR,0),"^")
 I SRWARD K DA,DIC,DIQ,DR S DA=SRWARD,DIC=42,DR="44",DIQ="SRT",DIQ(0)="I" D EN^DIQ1 K DA,DIC,DIQ,DR S SRLOC=$G(SRT(42,SRWARD,44,"I"))
 S SRDEF=$P($G(^SRO(133,SRDIV,0)),"^",23)
 I SRDEF="" S X="SURGERY OP REPORT NON-COUNT",DIC(0)="M",DIC="^SC(" D ^DIC K DIC I +Y>0 S SRDEF=+Y
 S SRLOC=$S(SRLOC:SRLOC,SRDEF:SRDEF,SROR:SROR,1:"")
 Q
ALERT ; issue alert to anesthesia personnel
 S XQAID="SRAR-"_SRTN,XQAKILL=0 D DELETEA^XQALERT K XQAID,XQAKILL
 N X,Y,Z S X=$G(^SRF(SRTN,.3)) F Y=1,4 S Z=$P(X,"^",Y) I Z S XQA(Z)=""
 S DFN=$P(^SRF(SRTN,0),"^") D DEM^VADPT S SRNM=$E($P(VADM(1),"^"),1,15)_" ("_$E($P(VADM(1),"^"))_VA("BID")_"): "
 S SRLAB=SRNM_$E($P(^SRF(SRTN,"OP"),"^"),1,25)_" (ANES REPORT ready to complete)"
 S XQAMSG=SRLAB,XQAROU="ACTION^SROESXA",XQAID="SRAR-"_SRTN,XQADATA=SRTN D SETUP^XQALERT
 Q
STATUS(SRSTAT) ; update status
 K SRAY S SRAY(.05)=SRSTAT D UPDATE^TIUSRVP(.SRDOC,SRTIU,.SRAY,1)
 Q
KAESA ; kill logic for the AESA cross-reference
 N SRTN,ZTDESC,ZTRTN,ZTIO,ZTDTH,ZTSAVE,ZTSK S SRTN=DA
 S ZTDESC="Surgery Anesthesia Report Delete Stub",ZTRTN="KSTUB^SROESXA",ZTIO="",ZTDTH=$H,ZTSAVE("SRTN")="" D ^%ZTLOAD
 Q
KSTUB ; delete stubs in TIU for unsigned anesthesia report
 N SRERR,SRODA,SRTIU
 S SRODA=SRTN,SRTIU=$P($G(^SRF(SRTN,"TIU")),"^",4) I SRTIU D
 .D STATUS(5)
 .D DELETE^TIUSRVP(.SRERR,SRTIU,,1) I 'SRERR D
 ..F  L +^SRF("TIU"_SRTN):5 I $T S $P(^SRF(SRTN,"TIU"),"^",4)="" L -^SRF("TIU"_SRTN) Q
 D DELRT,END
 Q
ACTION ; action alert
 N SRTN,SRALRT K XQAKILL S SRTN=XQADATA,SRALRT=1 D ^SROARPT
 S SRTIU=$P($G(^SRF(SRTN,"TIU")),"^",4) I SRTIU,$$STATUS^SROESUTL(SRTIU)=7 D DELRT
 Q
DELRT N XQAID,XQAKILL S XQAID="SRAR-"_SRTN,XQAKILL=0 D DELETEA^XQALERT
 Q
