SROESX ;BIR/ADM - SURGERY E-SIG UTILITY ; [ 06/16/04  09:21 AM ]
 ;;3.0; Surgery ;**100,129**;24 Jun 93
 ;** NOTICE: This routine is part of an implementation of a nationally
 ;**         controlled procedure. Local modifications to this routine
 ;**         are prohibited.
 ;
 ; Reference to $$WHATITLE^TIUPUTU supported by DBIA #3351
 ; Reference to DELETE^TIUSRVP supported by DBIA #3535
 ; Reference to MAKE^TIUSRVP supported by DBIA #3535
 ; Reference to UPDATE^TIUSRVP supported by DBIA #3535
 ; Reference to $$CANDEL^TIUSRVP1 supported by DBIA #4175
 ;
 Q
AES ; set logic for AES cross-reference
 N SRTN,ZTDESC,ZTRTN,ZTIO,ZTDTH,ZTSAVE,ZTSK
 S SRTN=DA I $P($G(^SRF(SRTN,"NON")),"^")="Y" Q
 S ZTDESC="Surgery Nurse Intraop Report Stub",ZTRTN="NR^SROESX",ZTIO="",ZTDTH=$H,ZTSAVE("SRTN")="" D ^%ZTLOAD
 S ZTDESC="Surgery Operation Report Stub",ZTRTN="OR^SROESX",ZTIO="",ZTDTH=$H,ZTSAVE("SRTN")="" D ^%ZTLOAD
 Q
NR ; create stub entry in TIU for nurse intraop report
 N DFN,DIC,SR0,SRAY,SRCIRC,SRD,SRDOC,SRLOC,SRRN,SRTIU,SRV,SRX,TITLE,VDT,VLOC,VSIT,VSTR,X,Y
 I '$P($G(^SRF(SRTN,.2)),"^",12) D END Q
 S SRD=$P($G(^SRF(SRTN,"TIU")),"^",2) I SRD D END Q
 S SRX=$$WHATITLE^TIUPUTU("NURSE INTRAOPERATIVE REPORT"),TITLE=$P(SRX,"^") I 'TITLE Q
 S SRDIV=$$SITE^SROUTL0(SRTN),SR0=^SRF(SRTN,0),DFN=$P(SR0,"^") D LOC
 S SRAY(.02)=DFN,SRAY(.05)=1,SRAY(1205)=SRLOC,SRAY(1301)=$P(SR0,"^",9),SRAY(1405)=SRTN_";SRF(",SRAY(1701)="Case #: "_SRTN
 S X=$G(^SRF(SRTN,.2)),SRAY(.07)=$P(X,"^",10),SRAY(.08)=$P(X,"^",12)
 S VDT=$P(SR0,"^",9),VSIT=$P(SR0,"^",15),VLOC=""
 I 'VSIT S VLOC=SRLOC
 I VLOC S SRAY(1211)=VLOC,VSTR=VLOC_";"_VDT_";"_$S(+$D(^DPT(DFN,.1)):"I",1:"E")
 S SRCIRC="",SRRN=$O(^SRF(SRTN,19,0)) S:SRRN SRCIRC=$P($G(^SRF(SRTN,19,SRRN,0)),"^") S (SRAY(1202),SRAY(1204))=SRCIRC
 D MAKE^TIUSRVP(.SRTIU,DFN,TITLE,VDT,VLOC,VSIT,.SRAY,$G(VSTR),1,1) I SRTIU D
 .F  L +^SRF("TIU"_SRTN):5 I $T S $P(^SRF(SRTN,"TIU"),"^",2)=SRTIU L -^SRF("TIU"_SRTN) Q
 .D ALERT
END I $D(ZTQUEUED) S ZTREQ="@"
 Q
LOC ; get patient location
 N SRDEF,SROR,SRT,SRWARD,VAIP,X,Y
 S VAIP("D")=$P(SR0,"^",9) D IN5^VADPT
 S (SRDEF,SRLOC)="",SRWARD=$P(VAIP(5),"^"),SROR=$P(SR0,"^",2) I SROR S SROR=$P(^SRS(SROR,0),"^")
 I SRWARD K DA,DIC,DIQ,DR S DA=SRWARD,DIC=42,DR="44",DIQ="SRT",DIQ(0)="I" D EN^DIQ1 K DA,DIC,DIQ,DR S SRLOC=$G(SRT(42,SRWARD,44,"I"))
 S SRDEF=$P($G(^SRO(133,SRDIV,0)),"^",23)
 I SRDEF="" S X="SURGERY OP REPORT NON-COUNT",DIC(0)="M",DIC="^SC(" D ^DIC K DIC I +Y>0 S SRDEF=+Y
 S SRLOC=$S(SRLOC:SRLOC,SRDEF:SRDEF,SROR:SROR,1:"")
 Q
ALERT ; issue alert to circulating nurse(s)
 S XQAID="SRNIR-"_SRTN,XQAKILL=0 D DELETEA^XQALERT K XQAID,XQAKILL
 N DFN,SRNM,SRRN,SRX S SRRN=0 F  S SRRN=$O(^SRF(SRTN,19,SRRN)) Q:'SRRN  S SRX=$P($G(^SRF(SRTN,19,SRRN,0)),"^") I SRX S XQA(SRX)=""
 I '$D(XQA) S XQA(DUZ)=""
 S DFN=$P(^SRF(SRTN,0),"^") D DEM^VADPT S SRNM=$E($P(VADM(1),"^"),1,15)_" ("_$E($P(VADM(1),"^"))_VA("BID")_"): "
 S SRLAB=SRNM_$E($P(^SRF(SRTN,"OP"),"^"),1,25)_" (NIR ready to complete)"
 S XQAMSG=SRLAB,XQAROU="ACTION^SROESX",XQAID="SRNIR-"_SRTN,XQADATA=SRTN D SETUP^XQALERT
 Q
STATUS(SRSTAT) ; update status
 K SRAY S SRAY(.05)=SRSTAT D UPDATE^TIUSRVP(.SRDOC,SRTIU,.SRAY,1)
 Q
OR ; create stub entry in TIU for Operation Report
 N DFN,DIC,SR0,SRACODE,SRATT,SRAY,SRD,SRDIV,SRDOC,SRLOC,SRSURG,SRTIU,SRV,SRX,TITLE,VDT,VLOC,VSIT,VSTR,X,Y
 I '$P($G(^SRF(SRTN,.2)),"^",12) D END Q
 S SRD=$P($G(^SRF(SRTN,"TIU")),"^") I SRD D END Q
 S SRX=$$WHATITLE^TIUPUTU("OPERATION REPORT"),TITLE=$P(SRX,"^") I 'TITLE Q
 S SRDIV=$$SITE^SROUTL0(SRTN),SR0=^SRF(SRTN,0),DFN=$P(SR0,"^") D LOC
 S X=$G(^SRF(SRTN,.1)),SRATT=$P(X,"^",13),SRSURG=$P(X,"^",4),SRACODE=$P(X,"^",10)
 I 'SRATT D
 .I "159"[SRACODE S SRATT=SRSURG Q
 .I SRDIV,'$P(^SRO(133,SRDIV,0),"^",19) S SRATT=SRSURG
 S SRAY(.02)=DFN,SRAY(.05)=1,(SRAY(1202),SRAY(1204))=SRSURG,SRAY(1205)=SRLOC,(SRAY(1208),SRAY(1209))=SRATT,SRAY(1301)=$P(SR0,"^",9),SRAY(1405)=SRTN_";SRF(",SRAY(1701)="Case #: "_SRTN
 S X=$G(^SRF(SRTN,.2)),SRAY(.07)=$P(X,"^",10),SRAY(.08)=$P(X,"^",12)
 S VDT=$P(SR0,"^",9),VSIT=$P(SR0,"^",15),VLOC=""
 I 'VSIT S VLOC=SRLOC
 I VLOC S SRAY(1211)=VLOC,VSTR=VLOC_";"_VDT_";"_$S(+$D(^DPT(DFN,.1)):"I",1:"E")
 D MAKE^TIUSRVP(.SRTIU,DFN,TITLE,VDT,VLOC,VSIT,.SRAY,$G(VSTR),1,1) I SRTIU D
 .F  L +^SRF("TIU"_SRTN):5 I $T S $P(^SRF(SRTN,"TIU"),"^")=SRTIU L -^SRF("TIU"_SRTN) Q
 D END
 Q
KAES ; kill logic for the AES cross-reference
 N SRTN,ZTDESC,ZTRTN,ZTIO,ZTDTH,ZTSAVE,ZTSK S SRTN=DA
 F SRI=1,2 S ZTDESC="Surgery "_$S(SRI=2:"Nurse Intraop",1:"Op")_" Report Delete Stub",ZTRTN="KSTUB^SROESX",ZTIO="",ZTDTH=$H,(ZTSAVE("SRTN"),ZTSAVE("SRI"))="" D ^%ZTLOAD
 Q
KSTUB ; delete stubs in TIU for unsigned nurse intraop & op reports
 N SRERR,SRODA,SRTIU
 S SRODA=SRTN,SRTIU=$P($G(^SRF(SRTN,"TIU")),"^",SRI) I SRTIU D
 .D STATUS(5)
 .D DELETE^TIUSRVP(.SRERR,SRTIU,,1) I 'SRERR D
 ..F  L +^SRF("TIU"_SRTN):5 I $T S $P(^SRF(SRTN,"TIU"),"^",SRI)="" L -^SRF("TIU"_SRTN) Q
 D DELRT,END
 Q
ACTION ; alert action
 N SRALRT,SRTN K XQAKILL S SRTN=XQADATA,SRALRT=1 D ^SRONIN
 S SRTIU=$P($G(^SRF(SRTN,"TIU")),"^",2) I SRTIU,$$STATUS^SROESUTL(SRTIU)=7 D DELRT
 Q
DELRT N XQAID,XQAKILL S XQAID="SRNIR-"_SRTN,XQAKILL=0 D DELETEA^XQALERT
 Q
DEL(SRTN,SP) ; check document status to determine if OK to delete/edit field
 ; SRTN - surgery case ien
 ; SP   - piece number in ^SRF(SRTN,"TIU"), comma delimited if multiple pieces
 ;
 N FLG,II,SRTIU,PCE S FLG=0
 S SRTIU=$G(^SRF(SRTN,"TIU")) F II=1:1:$L(SP,",") S PCE=$P(SP,",",II) I $P(SRTIU,"^",PCE) I $$CANDEL^TIUSRVP1($P(SRTIU,"^",PCE))=0 S FLG=1
 Q FLG
