RMPRPIXN ;HINCIO/ODJ - PIP STOCK ORDERS 661.41 file APIs ;3/8/01
 ;;3.0;PROSTHETICS;**61**;Feb 09, 1996
 Q
 ;
 ;***** GET - read in a HCPCS Item order record (661.41)
 ;
 ; Inputs:
 ;    RMPR41 - array of order data fields...
 ;    RMPR41("IEN") - ien of 661.41 record being read
 ;
 ; Outputs:
 ;    RMPR11 - HCPCS Item array
 ;    RMPR11("STATION") - Station name
 ;    RMPR11("HCPCS")   - HCPCS code
 ;    RMPR11("ITEM")    - HCPCS Item
 ;
 ;    RMPR41 - Order data fields array
 ;    RMPR41("DATE ORDER")   - Order date (external)
 ;    RMPR41("VENDOR")       - Vendor name
 ;    RMPR41("DATE RECEIVE") - Date of last receipt against the order
 ;                             (external)
 ;    RMPR41("ORDER QTY")    - Quantity ordered
 ;    RMPR41("RECEIVE QTY")  - Quantity received against the order
 ;    RMPR41("COMMENT")      - optional comment
 ;    RMPR41("BALANCE QTY")  - Balance quantity still on order
 ;    RMPR41("STATUS")       - Status (external)
 ;
 ;    RMPRERR - error status returned by function
 ;               0 - no problems
 ;               1 - invalid RMPR41("IEN") entered
 ;               2 - Problem with FM call
 ;
GET(RMPR41,RMPR11) ;
 N RMPRERR,RMPRIEN,RMPROUP,RMPRFME,X,Y,DA
 S RMPRERR=0
 I $G(RMPR41("IEN"))="" S RMPRERR=1 G GETX
 S RMPRIEN=RMPR41("IEN")_","
 D GETS^DIQ(661.41,RMPRIEN,"*","","RMPROUP","RMPRFME")
 I $D(RMPRFME) S RMPRERR=2 G GETX
 S RMPR11("STATION")=RMPROUP(661.41,RMPRIEN,2)
 S RMPR11("HCPCS")=RMPROUP(661.41,RMPRIEN,5)
 S RMPR11("ITEM")=RMPROUP(661.41,RMPRIEN,1)
 S RMPR41("VENDOR")=RMPROUP(661.41,RMPRIEN,4)
 S RMPR41("DATE ORDER")=RMPROUP(661.41,RMPRIEN,.01)
 S RMPR41("DATE RECEIVE")=RMPROUP(661.41,RMPRIEN,6)
 S RMPR41("ORDER QTY")=RMPROUP(661.41,RMPRIEN,7)
 S RMPR41("RECEIVE QTY")=RMPROUP(661.41,RMPRIEN,8)
 S RMPR41("COMMENT")=RMPROUP(661.41,RMPRIEN,9)
 S RMPR41("BALANCE QTY")=RMPR41("ORDER QTY")-RMPR41("RECEIVE QTY")
 S RMPR41("STATUS")=RMPROUP(661.41,RMPRIEN,10)
GETX Q RMPRERR
 ;
 ;***** GETI - get internal form of Order data fields
 ;
 ; Inputs and Outputs same as above for GET, except all internal values
 ; ie pointer's not names, internal not display date formats, etc.
 ;
GETI(RMPR41,RMPR11) ;
 N RMPRERR,RMPRIEN,RMPROUP,RMPRFME,X,Y,DA
 S RMPRERR=0
 I $G(RMPR41("IEN"))="" S RMPRERR=1 G GETX
 S RMPRIEN=RMPR41("IEN")_","
 D GETS^DIQ(661.41,RMPRIEN,"*","I","RMPROUP","RMPRFME")
 I $D(RMPRFME) S RMPRERR=2 G GETX
 S RMPR11("STATION")=RMPROUP(661.41,RMPRIEN,2,"I")
 S RMPR11("HCPCS")=RMPROUP(661.41,RMPRIEN,5,"I")
 S RMPR11("ITEM")=RMPROUP(661.41,RMPRIEN,1,"I")
 S RMPR41("VENDOR")=RMPROUP(661.41,RMPRIEN,4,"I")
 S RMPR41("DATE ORDER")=RMPROUP(661.41,RMPRIEN,.01,"I")
 S RMPR41("DATE RECEIVE")=RMPROUP(661.41,RMPRIEN,6,"I")
 S RMPR41("ORDER QTY")=RMPROUP(661.41,RMPRIEN,7,"I")
 S RMPR41("RECEIVE QTY")=RMPROUP(661.41,RMPRIEN,8,"I")
 S RMPR41("COMMENT")=RMPROUP(661.41,RMPRIEN,9,"I")
 S RMPR41("BALANCE QTY")=RMPR41("ORDER QTY")-RMPR41("RECEIVE QTY")
 S RMPR41("STATUS")=RMPROUP(661.41,RMPRIEN,10,"I")
GETIX Q RMPRERR
 ;
 ;***** UPD - Update an existing Order 661.41 record
 ;
 ; Inputs/Outputs - see above
 ; See GETI above for structure of RMPR41 and RMPR11 input arrays
 ; values must be in internal form
 ;
UPD(RMPR41,RMPR11) ;
 N RMPRERR,RMPRIEN,RMPROUP,RMPRFME,X,Y,DA
 S RMPRERR=0
 I $G(RMPR41("IEN"))="" S RMPRERR=1 G UPDX
 S RMPRIEN=RMPR41("IEN")_","
 S:$D(RMPR11("STATION")) RMPROUP(661.41,RMPRIEN,2)=RMPR11("STATION")
 S:$D(RMPR11("HCPCS")) RMPROUP(661.41,RMPRIEN,5)=RMPR11("HCPCS")
 S:$D(RMPR11("ITEM")) RMPROUP(661.41,RMPRIEN,1)=RMPR11("ITEM")
 S:$D(RMPR41("DATE ORDER")) RMPROUP(661.41,RMPRIEN,.01)=RMPR41("DATE ORDER")
 S:$D(RMPR41("DATE RECEIVE")) RMPROUP(661.41,RMPRIEN,6)=RMPR41("DATE RECEIVE")
 S:$D(RMPR41("VENDOR")) RMPROUP(661.41,RMPRIEN,4)=RMPR41("VENDOR")
 S:$D(RMPR41("ORDER QTY")) RMPROUP(661.41,RMPRIEN,7)=RMPR41("ORDER QTY")
 S:$D(RMPR41("RECEIVE QTY")) RMPROUP(661.41,RMPRIEN,8)=RMPR41("RECEIVE QTY")
 S:$D(RMPR41("COMMENT")) RMPROUP(661.41,RMPRIEN,9)=RMPR41("COMMENT")
 S:$D(RMPR41("STATUS")) RMPROUP(661.41,RMPRIEN,10)=RMPR41("STATUS")
 D:$D(RMPROUP) FILE^DIE("","RMPROUP","RMPRFME")
 I $D(RMPRFME) S RMPRERR=2
UPDX Q RMPRERR
 ;
 ;***** CRE - Create an Order 661.41 record
 ;
 ; Inputs/Outputs - see above
 ; See GETI above for structure of RMPR41 and RMPR11 input arrays
 ; values must be in internal form
 ;
CRE(RMPR41,RMPR11) ;
 N RMPRERR,RMPRIEN,RMPROUP,RMPRFME,X,Y,DA
 S RMPRERR=0
 S RMPROUP(661.41,"+1,",2)=RMPR11("STATION")
 S RMPROUP(661.41,"+1,",5)=RMPR11("HCPCS")
 S RMPROUP(661.41,"+1,",1)=RMPR11("ITEM")
 S:$D(RMPR41("DATE ORDER")) RMPROUP(661.41,"+1,",.01)=RMPR41("DATE ORDER")
 S:$D(RMPR41("DATE RECEIVE")) RMPROUP(661.41,"+1,",6)=RMPR41("DATE RECEIVE")
 S:$D(RMPR41("VENDOR")) RMPROUP(661.41,"+1,",4)=RMPR41("VENDOR")
 S:$D(RMPR41("ORDER QTY")) RMPROUP(661.41,"+1,",7)=RMPR41("ORDER QTY")
 S:$D(RMPR41("RECEIVE QTY")) RMPROUP(661.41,"+1,",8)=RMPR41("RECEIVE QTY")
 S RMPROUP(661.41,"+1,",9)=$G(RMPR41("COMMENT"))
 S RMPROUP(661.41,"+1,",10)=RMPR41("STATUS")
 D UPDATE^DIE("","RMPROUP","RMPRIEN","RMPRFME")
 I $D(RMPRFME) S RMPRERR=1
 S RMPR41("IEN")=RMPRIEN(1)
CREX Q RMPRERR
