PRCPHLQ ;WISC/CC - PROCESS HL7 QOH TRANSACTIONS FROM SUPPLY STATION; 4/00
V ;;5.1;IFCAP;**1**;Oct 20, 2000
 ;Per VHA Directive 10-93-142, this routine should not be modified.
 ;
 N DA,DIC,DIE,DIK,DLAYGO,DR,ERR,I,J,LNCNT,NUMBER,X,Y,WARN
 N PRCP7,PRCPDATA,PRCPHL,PRCPITEM,PRCPLEFT,PRCPOC,PRCPSEC,PRCPSECN
 N PRCPSITE,PRCPTIME,PRCPTXN,PRCPUSER
 S PRCPTXN=0,PRCPSEC="",LNCNT=1
 ;
 ;
OSR I HL("MTN")'="OSR" S ERR="1B" G ERR ; wrong message name
 X HLNEXT I HLQUIT'>0 S ERR="1A" G ERR ; missing MSH segment
 S PRCPHL(LNCNT)=HLNODE,LNCNT=LNCNT+1
 X HLNEXT I HLQUIT'>0 S ERR="1A" G ERR ; missing segments
 S PRCPHL(LNCNT)=HLNODE,J=0,LNCNT=LNCNT+1,I=1
 S X=$$FLD^HLCSUTL(HLNODE,1)
 I X'="MSA" S ERR="1A" G ERR ; wrong segment name
 S X=$$FLD^HLCSUTL(HLNODE,2)
 I X="AE"!(X="AR") S ERR="1F" G ERR ; supply station trouble
 ;
 X HLNEXT I HLQUIT'>0 S ERR="1A" G ERR ; missing segments
 S PRCPHL(LNCNT)=HLNODE,J=0,LNCNT=LNCNT+1,I=1
 S X=$$FLD^HLCSUTL(HLNODE,1)
 ;
 F  G:$D(ERR) ERR Q:X'="ERR"  D  ; can build user message from ERR segs
 . X HLNEXT I HLQUIT'>0 S ERR="1A",X="OUT" Q  ; missing segments
 . S PRCPHL(LNCNT)=HLNODE,J=0,LNCNT=LNCNT+1,I=1
 . S X=$$FLD^HLCSUTL(HLNODE,1)
 ;
 I X'="QRD" S ERR="1A" G ERR ; wrong segment name
 ;
QRD ; QRD SEGMENT
 I $$FLD^HLCSUTL(HLNODE,3)'="R"!($$FLD^HLCSUTL(HLNODE,4)'="D")!($$FLD^HLCSUTL(HLNODE,5)'="QOH")!($$FLD^HLCSUTL(HLNODE,10)'="STA") S ERR="1E" G ERR
 S J=$$FLD^HLCSUTL(HLNODE,13) I J]"",J'="S" S ERR="1E" G ERR
 ;
 X HLNEXT I HLQUIT'>0 S ERR="1A" G ERR ; missing segments
 S PRCPHL(LNCNT)=HLNODE,J=0,LNCNT=LNCNT+1,I=1
 I $$FLD^HLCSUTL(HLNODE,1)'="ORC" S ERR="1A" G ERR ; wrong segment name
 D ORC I $D(ERR) G ERR
 ;
 X HLNEXT I HLQUIT'>0 S ERR="1A" G ERR ; missing segments
 ;
LOOP S PRCPHL(LNCNT)=HLNODE,J=0,LNCNT=LNCNT+1,I=1
 I $$FLD^HLCSUTL(HLNODE,1)'="NTE" S ERR="1A" G ERR ; wrong segment name
NTE ; READ NTE SEGMENT
 S PRCPDATA=$$FLD^HLCSUTL(HLNODE,4) ; ID~NAME~QTY
 S PRCPITEM=$P(PRCPDATA,$E(HL("ECH"),1),1,2)
 I $P(PRCPITEM,$E(HL("ECH"),1),1)'=+PRCPITEM!(+PRCPITEM=0) D WARN X HLNEXT G Q:HLQUIT'>0  K WARN G LOOP ; item number invalid
 I '$D(^PRC(441,+PRCPITEM,0)) D WARN X HLNEXT G Q:HLQUIT'>0  K WARN G LOOP ; item number not in file 441
 ; I '$D(^PRCP(445,PRCPSECN,1,$P(PRCPITEM,$E(HL("ECH"),1),1))) S ERR="6C" G ERR
 ; I $P(^PRCP(445,PRCPSECN,1,$P(PRCPITEM,$E(HL("ECH"),1),1),0),"^",9)'>0 S ERR="6D" G ERR  ; is item a supply station item
 S PRCPLEFT=$P(PRCPDATA,$E(HL("ECH"),1),3)
 I +PRCPLEFT'=PRCPLEFT!(PRCPLEFT>999999)!(PRCPLEFT<-999999) S ERR=5 G ERR
 D PROCESS I $D(ERR) G ERR
 ;
 X HLNEXT I HLQUIT'>0 G Q
 G LOOP
 ;
 ; ORC SEGMENT
ORC S PRCPOC=$$FLD^HLCSUTL(HLNODE,2)
 S PRCPSEC=$$FLD^HLCSUTL(HLNODE,5)
 ;
 I PRCPOC'="OK" S ERR="1C" Q  ; order control wrong
 ;
 ; get site and IP information
 I PRCPSEC']"" S ERR="3A" Q
 S PRCPSEC=$P(PRCPSEC,$E(HL("ECH"),1),2)
 S PRCPSITE=$P(PRCPSEC,"-",1)
 I PRCPSITE']"" S ERR="3E" Q
 I '$D(^PRC(411,PRCPSITE,0)) S ERR="3D" Q  ; wrong site
 S DIC="^PRCP(445,",DIC(0)="X",X=PRCPSEC,PRCPPRIV=1
 D ^DIC K DIC
 I Y=-1 S ERR="3A" Q  ; secondary not in GIP
 S PRCPSECN=$P(Y,"^",1)
 I PRCPSECN']"" S ERR="3A" Q
 I $P(^PRCP(445,PRCPSECN,0),"^",3)'="S" S ERR="3B" Q  ; not a secondary
 ;
 S PRCPTIME=$$FLD^HLCSUTL(HLNODE,10)
 S PRCPTIME=$$FMDATE^HLFNC(PRCPTIME)
 S PRCPUSER=$$FLD^HLCSUTL(HLNODE,11)
 S PRCPUSER=$$FMNAME^HLFNC(PRCPUSER)
 Q
 ;
WARN N ITEM,PRCPXMY,XMB,XMDUZ,XMY
 D GETUSER^PRCPXTRM(PRCPSECN) Q:'$O(PRCPXMY(""))  ; send to secondary inventory point managers
 S ITEM=0
 F  S ITEM=$O(PRCPXMY(ITEM)) Q:ITEM'>0  I PRCPXMY(ITEM)=1 S XMY(ITEM)=""
 S XMB(1)=PRCPSEC
 S XMB(2)=PRCPITEM
 S XMB(3)=HLMTIENS_"."_HLMTIEN
 S XMB="PRCP_BAD_ITEM_QOH"
 S XMDUZ="SUPPLY STATION INTERFACE"
 D EN^XMB
 Q
 ;
PROCESS N %,%H,%I,DA,PRCPHL7,PRCPITNM,PRCPTXNT,PRCPMGTP,DIC,DIE,DR,N,T,X,Y
 I 'PRCPTXN D  I $D(ERR) Q
 . S X="PRCPHL7TXN"
 . I $D(^PRCS(410.1,"B",X)) D  I $D(ERR) Q
 . . S N="",N=$O(^PRCS(410.1,"B",X,N)),DA=N
 . . L +^PRCS(410.1,DA):15 I $T=0 S ERR=198
 . . S T=$P(^PRCS(410.1,N,0),"^",2)+1 S:T<1 T=1
 . I '$D(^PRCS(410.1,"B",X)) D  I $D(ERR) Q
 . . S T=1,DLAYGO=410.1,DIC="^PRCS(410.1,",DIC(0)="FLXZ"
 . . D ^DIC K DLAYGO I Y<0 S ERR=199
 . . S DA=+Y
 . . L +^PRCS(410.1,DA):15 I $T=0 S ERR=198
 . S $P(^PRCS(410.1,DA,0),"^",2)=+T
 . S $P(^PRCS(410.1,DA,0),"^",3)=DT
 . L -^PRCS(410.1,DA)
 . ;
 . S X=T
 . S DIC="^PRCP(447.1,"
 . S DIC(0)="L"
 . S DLAYGO=447.1
 . D ^DIC K DIC,DLAYGO
 . I Y=-1 S ERR=100 Q
 . I $P(Y,"^",3)'=1 S ERR=101 Q
 . S (DA,PRCPTXN)=Y+0
 . L +^PRCP(447.1,DA):3 I $T=0 S ERR=102 Q
 . S DIE="^PRCP(447.1,"
 . S DA=PRCPTXN
 . D NOW^%DTC
 . S PRCPTXNT=%
 . S PRCPMGTP=HL("MTN")_HL("ETN")
 . S PRCPHL7=HLMTIENS_"."_HLMTIEN
 . S DR="1///^S X=PRCPSITE;2///^S X=PRCPSECN;3///^S X=PRCPTXNT;4///^S X=PRCPMGTP;5///^S X=PRCPHL7;8///^S X=PRCPTIME"
 . D ^DIE
 . K DIE,DR
 S DIC="^PRCP(447.1,"_PRCPTXN_",1,"
 S DA(1)=PRCPTXN
 S DIC(0)="L"
 S DLAYGO=447.1
 S DIC("P")=$P(^DD(447.1,7,0),"^",2)
 S X=$P(PRCPITEM,$E(HL("ECH"),1),1)
 S PRCPSET="I 1" ; over rides screen to omit finding case carts/IK's
 D ^DIC K DIC,DA,DLAYGO
 I Y=-1 S ERR=110 Q
 I $P(Y,"^",3)'=1 S PRCPLEFT=PRCPLEFT+$P($G(^PRCP(447.1,PRCPTXN,1,+Y,0)),"^",2) ; add quantity for an item in different bins
 S DIE="^PRCP(447.1,"_PRCPTXN_",1,"
 S DA=+Y
 S PRCPITNM=$P(PRCPITEM,$E(HL("ECH"),1),2)
 S DR="1///^S X=PRCPLEFT;3///^S X=PRCPITNM"
 D ^DIE K DIC,DIE,DR
 Q
 ;
ERR ;
 I $D(ERR) S NUMBER=ERR
 I $D(WARN) S NUMBER=WARN
 S PRCP7("SIPNAME")="AN UNKNOWN INVENTORY POINT"
 I $D(PRCPSEC),PRCPSEC]"" S PRCP7("SIPNAME")=PRCPSEC
 I '$D(PRCPSECN) S PRCPSECN=0
 S PRCP7("ITEM")=""
 I $D(PRCPITEM) S PRCP7("ITEM")=$P(PRCPITEM,$E(HL("ECH"),1),1)
 S PRCP7("NAME")=""
 I $D(PRCPITEM) S PRCP7("NAME")=$P(PRCPITEM,$E(HL("ECH"),1),2)
 S PRCP7("LEFT")="" I $D(PRCPLEFT) S PRCP7("LEFT")=PRCPLEFT
 D ERR^PRCPHLM0(NUMBER,"PRCP_BAD_QUERY",PRCPSECN,.PRCP7,HLMTIENS_"."_HLMTIEN,.PRCPHL)
 I ERR,PRCPTXN S DA=PRCPTXN,DIK="^PRCP(447.1," D ^DIK
 ;
Q I PRCPTXN L -^PRCP(447.1,PRCPTXN)
 Q
