package gov.va.med.edp.weblogic;

/**
 * @author joseph.lemaire
 * 
 * Contains logic to ensure logged-in user's machine is valid to access EDIS.
 * 
 */
import java.security.cert.X509Certificate;

import org.apache.log4j.Logger;

//import weblogic.security.providers.authentication.UserNameMapper;

public class EDPUserNameMapper {

	// Logic needs to be re-factored to migrate from Weblogic 8.1 to Weblogic 10.3.5 functiuonality.
	// Will use javax resources to authenticate user.
    private static Logger logger = Logger.getLogger(EDPUserNameMapper.class);

    /**  Maps a certificate to a user, based on a valid machine name
     * 
     * @param certs
     * @param ssl
     * @return   the valid machine name
     */
	public String mapCertificateToUserName(X509Certificate[] certs, boolean ssl) {
		String machineName = "";

		
		if (certs.length > 0) {
			String dn = certs[0].getSubjectDN().getName();
			if (logger.isDebugEnabled()){
				logger.debug("Certificate Contents: " + dn);
			}
			String[] parts = dn.split(",");
			for (int i = 0; i < parts.length; i++) {
				String dName = parts[i];
				if (dName.indexOf("CN=") != -1){
					machineName = dName.trim().substring(3);
				}

				if (machineName.length() == 0){
					throw new IllegalStateException("Machine Name obtained from the client SSL Certificate is not valid. The machine name was empty");
				}

				WeblogicUserManager.addUserToWeblogicSecurity(machineName);

				if (logger.isDebugEnabled()){
					logger.debug("SUCCESS!!...Returning Machine Name: '" + machineName + "' for Weblogic Security");
				}
				
				return machineName;
			}
				
		}
		return "INVALID_USER";
	}
	
	/**  A deprecated method
	 * @throws UnsupportedOperationException   
	 * @param arg0
	 * @return  returns an error message
	 */
	public String mapDistinguishedNameToUserName(byte[] arg0) {
		throw new UnsupportedOperationException("The method 'mapDistinguishedNameToUserName' in class " + getClass().getName() + " is not supported");
	}

	

	
	
}
