package gov.va.med.edp.vistalink.locator;

import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionFactory;
import gov.va.med.vistalink.institution.InstitutionMapNotInitializedException;
import gov.va.med.vistalink.institution.InstitutionMappingDelegate;
import gov.va.med.vistalink.institution.InstitutionMappingNotFoundException;
import gov.va.med.edp.vistalink.ConnectionFactoryLocator;
import org.springframework.dao.DataAccessResourceFailureException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.cci.ConnectionFactory;
import java.text.MessageFormat;

public class InstitutionMappingConnectionFactoryLocator implements ConnectionFactoryLocator {
    private static final String NO_CONNECTION_FACTORY = "Unable to obtain connection factory for station ''{0}''";
    private static final String NO_CONNECTION_FACTORY_JNDI = "Unable to obtain connection factory for station ''{0}'' at JNDI name ''{1}''";

    public ConnectionFactory getConnectionFactory(String stationNumber) throws DataAccessResourceFailureException {
        try {
            String jndiConnectorName = InstitutionMappingDelegate.getJndiConnectorNameForInstitution(
                    stationNumber);
            try {
                Context ic = new InitialContext();
                VistaLinkConnectionFactory vistaLinkConnectionFactory = (VistaLinkConnectionFactory) ic.lookup(jndiConnectorName);
                ic.close();
                if (vistaLinkConnectionFactory == null)
                throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY_JNDI, new Object[] {stationNumber, jndiConnectorName}));
//                    throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY_JNDI, stationNumber, jndiConnectorName)); // TODO: switch to this one in java 5
                return vistaLinkConnectionFactory;
            } catch (NamingException e) {
                 throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY_JNDI, new Object[] {stationNumber, jndiConnectorName}), e);
//                throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY_JNDI, stationNumber, jndiConnectorName), e); // TODO: switch to this one in java 5
            }
        } catch (InstitutionMappingNotFoundException e) {
            throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY, new Object[] {stationNumber}), e);
//            throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY, stationNumber), e); // TODO: switch to this one in java 5
        } catch (InstitutionMapNotInitializedException e) {
            throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY, new Object[] {stationNumber}), e);
//            throw new DataAccessResourceFailureException(MessageFormat.format(NO_CONNECTION_FACTORY, stationNumber), e); // TODO: switch to this one in java 5
        }

    }
}
