package gov.va.med.edp.vistalink.adapter.spi;

/**
 * @author joseph.lemaire
 * 
 * Sets the EDIS VA station number as selected by the user
 */
import org.springframework.beans.factory.InitializingBean;
import gov.va.med.vistalink.adapter.spi.EMAdapterEnvironment;

public class VistaLinkManagedConnectionFactory extends gov.va.med.vistalink.adapter.spi.VistaLinkManagedConnectionFactory implements InitializingBean {

	// Added by J Lemaire 09/25/11
	// UID required by parent class 
	private static final long serialVersionUID = 1L;
	
    private String stationNumber;

    public void afterPropertiesSet() throws Exception {
        setPrimaryStation(stationNumber);
        setAdapterEnvironment(EMAdapterEnvironment.J2EE);
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }
}
