package gov.va.med.edp.web.view;

import org.springframework.web.servlet.view.AbstractView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;
/**
 * Handles creation of a xml view for results.
 *
 */
public class XmlView extends AbstractView {
    /**
     * The xml fragment type.
     */
	public static final String XML_FRAGMENT = "xmlFragment";
    /**
     * Constructor.
     */
    public XmlView() {
        setContentType("text/xml;charset=utf-8");
    }
    /* (non-Javadoc)
     * @see org.springframework.web.servlet.view.AbstractView#renderMergedOutputModel(java.util.Map, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
	 /**
	  * Display the data fragment in HTTP.
	  * @param map The data Map
	  * @param request The HTTP request.
	  * @param response The HTTP response.
	  */
    protected void renderMergedOutputModel(Map map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpCacheControl.addNoCacheHeaders(response);

        response.getWriter().println("<?xml version='1.0' encoding='UTF-8'?>");
        response.getWriter().println("<results>");
        response.getWriter().println(map.get(XML_FRAGMENT));
        response.getWriter().println("</results>");
        response.getWriter().close();
    }
}
