package gov.va.med.edp.web.view;

import org.springframework.web.servlet.support.WebContentGenerator;

import javax.servlet.http.HttpServletResponse;

/**
 * Adds cache control for http headers.
 */
public class HttpCacheControl {
    static final java.lang.String HEADER_CACHE_CONTROL = "Cache-Control";
    static final java.lang.String HEADER_EXPIRES = "Expires";
    /**
     * Adds cache control for response.
     * @param response The HttpServletResponse.
     */
    public static void addNoCacheHeaders(HttpServletResponse response) {
        response.setHeader(HEADER_CACHE_CONTROL, "no-store, must-revalidate");
        response.setHeader(HEADER_EXPIRES, "Thu, 01 Jan 1970 01:00:00 GMT");
    }
}
