package gov.va.med.edp.web.view;

import org.springframework.web.servlet.view.AbstractView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;
/**
 * Handles creation of a comma separated value view for exporting of reports.
 *
 */
public class CsvView extends AbstractView {
    /**
     * Model for csv.
     */
    public static final String CSV_MODEL = "csvModel";   
    private static final String CONTENT_TYPE = "application/vnd.ms-excel";
    /**
     * Constructor.
     */
    public CsvView() {
       setContentType(CONTENT_TYPE);
    }
    /* (non-Javadoc)
     * @see org.springframework.web.servlet.view.AbstractView#renderMergedOutputModel(java.util.Map, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
	 /**
	  * Pass the data Map, containing visualizations, to HTTP.
	  * @param map The data visualization.
	  * @param request The HTTP request.
	  * @param response The HTTP response.
	  */
    protected void renderMergedOutputModel(Map map, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpCacheControl.addNoCacheHeaders(response);
        response.getWriter().print(map.get(CSV_MODEL));
        response.getWriter().close();
    }
}
